/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.environment.ecore;

import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMIResource;
import org.eclipse.ocl.Environment;
import org.eclipse.ocl.EnvironmentFactory;
import org.eclipse.ocl.TypeResolver;
import org.eclipse.ocl.cst.CSTNode;
import org.eclipse.ocl.ecore.CallOperationAction;
import org.eclipse.ocl.ecore.Constraint;
import org.eclipse.ocl.ecore.EcoreFactory;
import org.eclipse.ocl.ecore.InvalidLiteralExp;
import org.eclipse.ocl.ecore.SendSignalAction;
import org.eclipse.ocl.examples.parser.environment.CSTRootEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTFileEcoreEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTNodeEcoreEnvironment;
import org.eclipse.ocl.examples.parser.environment.ecore.ICSTRootEcoreEnvironment;
import org.eclipse.ocl.expressions.OCLExpression;
import org.eclipse.ocl.expressions.Variable;
import org.eclipse.ocl.types.OCLStandardLibrary;
import org.eclipse.ocl.utilities.OCLFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CSTRootEcoreEnvironment<V extends ICSTNodeEcoreEnvironment, CST extends CSTNode>
extends CSTRootEnvironment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject, V, CST>
implements ICSTRootEcoreEnvironment {
    protected CSTRootEcoreEnvironment(ICSTFileEcoreEnvironment fileEnvironment, XMIResource astNode, CST cstNode) {
        super(fileEnvironment, astNode, cstNode);
    }

    @Override
    public boolean checkFeatureCompatibility(CSTNode cstNode, EClassifier featureType, OCLExpression<EClassifier> oclExpression) {
        return false;
    }

    protected void collectStates(EClassifier owner, List<String> pathPrefix, List<EObject> states) {
    }

    @Override
    public InvalidLiteralExp createInvalidLiteralExp(CSTNode cstNode) {
        return EcoreFactory.eINSTANCE.createInvalidLiteralExp();
    }

    public EStructuralFeature defineAttribute(EClassifier owner, Variable<EClassifier, EParameter> variable, Constraint constraint) {
        String name = variable.getName();
        EClassifier type = (EClassifier)variable.getType();
        Object result = type instanceof EClass ? org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEReference() : org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAttribute();
        result.setName(name);
        result.setEType(type);
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperProperty(owner, result);
        return result;
    }

    public EOperation defineOperation(EClassifier owner, String name, EClassifier type, List<Variable<EClassifier, EParameter>> params, Constraint constraint) {
        EOperation result = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEOperation();
        result.setName(name);
        result.setEType(type == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : type);
        for (Variable<EClassifier, EParameter> next : params) {
            EParameter param = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEParameter();
            param.setName(next.getName());
            param.setEType(next.getType() == null ? (EClassifier)this.getOCLStandardLibrary().getOclVoid() : (EClassifier)next.getType());
            result.getEParameters().add((Object)param);
        }
        Constraint existing = this.getDefinition(result);
        if (existing != null) {
            EcoreUtil.replace((EObject)existing, (EObject)constraint);
        } else {
            EAnnotation ann = result.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
            if (ann == null) {
                ann = org.eclipse.emf.ecore.EcoreFactory.eINSTANCE.createEAnnotation();
                ann.setSource("http://www.eclipse.org/ocl/1.1.0/OCL");
                result.getEAnnotations().add((Object)ann);
            }
            ann.getContents().add((Object)constraint);
        }
        this.addHelperOperation(owner, result);
        return result;
    }

    public Constraint getDefinition(Object feature) {
        Constraint result = null;
        ETypedElement typedFeature = (ETypedElement)feature;
        EAnnotation ann = typedFeature.getEAnnotation("http://www.eclipse.org/ocl/1.1.0/OCL");
        if (ann != null && !ann.getContents().isEmpty()) {
            for (EObject o : ann.getContents()) {
                if (!(o instanceof Constraint) || !"definition".equals(((Constraint)o).getStereotype())) continue;
                result = (Constraint)o;
                break;
            }
        }
        return result;
    }

    public EnvironmentFactory<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> getFactory() {
        return this.fileEnvironment.getFactory();
    }

    public OCLFactory getOCLFactory() {
        return this.fileEnvironment.getOCLFactory();
    }

    public OCLStandardLibrary<EClassifier> getOCLStandardLibrary() {
        return this.fileEnvironment.getOCLStandardLibrary();
    }

    public List<EObject> getStates(EClassifier owner, List<String> pathPrefix) {
        BasicEList result = new BasicEList();
        this.collectStates(owner, pathPrefix, (List<EObject>)result);
        if (owner instanceof EClass) {
            for (EClass superclass : ((EClass)owner).getEAllSuperTypes()) {
                this.collectStates((EClassifier)superclass, pathPrefix, (List<EObject>)result);
            }
        }
        return result;
    }

    public TypeResolver<EClassifier, EOperation, EStructuralFeature> getTypeResolver() {
        return this.fileEnvironment.getTypeResolver();
    }

    public boolean isInPostcondition(OCLExpression<EClassifier> exp) {
        Constraint constraint = null;
        EObject parent = exp;
        while (parent != null) {
            if (parent instanceof Constraint) {
                constraint = (Constraint)parent;
                break;
            }
            parent = parent.eContainer();
        }
        return constraint != null && "postcondition".equals(constraint.getStereotype());
    }

    public EPackage lookupPackage(List<String> path) {
        return (EPackage)this.fileEnvironment.lookupPackage(path);
    }

    public void setParent(Environment<EPackage, EClassifier, EOperation, EStructuralFeature, EEnumLiteral, EParameter, EObject, CallOperationAction, SendSignalAction, Constraint, EClass, EObject> env) {
        this.fileEnvironment.setParent(env);
    }

    public void undefine(Object feature) {
        Constraint definition = this.getDefinition(feature);
        if (definition == null) {
            throw new IllegalArgumentException("not an additional feature: " + feature);
        }
        EcoreUtil.remove((EObject)((EObject)feature));
        EcoreUtil.remove((EObject)definition);
        definition.getConstrainedElements().clear();
    }
}

