/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.parser.utils;

import java.util.Collection;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.common.plugin.OCLExamplesCommonPlugin;
import org.eclipse.ocl.examples.parser.utils.ICommonASTVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class CommonASTVisitor<T, N>
implements ICommonASTVisitor<T, N> {
    protected final Class<N> nodeClass;
    protected T result = null;

    protected CommonASTVisitor(Class<N> nodeClass) {
        this.nodeClass = nodeClass;
    }

    public T enter(Object object) {
        if (object == null) {
            return null;
        }
        if (this.nodeClass.isAssignableFrom(object.getClass())) {
            Object astNode = object;
            return this.visit(astNode);
        }
        if (object instanceof Collection) {
            Collection collection = (Collection)object;
            return this.enterCollection(collection);
        }
        return this.unexpectedVisit(object);
    }

    protected T enterCollection(Collection<?> collection) {
        return this.unexpectedVisit(collection);
    }

    protected T postVisit(N astNode) {
        return this.result;
    }

    protected boolean preVisit(N astNode) {
        return true;
    }

    protected T unexpectedVisit(Object astNode) {
        OCLExamplesCommonPlugin.logError((String)("Unexpected visit to a '" + astNode.getClass().getName() + "' by a '" + this.getClass().getSimpleName() + "'"), null);
        return null;
    }

    @Override
    public T visit(N astNode) {
        if (!this.preVisit(astNode)) {
            return null;
        }
        if (astNode instanceof EObject) {
            this.visitEObject(astNode);
        } else if (astNode instanceof Resource) {
            this.visitResource((Resource)astNode);
        } else if (astNode instanceof ResourceSet) {
            this.visitResourceSet((ResourceSet)astNode);
        } else {
            this.vistNode(astNode);
        }
        return this.postVisit(astNode);
    }

    protected void visitEObject(N astNode) {
        for (EObject eObject : ((EObject)astNode).eContents()) {
            this.enter(eObject);
        }
    }

    protected void vistNode(Object astNode) {
        OCLExamplesCommonPlugin.logError((String)("Unimplemented visit to a '" + astNode.getClass().getName() + "' by a '" + this.getClass().getSimpleName() + "'"), null);
    }

    protected void visitResource(Resource astNode) {
        for (EObject eObject : astNode.getContents()) {
            this.enter(eObject);
        }
    }

    protected void visitResourceSet(ResourceSet astNode) {
        for (Resource resource : astNode.getResources()) {
            this.enter(resource);
        }
    }
}

