/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.delegate;

import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.QueryDelegate;
import org.eclipse.ocl.examples.pivot.EvaluationException;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OCL;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateDomain;
import org.eclipse.ocl.examples.pivot.delegate.OCLDelegateException;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OCLQueryDelegate
implements QueryDelegate {
    protected final OCLDelegateDomain delegateDomain;
    protected final ExpressionInOcl specification;

    public OCLQueryDelegate(OCLDelegateDomain delegateDomain, ExpressionInOcl specification) {
        this.delegateDomain = delegateDomain;
        this.specification = specification;
    }

    public void prepare() throws InvocationTargetException {
        TypeManager typeManager = this.delegateDomain.getTypeManager();
        try {
            String expression = PivotUtil.getBody(this.specification);
            URI uri = typeManager.getResourceIdentifier(this, null);
            PivotUtil.resolveSpecification(typeManager, uri, this.specification, expression);
        }
        catch (Exception e) {
            throw new InvocationTargetException(e);
        }
    }

    public Object execute(Object target, Map<String, ?> arguments) throws InvocationTargetException {
        if (this.specification.getBodyExpression() == null) {
            this.prepare();
        }
        try {
            int argCount;
            OCL ocl = this.delegateDomain.getOCL();
            TypeManager typeManager = ocl.getTypeManager();
            ValueFactory valueFactory = typeManager.getValueFactory();
            Value targetValue = valueFactory.valueOf(target);
            Type targetType = targetValue.getType(typeManager, null);
            Type requiredType = this.specification.getContextVariable().getType();
            if (!typeManager.conformsTo(targetType, requiredType, null)) {
                String message = NLS.bind((String)OCLMessages.WrongContextClassifier_ERROR_, (Object)targetType, (Object)requiredType);
                throw new OCLDelegateException(message);
            }
            EList<Variable> parameterVariables = this.specification.getParameterVariables();
            int n = argCount = arguments != null ? arguments.size() : 0;
            if (parameterVariables.size() != argCount) {
                String message = NLS.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object)argCount, (Object)parameterVariables.size());
                throw new OCLDelegateException(message);
            }
            OCL.Query query = ocl.createQuery(this.specification);
            EvaluationEnvironment env = query.getEvaluationEnvironment();
            for (Variable parameterVariable : parameterVariables) {
                String name = parameterVariable.getName();
                Object object = arguments.get(name);
                if (object == null && !arguments.containsKey(name)) {
                    String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)PivotUtil.getBody(this.specification));
                    throw new OCLDelegateException(message);
                }
                Value value = valueFactory.valueOf(object);
                targetType = value.getType(typeManager, null);
                if (!typeManager.conformsTo(targetType, requiredType = parameterVariable.getType(), null)) {
                    String message = NLS.bind((String)OCLMessages.MismatchedArgumentType_ERROR_, (Object[])new Object[]{name, targetType, requiredType});
                    throw new OCLDelegateException(message);
                }
                env.add(parameterVariable, value);
            }
            Value result = query.evaluate(target);
            return valueFactory.getEcoreValueOf(result);
        }
        catch (EvaluationException e) {
            String message = NLS.bind((String)OCLMessages.EvaluationResultIsInvalid_ERROR_, (Object)PivotUtil.getBody(this.specification));
            throw new InvocationTargetException((Throwable)((Object)new OCLDelegateException(message)));
        }
        catch (OCLDelegateException e) {
            throw new InvocationTargetException((Throwable)((Object)e));
        }
    }

    public String toString() {
        OclExpression bodyExpression = this.specification.getBodyExpression();
        if (bodyExpression != null) {
            return "<" + this.delegateDomain.getURI() + ":query> " + bodyExpression;
        }
        return "<" + this.delegateDomain.getURI() + ":query> " + PivotUtil.getBody(this.specification);
    }
}

