/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.ecore;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.EGenericType;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EOperation;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EParameter;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.ETypeParameter;
import org.eclipse.emf.ecore.ETypedElement;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.ocl.examples.common.utils.StringUtils;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.ecore.Pivot2Ecore;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2EcoreDeclarationVisitor
extends AbstractExtendingVisitor<EObject, Pivot2Ecore> {
    public Pivot2EcoreDeclarationVisitor(Pivot2Ecore context) {
        super(context);
    }

    protected void copyClassifier(EClassifier eClassifier, Type pivotType) {
        this.copyNamedElement((ENamedElement)eClassifier, pivotType);
        this.copyTemplateSignature((List<ETypeParameter>)eClassifier.getETypeParameters(), pivotType);
        this.safeVisitAll((List)eClassifier.getEAnnotations(), (List<? extends Element>)pivotType.getOwnedAnnotations());
        if (pivotType.eIsSet((EStructuralFeature)PivotPackage.Literals.TYPE__INSTANCE_CLASS_NAME)) {
            eClassifier.setInstanceClassName(pivotType.getInstanceClassName());
        } else {
            eClassifier.eUnset((EStructuralFeature)EcorePackage.Literals.ECLASSIFIER__INSTANCE_CLASS_NAME);
        }
        for (Constraint pivotConstraint : pivotType.getOwnedRules()) {
            if (pivotConstraint.isCallable()) continue;
            this.safeVisit(pivotConstraint);
        }
        Pivot2Ecore.installDelegates(((Pivot2Ecore)((Object)this.context)).getTypeManager(), eClassifier, pivotType);
    }

    protected void copyDataTypeOrEnum(EDataType eDataType, DataType pivotDataType) {
        this.copyClassifier((EClassifier)eDataType, pivotDataType);
        eDataType.setSerializable(pivotDataType.isSerializable());
    }

    protected void copyDetails(EAnnotation eAnnotation, Annotation pivotAnnotation) {
        this.copyModelElement((EModelElement)eAnnotation, pivotAnnotation);
        this.safeVisitAll((List)eAnnotation.getEAnnotations(), (List<? extends Element>)pivotAnnotation.getOwnedAnnotations());
        for (Detail pivotDetail : pivotAnnotation.getOwnedDetails()) {
            String name = pivotDetail.getName();
            String value = StringUtils.splice(pivotDetail.getValues(), (String)"");
            eAnnotation.getDetails().put((Object)name, (Object)value);
        }
    }

    protected void copyModelElement(EModelElement eModelElement, MonikeredElement pivotModelElement) {
        ((Pivot2Ecore)((Object)this.context)).putCreated(pivotModelElement, eModelElement);
    }

    protected void copyNamedElement(ENamedElement eNamedElement, NamedElement pivotNamedElement) {
        this.copyModelElement((EModelElement)eNamedElement, pivotNamedElement);
        eNamedElement.setName(pivotNamedElement.getName());
    }

    protected void copyTemplateSignature(List<ETypeParameter> eTypeParameters, TemplateableElement pivotElement) {
        TemplateSignature templateSignature = pivotElement.getOwnedTemplateSignature();
        if (templateSignature != null) {
            EList<TemplateParameter> parameters = templateSignature.getParameters();
            this.safeVisitAll((List)eTypeParameters, (List<? extends Element>)parameters);
        }
    }

    protected void copyTypedElement(ETypedElement eTypedElement, TypedMultiplicityElement pivotTypedElement) {
        this.copyNamedElement((ENamedElement)eTypedElement, pivotTypedElement);
        this.safeVisitAll((List)eTypedElement.getEAnnotations(), (List<? extends Element>)pivotTypedElement.getOwnedAnnotations());
        ((Pivot2Ecore)((Object)this.context)).defer(pivotTypedElement);
        eTypedElement.setLowerBound(pivotTypedElement.getLower().intValue());
        eTypedElement.setUpperBound(pivotTypedElement.getUpper().intValue());
        eTypedElement.setUnique(pivotTypedElement.isUnique());
        eTypedElement.setOrdered(pivotTypedElement.isOrdered());
    }

    public <T extends EObject> void safeVisitAll(List<T> eObjects, List<? extends Element> pivotObjects) {
        for (Element element : pivotObjects) {
            EObject eObject = (EObject)this.safeVisit(element);
            if (eObject == null) continue;
            eObjects.add(eObject);
        }
    }

    @Override
    public EObject visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Ecore Declaration pass");
    }

    @Override
    public EObject visitAnnotation(Annotation pivotAnnotation) {
        EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
        this.copyDetails(eAnnotation, pivotAnnotation);
        eAnnotation.setSource(pivotAnnotation.getName());
        this.safeVisitAll((List)eAnnotation.getContents(), (List<? extends Element>)pivotAnnotation.getOwnedContents());
        if (!pivotAnnotation.getReferences().isEmpty()) {
            ((Pivot2Ecore)((Object)this.context)).defer(pivotAnnotation);
        }
        return eAnnotation;
    }

    @Override
    public EObject visitClass(Class pivotClass) {
        if (pivotClass.getTemplateBindings().size() > 0) {
            return null;
        }
        EClass eClass = EcoreFactory.eINSTANCE.createEClass();
        this.copyClassifier((EClassifier)eClass, pivotClass);
        eClass.setAbstract(pivotClass.isAbstract());
        eClass.setInterface(pivotClass.isInterface());
        ((Pivot2Ecore)((Object)this.context)).defer(pivotClass);
        this.safeVisitAll((List)eClass.getEOperations(), (List<? extends Element>)pivotClass.getOwnedOperations());
        this.safeVisitAll((List)eClass.getEStructuralFeatures(), (List<? extends Element>)pivotClass.getOwnedAttributes());
        for (Constraint pivotConstraint : pivotClass.getOwnedRules()) {
            if (!pivotConstraint.isCallable()) continue;
            EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
            eOperation.setName(pivotConstraint.getName());
            eOperation.setEType((EClassifier)EcorePackage.Literals.EBOOLEAN);
            EParameter firstParameter = EcoreFactory.eINSTANCE.createEParameter();
            firstParameter.setName("diagnostics");
            firstParameter.setEType((EClassifier)EcorePackage.Literals.EDIAGNOSTIC_CHAIN);
            eOperation.getEParameters().add((Object)firstParameter);
            EParameter secondParameter = EcoreFactory.eINSTANCE.createEParameter();
            secondParameter.setName("context");
            EGenericType eGenericType = EcoreFactory.eINSTANCE.createEGenericType();
            eGenericType.setEClassifier((EClassifier)EcorePackage.Literals.EMAP);
            EGenericType firstTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
            firstTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
            eGenericType.getETypeArguments().add((Object)firstTypeArgument);
            EGenericType secondTypeArgument = EcoreFactory.eINSTANCE.createEGenericType();
            secondTypeArgument.setEClassifier((EClassifier)EcorePackage.Literals.EJAVA_OBJECT);
            eGenericType.getETypeArguments().add((Object)secondTypeArgument);
            secondParameter.setEGenericType(eGenericType);
            eOperation.getEParameters().add((Object)secondParameter);
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("http://www.eclipse.org/emf/2002/Ecore/OCL/Pivot");
            eAnnotation.getDetails().put((Object)"body", (Object)PivotUtil.getBody((OpaqueExpression)pivotConstraint.getSpecification()));
            eOperation.getEAnnotations().add((Object)eAnnotation);
            eClass.getEOperations().add((Object)eOperation);
            ((Pivot2Ecore)((Object)this.context)).putCreated(pivotConstraint, (EModelElement)eOperation);
            Pivot2Ecore.installDelegate((EModelElement)eOperation, pivotConstraint);
        }
        return eClass;
    }

    @Override
    public EObject visitConstraint(Constraint pivotConstraint) {
        EModelElement eModelElement = ((Pivot2Ecore)((Object)this.context)).getCreated(EModelElement.class, (Element)pivotConstraint.eContainer());
        Pivot2Ecore.installDelegate(eModelElement, pivotConstraint);
        return null;
    }

    @Override
    public EObject visitDataType(DataType pivotDataType) {
        if (pivotDataType.getTemplateBindings().size() > 0) {
            return null;
        }
        EDataType eDataType = EcoreFactory.eINSTANCE.createEDataType();
        this.copyDataTypeOrEnum(eDataType, pivotDataType);
        return eDataType;
    }

    @Override
    public EObject visitDetail(Detail object) {
        return (EObject)super.visitDetail(object);
    }

    @Override
    public EObject visitEnumeration(Enumeration pivotEnumeration) {
        if (pivotEnumeration.getTemplateBindings().size() > 0) {
            return null;
        }
        EEnum eEnum = EcoreFactory.eINSTANCE.createEEnum();
        this.copyDataTypeOrEnum((EDataType)eEnum, pivotEnumeration);
        this.safeVisitAll((List)eEnum.getELiterals(), (List<? extends Element>)pivotEnumeration.getOwnedLiterals());
        return eEnum;
    }

    @Override
    public EObject visitEnumerationLiteral(EnumerationLiteral pivotEnumLiteral) {
        EEnumLiteral eEnumLiteral = EcoreFactory.eINSTANCE.createEEnumLiteral();
        this.copyNamedElement((ENamedElement)eEnumLiteral, pivotEnumLiteral);
        if (pivotEnumLiteral.eIsSet((EStructuralFeature)PivotPackage.Literals.ENUMERATION_LITERAL__VALUE)) {
            eEnumLiteral.setValue(pivotEnumLiteral.getValue().intValue());
        } else {
            eEnumLiteral.eUnset((EStructuralFeature)EcorePackage.Literals.EENUM_LITERAL__VALUE);
        }
        return eEnumLiteral;
    }

    @Override
    public EObject visitOperation(Operation pivotOperation) {
        if (pivotOperation.getTemplateBindings().size() > 0) {
            return null;
        }
        EOperation eOperation = EcoreFactory.eINSTANCE.createEOperation();
        this.copyTypedElement((ETypedElement)eOperation, pivotOperation);
        this.copyTemplateSignature((List<ETypeParameter>)eOperation.getETypeParameters(), pivotOperation);
        this.safeVisitAll((List)eOperation.getEParameters(), (List<? extends Element>)pivotOperation.getOwnedParameters());
        for (Constraint pivotConstraint : pivotOperation.getOwnedRules()) {
            this.safeVisit(pivotConstraint);
        }
        return eOperation;
    }

    @Override
    public EObject visitPackage(Package pivotPackage) {
        EPackage ePackage = EcoreFactory.eINSTANCE.createEPackage();
        this.copyNamedElement((ENamedElement)ePackage, pivotPackage);
        this.safeVisitAll((List)ePackage.getEAnnotations(), (List<? extends Element>)pivotPackage.getOwnedAnnotations());
        ((Pivot2Ecore)((Object)this.context)).defer(pivotPackage);
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_PREFIX)) {
            ePackage.setNsPrefix(pivotPackage.getNsPrefix());
        }
        if (pivotPackage.eIsSet((EStructuralFeature)PivotPackage.Literals.PACKAGE__NS_URI)) {
            ePackage.setNsURI(pivotPackage.getNsURI());
        }
        this.safeVisitAll((List)ePackage.getESubpackages(), (List<? extends Element>)pivotPackage.getNestedPackages());
        this.safeVisitAll((List)ePackage.getEClassifiers(), (List<? extends Element>)pivotPackage.getOwnedTypes());
        return ePackage;
    }

    @Override
    public EObject visitParameter(Parameter pivotParameter) {
        EParameter eParameter = EcoreFactory.eINSTANCE.createEParameter();
        this.copyTypedElement((ETypedElement)eParameter, pivotParameter);
        return eParameter;
    }

    @Override
    public EObject visitProperty(Property pivotProperty) {
        EAttribute eStructuralFeature;
        if (pivotProperty.isImplicit()) {
            return null;
        }
        Type type = pivotProperty.getType();
        if (type instanceof DataType) {
            EAttribute eAttribute = EcoreFactory.eINSTANCE.createEAttribute();
            eAttribute.setID(pivotProperty.isID());
            eStructuralFeature = eAttribute;
        } else {
            EReference eReference = EcoreFactory.eINSTANCE.createEReference();
            if (pivotProperty.getOpposite() != null || !pivotProperty.getKeys().isEmpty()) {
                ((Pivot2Ecore)((Object)this.context)).defer(pivotProperty);
            }
            eReference.setContainment(pivotProperty.isComposite());
            eReference.setResolveProxies(pivotProperty.isResolveProxies());
            eStructuralFeature = eReference;
        }
        this.copyTypedElement((ETypedElement)eStructuralFeature, pivotProperty);
        eStructuralFeature.setChangeable(!pivotProperty.isReadOnly());
        eStructuralFeature.setDerived(pivotProperty.isDerived());
        eStructuralFeature.setTransient(pivotProperty.isTransient());
        eStructuralFeature.setUnsettable(pivotProperty.isUnsettable());
        eStructuralFeature.setVolatile(pivotProperty.isVolatile());
        if (pivotProperty.eIsSet((EStructuralFeature)PivotPackage.Literals.PROPERTY__DEFAULT)) {
            eStructuralFeature.setDefaultValueLiteral(pivotProperty.getDefault());
        } else {
            eStructuralFeature.eUnset((EStructuralFeature)EcorePackage.Literals.ESTRUCTURAL_FEATURE__DEFAULT_VALUE_LITERAL);
        }
        for (Constraint pivotConstraint : pivotProperty.getOwnedRules()) {
            this.safeVisit(pivotConstraint);
        }
        return eStructuralFeature;
    }

    @Override
    public EObject visitTypeTemplateParameter(TypeTemplateParameter pivotTypeTemplateParameter) {
        ETypeParameter eTypeParameter = EcoreFactory.eINSTANCE.createETypeParameter();
        eTypeParameter.setName(((Type)pivotTypeTemplateParameter.getParameteredElement()).getName());
        ((Pivot2Ecore)((Object)this.context)).putCreated(pivotTypeTemplateParameter, (EModelElement)eTypeParameter);
        if (!pivotTypeTemplateParameter.getConstrainingTypes().isEmpty()) {
            ((Pivot2Ecore)((Object)this.context)).defer(pivotTypeTemplateParameter);
        }
        return eTypeParameter;
    }
}

