/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.ocl.examples.pivot.Adaptable;
import org.eclipse.ocl.examples.pivot.Customizable;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OCLUtil;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.options.Option;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.NullValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationEnvironment
implements EvaluationEnvironment,
Adaptable,
Customizable {
    protected final TypeManager typeManager;
    private final EvaluationEnvironment parent;
    private final Map<VariableDeclaration, Value> variableValues = new HashMap<VariableDeclaration, Value>();
    private final Map<Option<?>, Object> options = new HashMap();

    protected AbstractEvaluationEnvironment(TypeManager typeManager) {
        this.typeManager = typeManager;
        this.parent = null;
    }

    protected AbstractEvaluationEnvironment(EvaluationEnvironment parent) {
        this.typeManager = parent.getTypeManager();
        this.parent = parent;
    }

    protected EvaluationEnvironment getParent() {
        return this.parent;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    @Override
    public Value getValueOf(VariableDeclaration referredVariable) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        Value object = this.variableValues.get(referredVariable);
        if (object == null && this.parent != null && !this.variableValues.containsKey(referredVariable)) {
            object = this.parent.getValueOf(referredVariable);
        }
        return object;
    }

    @Override
    public void replace(VariableDeclaration referredVariable, Value value) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        this.variableValues.put(referredVariable, value);
    }

    @Override
    public void add(VariableDeclaration referredVariable, Value value) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        if (this.variableValues.containsKey(referredVariable)) {
            String message = NLS.bind((String)OCLMessages.BindingExist_ERROR_, (Object)referredVariable, (Object)this.variableValues.get(referredVariable));
            throw new IllegalArgumentException(message);
        }
        this.variableValues.put(referredVariable, value);
    }

    @Override
    @Deprecated
    public Value remove(VariableDeclaration referredVariable) {
        if (referredVariable instanceof Variable) assert (((Variable)referredVariable).getRepresentedParameter() == null);
        return this.variableValues.remove(referredVariable);
    }

    @Override
    public void clear() {
        this.variableValues.clear();
    }

    public String toString() {
        return this.variableValues.toString();
    }

    @Override
    public boolean overrides(Operation operation, int opcode) {
        return this.getParent() != null ? this.getParent().overrides(operation, opcode) : false;
    }

    @Override
    public <T> T getAdapter(Class<T> adapterType) {
        AbstractEvaluationEnvironment result = adapterType.isInstance(this) ? this : null;
        return (T)result;
    }

    protected Map<Option<?>, Object> basicGetOptions() {
        return this.options;
    }

    @Override
    public Map<Option<?>, Object> getOptions() {
        Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
        HashMap result = parent != null ? new HashMap(parent.getOptions()) : new HashMap();
        result.putAll(this.basicGetOptions());
        return result;
    }

    @Override
    public <T> void setOption(Option<T> option, T value) {
        this.basicGetOptions().put(option, value);
    }

    @Override
    public <T> void putOptions(Map<? extends Option<T>, ? extends T> options) {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        myOptions.clear();
        myOptions.putAll(options);
    }

    @Override
    public <T> T removeOption(Option<T> option) {
        T result = this.getValue(option);
        this.basicGetOptions().remove(option);
        return result;
    }

    @Override
    public <T> Map<Option<T>, T> removeOptions(Collection<Option<T>> options) {
        HashMap<Option<T>, T> result = new HashMap<Option<T>, T>();
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        for (Option<T> next : options) {
            result.put(next, this.getValue(next));
            myOptions.remove(next);
        }
        return result;
    }

    @Override
    public Map<Option<?>, Object> clearOptions() {
        Map<Option<?>, Object> myOptions = this.basicGetOptions();
        HashMap result = new HashMap(myOptions);
        myOptions.clear();
        return result;
    }

    @Override
    public boolean isEnabled(Option<Boolean> option) {
        Boolean result = this.getValue(option);
        return result == null ? false : result;
    }

    @Override
    public <T> T getValue(Option<T> option) {
        Object result = this.getOptions().get(option);
        if (result == null) {
            Customizable parent = this.getParent() != null ? OCLUtil.getAdapter(this.getParent(), Customizable.class) : null;
            result = parent != null ? parent.getValue(option) : option.getDefaultValue();
        }
        return (T)result;
    }

    @Override
    public NullValue throwInvalidEvaluation(InvalidValueException e) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(this, e);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(this, message, null, null, null);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message, OclExpression expression) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(this, message, null, expression, null);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message, OclExpression expression, Object context) throws InvalidEvaluationException {
        throw new InvalidEvaluationException(this, message, null, expression, context);
    }

    @Override
    public NullValue throwInvalidEvaluation(Throwable e, OclExpression expression, Object context, String message, Object ... bindings) throws InvalidEvaluationException {
        String boundMessage = NLS.bind((String)message, (Object[])bindings);
        throw new InvalidEvaluationException(this, boundMessage, e, expression, context);
    }
}

