/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.NullValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractEvaluationVisitor
extends AbstractExtendingVisitor<Value, Object>
implements EvaluationVisitor {
    private static Set<String> BOOLEAN_CONSTRAINTS = new HashSet<String>();
    protected final EvaluationEnvironment evaluationEnvironment;
    protected final Environment environment;
    protected final TypeManager typeManager;
    protected final ModelManager modelManager;
    protected final ValueFactory valueFactory;
    private EvaluationVisitor undecoratedVisitor;

    static {
        BOOLEAN_CONSTRAINTS.add("invariant");
        BOOLEAN_CONSTRAINTS.add("precondition");
        BOOLEAN_CONSTRAINTS.add("postcondition");
    }

    protected AbstractEvaluationVisitor(Environment env, EvaluationEnvironment evalEnv, ModelManager modelManager) {
        super(null);
        this.evaluationEnvironment = evalEnv;
        this.environment = env;
        this.typeManager = env.getTypeManager();
        this.modelManager = modelManager;
        this.valueFactory = evalEnv.getValueFactory();
        this.undecoratedVisitor = this;
    }

    @Override
    public Environment getEnvironment() {
        return this.environment;
    }

    @Override
    public EvaluationEnvironment getEvaluationEnvironment() {
        return this.evaluationEnvironment;
    }

    @Override
    public ModelManager getModelManager() {
        return this.modelManager;
    }

    @Override
    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    protected final EvaluationVisitor getUndecoratedVisitor() {
        return this.undecoratedVisitor;
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.valueFactory;
    }

    @Deprecated
    protected final EvaluationVisitor getVisitor() {
        return this.undecoratedVisitor;
    }

    @Override
    public void setUndecoratedVisitor(EvaluationVisitor evaluationVisitor) {
        this.undecoratedVisitor = evaluationVisitor;
    }

    @Deprecated
    void setVisitor(EvaluationVisitor visitor) {
        this.setUndecoratedVisitor(visitor);
    }

    @Override
    public NullValue throwInvalidEvaluation(String message) throws InvalidEvaluationException {
        return this.evaluationEnvironment.throwInvalidEvaluation(message);
    }

    @Override
    public NullValue throwInvalidEvaluation(InvalidValueException e) throws InvalidEvaluationException {
        return this.evaluationEnvironment.throwInvalidEvaluation(e);
    }

    @Override
    public NullValue throwInvalidEvaluation(Throwable e, OclExpression expression, Object value, String message, Object ... bindings) {
        return this.evaluationEnvironment.throwInvalidEvaluation(e, expression, value, message, bindings);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (evaluation environment: ");
        result.append(this.getEvaluationEnvironment());
        result.append(')');
        return result.toString();
    }

    @Override
    public Value visitConstraint(Constraint constraint) {
        ValueSpecification specification = constraint.getSpecification();
        if (!(specification instanceof ExpressionInOcl)) {
            return null;
        }
        OclExpression body = ((ExpressionInOcl)specification).getBodyExpression();
        boolean isBoolean = BOOLEAN_CONSTRAINTS.contains(constraint.getStereotype());
        if (body == null) {
            throw new IllegalArgumentException("constraint has no body expression");
        }
        if (isBoolean && body.getType() == this.typeManager.getBooleanType()) {
            throw new IllegalArgumentException("constraint is not boolean");
        }
        Value result = (Value)body.accept(this.getUndecoratedVisitor());
        try {
            return result.asBooleanValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
    }
}

