/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.evaluation;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ClassifierType;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.EvaluationException;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.MessageExp;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StateExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.UnspecifiedValueExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.evaluation.AbstractEvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.impl.IntegerRangeValueImpl;

public class EvaluationVisitorImpl
extends AbstractEvaluationVisitor {
    public static boolean isSimpleRange(CollectionLiteralExp cl) {
        EList<CollectionLiteralPart> partsList = cl.getParts();
        int size = partsList.size();
        if (size == 1) {
            CollectionLiteralPart part = (CollectionLiteralPart)partsList.get(0);
            return part instanceof CollectionRange;
        }
        return false;
    }

    public EvaluationVisitorImpl(Environment env, EvaluationEnvironment evalEnv, ModelManager modelManager) {
        super(env, evalEnv, modelManager);
    }

    public EvaluationVisitor createNestedVisitor() {
        EnvironmentFactory factory = this.environment.getFactory();
        EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
        return new EvaluationVisitorImpl(this.environment, nestedEvalEnv, this.modelManager);
    }

    protected Value handleCallExp(CallExp callExp, Operation staticOperation) throws InvalidEvaluationException {
        CallableImplementation implementation;
        Type dynamicSourceType;
        Value sourceValue;
        EvaluationVisitor undecoratedVisitor = this.getUndecoratedVisitor();
        OclExpression source = callExp.getSource();
        Type staticSourceType = source.getType();
        try {
            sourceValue = (Value)source.accept(undecoratedVisitor);
        }
        catch (InvalidEvaluationException e) {
            sourceValue = this.typeManager.getValueFactory().getInvalid();
        }
        Operation dynamicOperation = staticOperation;
        if (!staticOperation.isStatic() && (dynamicOperation = this.typeManager.getDynamicOperation(dynamicSourceType = sourceValue.getType(this.typeManager, staticSourceType), staticOperation)) == null) {
            dynamicOperation = staticOperation;
        }
        try {
            implementation = this.typeManager.getImplementation(dynamicOperation);
        }
        catch (Exception e) {
            String implementationClass = dynamicOperation.getImplementationClass();
            if (implementationClass != null) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, callExp, null, EvaluatorMessages.ImplementationClassLoadFailure, implementationClass);
            }
            return this.evaluationEnvironment.throwInvalidEvaluation(e, callExp, null, "Failed to load implementation for '" + dynamicOperation + "'", new Object[0]);
        }
        Value result = null;
        try {
            result = implementation.evaluate(undecoratedVisitor, sourceValue, callExp);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, callExp, sourceValue, "Failed to evaluate '" + dynamicOperation + "'", new Object[0]);
        }
        if (result == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Java-Null result from '" + dynamicOperation + "'", callExp, sourceValue);
        }
        return result;
    }

    public Value safeVisit(Visitable v) {
        if (v == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("null expression");
        }
        try {
            return v.accept(this);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, null, v, "Evaluation Failure", new Object[0]);
        }
    }

    public Value visitAssociationClassCallExp(AssociationClassCallExp ae) {
        Value context = (Value)ae.getSource().accept(this.getUndecoratedVisitor());
        if (context.isUndefined()) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Undefined context for AssociationClassCall", ae);
        }
        return this.evaluationEnvironment.navigateAssociationClass(ae.getReferredAssociationClass(), ae.getNavigationSource(), context);
    }

    public BooleanValue visitBooleanLiteralExp(BooleanLiteralExp booleanLiteralExp) {
        boolean value = booleanLiteralExp.isBooleanSymbol();
        return this.valueFactory.booleanValueOf(value);
    }

    public Value visitCollectionItem(CollectionItem item) {
        throw new UnsupportedOperationException("evaluation of CollectionItem");
    }

    public Value visitCollectionLiteralExp(CollectionLiteralExp cl) {
        CollectionKind kind = cl.getKind();
        EList<CollectionLiteralPart> parts = cl.getParts();
        if (kind == CollectionKind.SEQUENCE && EvaluationVisitorImpl.isSimpleRange(cl)) {
            Integer lastInt;
            Integer firstInt;
            IntegerValue lastInteger;
            IntegerValue firstInteger;
            CollectionRange collRange = (CollectionRange)parts.get(0);
            OclExpression first = collRange.getFirst();
            OclExpression last = collRange.getLast();
            Value firstVal = (Value)first.accept(this.getUndecoratedVisitor());
            if (firstVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid first element", cl, first);
            }
            Value lastVal = (Value)last.accept(this.getUndecoratedVisitor());
            if (lastVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid last element", cl, last);
            }
            try {
                firstInteger = firstVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstVal, "Non integer first element", new Object[0]);
            }
            try {
                lastInteger = lastVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastVal, "Non integer last element", new Object[0]);
            }
            try {
                firstInt = firstInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstInteger, "Out of range first element", new Object[0]);
            }
            try {
                lastInt = lastInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastInteger, "Out of range last element", new Object[0]);
            }
            return new IntegerRangeValueImpl(this.valueFactory, firstInt, lastInt);
        }
        ArrayList<Value> results = new ArrayList<Value>();
        block16: for (CollectionLiteralPart part : parts) {
            Integer lastInt;
            Integer firstInt;
            IntegerValue lastInteger;
            IntegerValue firstInteger;
            if (part instanceof CollectionItem) {
                CollectionItem item = (CollectionItem)part;
                OclExpression itemExp = item.getItem();
                Value itemVal = (Value)itemExp.accept(this.getUndecoratedVisitor());
                if (itemVal == null) continue;
                results.add(itemVal);
                continue;
            }
            CollectionRange range = (CollectionRange)part;
            OclExpression first = range.getFirst();
            OclExpression last = range.getLast();
            Value firstVal = (Value)first.accept(this.getUndecoratedVisitor());
            if (firstVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid first element", cl, first);
            }
            Value lastVal = (Value)last.accept(this.getUndecoratedVisitor());
            if (lastVal == null) {
                return this.evaluationEnvironment.throwInvalidEvaluation("Invalid last element", cl, last);
            }
            try {
                firstInteger = firstVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstVal, "Non integer first element", new Object[0]);
            }
            try {
                lastInteger = lastVal.asIntegerValue();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastVal, "Non integer last element", new Object[0]);
            }
            try {
                firstInt = firstInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, firstInteger, "Out of range first element", new Object[0]);
            }
            try {
                lastInt = lastInteger.asInteger();
            }
            catch (InvalidValueException e) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, cl, lastInteger, "Out of range last element", new Object[0]);
            }
            int increment = lastInt.compareTo(firstInt);
            int i = firstInt;
            while (true) {
                results.add(this.valueFactory.integerValueOf(i));
                if (i == lastInt) continue block16;
                i += increment;
            }
        }
        return this.valueFactory.createCollectionValue(kind, results);
    }

    public Value visitCollectionRange(CollectionRange range) {
        throw new UnsupportedOperationException("evaluation of CollectionRange");
    }

    public Value visitEnumLiteralExp(EnumLiteralExp el) {
        return this.valueFactory.createElementValue(el.getReferredEnumLiteral());
    }

    public Value visitExpressionInOcl(ExpressionInOcl expression) {
        return this.safeVisit(expression.getBodyExpression());
    }

    public Value visitIfExp(IfExp ifExp) {
        BooleanValue evaluatedCondition;
        OclExpression condition = ifExp.getCondition();
        try {
            evaluatedCondition = ((Value)condition.accept(this.getUndecoratedVisitor())).asBooleanValue();
        }
        catch (InvalidValueException e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e);
        }
        OclExpression expression = null;
        expression = evaluatedCondition.isTrue() ? ifExp.getThenExpression() : ifExp.getElseExpression();
        return (Value)expression.accept(this.getUndecoratedVisitor());
    }

    public Value visitIntegerLiteralExp(IntegerLiteralExp integerLiteralExp) {
        BigInteger value = integerLiteralExp.getIntegerSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Integer Value", integerLiteralExp);
        }
        return this.valueFactory.integerValueOf(value);
    }

    public Value visitInvalidLiteralExp(InvalidLiteralExp invalidLiteralExp) {
        return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Literal");
    }

    public Value visitIterateExp(IterateExp iterateExp) {
        return this.handleCallExp(iterateExp, iterateExp.getReferredIteration());
    }

    public Value visitIteratorExp(IteratorExp iteratorExp) {
        return this.handleCallExp(iteratorExp, iteratorExp.getReferredIteration());
    }

    public Value visitLetExp(LetExp letExp) {
        Value value;
        OclExpression expression = letExp.getIn();
        Variable variable = letExp.getVariable();
        try {
            value = (Value)variable.accept(this);
        }
        catch (InvalidEvaluationException e) {
            value = this.valueFactory.getInvalid();
        }
        EvaluationVisitor nestedVisitor = this.getUndecoratedVisitor().createNestedVisitor();
        nestedVisitor.getEvaluationEnvironment().add(variable, value);
        return (Value)expression.accept(nestedVisitor);
    }

    public Value visitMessageExp(MessageExp m) {
        throw new UnsupportedOperationException("evaluation of MessageExp");
    }

    public Value visitNullLiteralExp(NullLiteralExp nullLiteralExp) {
        return this.valueFactory.getNull();
    }

    public Value visitOperationCallExp(OperationCallExp operationCallExp) {
        return this.handleCallExp(operationCallExp, operationCallExp.getReferredOperation());
    }

    public Value visitPropertyCallExp(PropertyCallExp propertyCallExp) {
        CallableImplementation implementation;
        Property property = propertyCallExp.getReferredProperty();
        try {
            implementation = this.typeManager.getImplementation(property);
        }
        catch (Exception e) {
            String implementationClass = property.getImplementationClass();
            if (implementationClass != null) {
                return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, null, EvaluatorMessages.ImplementationClassLoadFailure, implementationClass);
            }
            return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, null, "Failed to load implementation for '" + property + "'", new Object[0]);
        }
        OclExpression source = propertyCallExp.getSource();
        Value sourceValue = (Value)source.accept(this.getUndecoratedVisitor());
        Value resultValue = null;
        try {
            resultValue = implementation.evaluate(this.getUndecoratedVisitor(), sourceValue, propertyCallExp);
        }
        catch (EvaluationException e) {
            throw e;
        }
        catch (Exception e) {
            return this.evaluationEnvironment.throwInvalidEvaluation(e, propertyCallExp, sourceValue, "Failed to evaluate '" + property + "'", new Object[0]);
        }
        if (resultValue == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation(null, propertyCallExp, sourceValue, "Java-Null result from '" + property + "'", new Object[0]);
        }
        return resultValue;
    }

    public Value visitRealLiteralExp(RealLiteralExp realLiteralExp) {
        BigDecimal value = realLiteralExp.getRealSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Real Value", realLiteralExp);
        }
        return this.valueFactory.realValueOf(value);
    }

    public Value visitStateExp(StateExp s) {
        return this.valueFactory.createElementValue(s.getReferredState());
    }

    public Value visitStringLiteralExp(StringLiteralExp stringLiteralExp) {
        String value = stringLiteralExp.getStringSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid String Value", stringLiteralExp);
        }
        return this.valueFactory.stringValueOf(value);
    }

    public Value visitTupleLiteralExp(TupleLiteralExp tl) {
        Type type = tl.getType();
        HashMap<TupleLiteralPart, Value> propertyValues = new HashMap<TupleLiteralPart, Value>();
        for (TupleLiteralPart part : tl.getParts()) {
            propertyValues.put(part, (Value)part.accept(this.getUndecoratedVisitor()));
        }
        return this.valueFactory.createTupleValue((TupleType)type, propertyValues);
    }

    public Value visitTupleLiteralPart(TupleLiteralPart tp) {
        return (Value)tp.getInitExpression().accept(this.getUndecoratedVisitor());
    }

    public Value visitTypeExp(TypeExp t) {
        return this.valueFactory.createTypeValue((ClassifierType)t.getType());
    }

    public Value visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp unlimitedNaturalLiteralExp) {
        BigInteger value = unlimitedNaturalLiteralExp.getUnlimitedNaturalSymbol();
        if (value == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid Unlimited Natural Value", unlimitedNaturalLiteralExp);
        }
        if (value.signum() < 0) {
            return this.valueFactory.getUnlimited();
        }
        return this.valueFactory.integerValueOf(value);
    }

    public Value visitUnspecifiedValueExp(UnspecifiedValueExp uv) {
        throw new UnsupportedOperationException("evaluation of UnspecifiedValueExp");
    }

    public Value visitVariable(Variable variable) {
        OclExpression initExp = variable.getInitExpression();
        if (initExp == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Uninitialized variable", null, variable);
        }
        return (Value)initExp.accept(this.getUndecoratedVisitor());
    }

    public Value visitVariableExp(VariableExp variableExp) {
        Value value;
        Parameter representedParameter;
        VariableDeclaration variableDeclaration = variableExp.getReferredVariable();
        if (variableDeclaration instanceof Variable && (representedParameter = ((Variable)variableDeclaration).getRepresentedParameter()) != null) {
            variableDeclaration = representedParameter;
        }
        if ((value = this.evaluationEnvironment.getValueOf(variableDeclaration)) == null) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Undefined variable", variableExp);
        }
        if (value.isInvalid()) {
            return this.evaluationEnvironment.throwInvalidEvaluation("Invalid variable", variableExp);
        }
        return value;
    }

    public Value visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for EvaluationVisitor");
    }
}

