/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.library;

import org.eclipse.emf.common.util.EList;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.library.AbstractCallableImplementation;
import org.eclipse.ocl.examples.pivot.values.Value;

public class ConstrainedOperation
extends AbstractCallableImplementation {
    protected final ExpressionInOcl expressionInOcl;

    public ConstrainedOperation(ExpressionInOcl expressionInOcl) {
        this.expressionInOcl = expressionInOcl;
    }

    public Value evaluate(EvaluationVisitor evaluationVisitor, Value sourceValue, CallExp callExp) {
        EvaluationVisitor nestedVisitor = evaluationVisitor.createNestedVisitor();
        EvaluationEnvironment nestedEvaluationEnvironment = nestedVisitor.getEvaluationEnvironment();
        nestedEvaluationEnvironment.add(this.expressionInOcl.getContextVariable(), sourceValue);
        EList<Variable> parameters = this.expressionInOcl.getParameterVariables();
        if (!parameters.isEmpty()) {
            EList<OclExpression> arguments = ((OperationCallExp)callExp).getArguments();
            int i = 0;
            while (i < parameters.size()) {
                OclExpression argument = (OclExpression)arguments.get(i);
                Value value = (Value)argument.accept(evaluationVisitor);
                nestedEvaluationEnvironment.add(((Variable)parameters.get(i)).getRepresentedParameter(), value);
                ++i;
            }
        }
        return (Value)this.expressionInOcl.accept(nestedVisitor);
    }
}

