/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.examples.common.utils.TracingOption;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.MultiplicityElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.utilities.Pivot2MonikerVisitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Abstract2Moniker
implements PivotConstants {
    private static final Logger logger = Logger.getLogger(Abstract2Moniker.class);
    public static final TracingOption TRACE_MONIKERS = new TracingOption("org.eclipse.ocl.examples.pivot", "traceMonikers");
    protected final EObject target;
    private final StringBuffer s = new StringBuffer();
    private Pivot2MonikerVisitor pivotVisitor = null;
    private List<TemplateParameter> emittedParameters = null;

    protected Abstract2Moniker(EObject target) {
        this.target = target;
    }

    public void append(char c) {
        this.s.append(c);
    }

    public void append(int i) {
        this.s.append(i);
    }

    public void append(String string) {
        this.s.append(string != null ? string : "null");
    }

    public void appendElement(Element element) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else if (element.eIsProxy()) {
            this.append("<<unresolved-proxy>>");
        } else {
            if (this.pivotVisitor == null) {
                this.pivotVisitor = new Pivot2MonikerVisitor(this);
            }
            element.accept(this.pivotVisitor);
        }
    }

    public void appendElement(Element element, Map<TemplateParameter, ParameterableElement> templateBindings) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else if (templateBindings != null) {
            Pivot2MonikerVisitor savedPivotVisitor = this.pivotVisitor;
            try {
                this.pivotVisitor = new Pivot2MonikerVisitor(this, templateBindings);
                element.accept(this.pivotVisitor);
            }
            finally {
                this.pivotVisitor = savedPivotVisitor;
            }
        } else {
            if (this.pivotVisitor == null) {
                this.pivotVisitor = new Pivot2MonikerVisitor(this);
            }
            element.accept(this.pivotVisitor);
        }
    }

    public void appendIndex(EObject eObject) {
        Object objects;
        EObject parent;
        if (eObject != null && (parent = eObject.eContainer()) != null && (objects = parent.eGet(eObject.eContainingFeature())) instanceof List) {
            this.append(((List)objects).indexOf(eObject));
            return;
        }
        this.append(0);
    }

    public void appendLambdaType(Type contextType, List<? extends Type> parameterTypes, Type resultType, Map<TemplateParameter, ParameterableElement> bindings) {
        this.append("~");
        if (contextType != null) {
            this.appendElement(contextType, bindings);
        }
        this.append("(");
        String prefix = "";
        for (Type type : parameterTypes) {
            this.append(prefix);
            this.appendElement(type, bindings);
            prefix = ",";
        }
        this.append(")");
        if (resultType != null) {
            this.appendElement(resultType, bindings);
        }
    }

    protected void appendMultiplicity(MultiplicityElement multiplicityElement) {
        int lower = multiplicityElement.getLower().intValue();
        int upper = multiplicityElement.getUpper().intValue();
        if (upper != 1) {
            this.append("[");
            this.append(lower);
            this.append(multiplicityElement.isOrdered() ? "S" : "s");
            this.append(multiplicityElement.isUnique() ? "U" : "u");
            this.append(upper);
            this.append("]");
        }
    }

    public void appendName(MonikeredElement monikeredElement) {
        TemplateableElement unspecializedElement;
        if (monikeredElement instanceof TemplateableElement && (unspecializedElement = ((TemplateableElement)monikeredElement).getUnspecializedElement()) != null) {
            this.appendName(unspecializedElement);
            return;
        }
        if (monikeredElement instanceof NamedElement) {
            this.append(((NamedElement)monikeredElement).getName());
        } else if (monikeredElement == null) {
            this.append("/null/");
        } else {
            logger.warn((Object)("Unsupported PivotMoniker.appendName() for " + monikeredElement.eClass().getName()));
            this.append("/anon/");
        }
    }

    public void appendParameters(Operation operation, Map<TemplateParameter, ParameterableElement> templateBindings) {
        this.s.append("(");
        String prefix = "";
        if (operation instanceof Iteration) {
            Iteration iteration = (Iteration)operation;
            for (Parameter parameter : iteration.getOwnedIterators()) {
                this.s.append(prefix);
                this.appendElement(parameter.getType(), templateBindings);
                this.appendMultiplicity(parameter);
                prefix = ",";
            }
            if (iteration.getOwnedAccumulators().size() > 0) {
                prefix = ";";
                for (Parameter parameter : iteration.getOwnedAccumulators()) {
                    this.s.append(prefix);
                    this.appendElement(parameter.getType(), templateBindings);
                    this.appendMultiplicity(parameter);
                    prefix = ",";
                }
            }
            prefix = "|";
        }
        for (Parameter parameter : operation.getOwnedParameters()) {
            this.s.append(prefix);
            this.appendElement(parameter.getType(), templateBindings);
            this.appendMultiplicity(parameter);
            prefix = ",";
        }
        this.s.append(")");
    }

    public void appendParent(Element element, String parentSeparator) {
        if (this.toString().length() >= 1024) {
            this.append("##");
        } else if (element == null) {
            this.append("<<null-element>>");
        } else {
            EObject parent = element.eContainer();
            if (parent instanceof MonikeredElement) {
                TemplateSignature ownedTemplateSignature;
                this.append(((MonikeredElement)parent).getMoniker());
                if (parent instanceof TemplateableElement && (ownedTemplateSignature = ((TemplateableElement)parent).getOwnedTemplateSignature()) != null) {
                    for (TemplateParameter templateParameter : ownedTemplateSignature.getParameters()) {
                        this.emittedTemplateParameter(templateParameter);
                    }
                }
            } else if (parent instanceof Element) {
                this.appendElement((Element)parent);
            } else if (element.eIsProxy()) {
                this.append("<<unresolved-proxy>>");
            } else assert (element instanceof Package || element instanceof ExpressionInOcl) : String.valueOf(element.eClass().getName()) + " has no parent";
        }
        this.append(parentSeparator);
    }

    public void appendRole(Element object) {
        EReference eFeature = object.eContainmentFeature();
        if (eFeature != null) {
            int index;
            String roleName = (String)roleNames.get(eFeature);
            if (roleName == null) {
                roleName = eFeature.getName();
            }
            this.append(roleName);
            if (eFeature.isMany() && (index = ((List)object.eContainer().eGet(object.eContainingFeature())).indexOf(object)) != 0) {
                this.append(index);
            }
        }
    }

    public void appendTemplateBindings(TemplateableElement templateableElement, Map<TemplateParameter, ParameterableElement> bindings) {
        EList<TemplateBinding> templateBindings = templateableElement.getTemplateBindings();
        if (!templateBindings.isEmpty()) {
            boolean isSpecialized = this.isSpecialized((List<TemplateBinding>)templateBindings, bindings);
            if (!isSpecialized) {
                this.s.append("{");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    Object parameterSubstitutions = templateBinding.getParameterSubstitutions();
                    if (parameterSubstitutions.size() > 1) {
                        parameterSubstitutions = new ArrayList<TemplateParameterSubstitution>((Collection<TemplateParameterSubstitution>)parameterSubstitutions);
                        Collections.sort(parameterSubstitutions, PivotUtil.TemplateParameterSubstitutionComparator.INSTANCE);
                    }
                    for (TemplateParameterSubstitution templateParameterSubstitution : parameterSubstitutions) {
                        this.s.append(prefix);
                        this.appendName(templateParameterSubstitution.getFormal().getParameteredElement());
                        prefix = ",";
                    }
                }
                this.s.append("}");
            } else {
                this.s.append("[");
                String prefix = "";
                for (TemplateBinding templateBinding : templateBindings) {
                    Object parameterSubstitutions = templateBinding.getParameterSubstitutions();
                    if (parameterSubstitutions.size() > 1) {
                        parameterSubstitutions = new ArrayList<TemplateParameterSubstitution>((Collection<TemplateParameterSubstitution>)parameterSubstitutions);
                        Collections.sort(parameterSubstitutions, PivotUtil.TemplateParameterSubstitutionComparator.INSTANCE);
                    }
                    for (TemplateParameterSubstitution templateParameterSubstitution : parameterSubstitutions) {
                        this.s.append(prefix);
                        this.appendElement(templateParameterSubstitution.getActual(), bindings);
                        prefix = ",";
                    }
                }
                this.s.append("]");
            }
        }
    }

    public void appendTemplateParameters(TemplateableElement templateableElement) {
        EList<TemplateParameter> templateParameters;
        TemplateSignature templateSignature = templateableElement.getOwnedTemplateSignature();
        if (templateSignature != null && !(templateParameters = templateSignature.getOwnedParameters()).isEmpty()) {
            this.s.append("{");
            String prefix = "";
            for (TemplateParameter templateParameter : templateParameters) {
                this.s.append(prefix);
                this.emittedTemplateParameter(templateParameter);
                this.appendName(templateParameter.getParameteredElement());
                prefix = ",";
            }
            this.s.append("}");
        }
    }

    public void appendTupleType(Collection<? extends TypedElement> tupleParts) {
        ArrayList<? extends TypedElement> parts = new ArrayList<TypedElement>(tupleParts);
        Collections.sort(parts, new Comparator<TypedElement>(){

            @Override
            public int compare(TypedElement o1, TypedElement o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        this.append("{");
        String prefix = "";
        for (TypedElement typedElement : parts) {
            this.append(prefix);
            this.appendName(typedElement);
            this.append(":");
            Type type = typedElement.getType();
            if (type != null) {
                this.appendElement(type);
            }
            prefix = ",";
        }
        this.append("}");
    }

    protected void emittedTemplateParameter(TemplateParameter templateParameter) {
        if (this.emittedParameters == null) {
            this.emittedParameters = new ArrayList<TemplateParameter>();
        }
        this.emittedParameters.add(templateParameter);
    }

    public boolean hasEmitted(TemplateParameter templateParameter) {
        return this.emittedParameters != null && this.emittedParameters.contains(templateParameter);
    }

    protected boolean isSpecialized(List<TemplateBinding> templateBindings, Map<TemplateParameter, ParameterableElement> bindings) {
        if (bindings == null) {
            return true;
        }
        for (TemplateBinding templateBinding : templateBindings) {
            for (TemplateParameterSubstitution templateParameterSubstitution : templateBinding.getParameterSubstitutions()) {
                ParameterableElement actual = templateParameterSubstitution.getActual();
                if (actual == null) {
                    return true;
                }
                ParameterableElement parameterableElement = bindings.get(actual.getOwningTemplateParameter());
                if (parameterableElement != null && parameterableElement.getOwningTemplateParameter() == templateParameterSubstitution.getFormal()) continue;
                return true;
            }
        }
        return false;
    }

    protected int length() {
        return this.s.length();
    }

    public String toString() {
        return this.s.toString();
    }
}

