/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.utilities;

import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.Annotation;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Detail;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LambdaType;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.ParameterableElement;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateParameterSubstitution;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.Abstract2Moniker;
import org.eclipse.ocl.examples.pivot.utilities.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Pivot2MonikerVisitor
extends AbstractExtendingVisitor<Object, Abstract2Moniker>
implements PivotConstants {
    private static boolean initialized = false;
    protected final Map<TemplateParameter, ParameterableElement> templateBindings;

    public static void initialize() {
        if (!initialized) {
            initialized = true;
            roleNames.put(PivotPackage.Literals.LOOP_EXP__BODY, "argument");
        }
    }

    public Pivot2MonikerVisitor(Abstract2Moniker context) {
        super(context);
        this.templateBindings = null;
        if (!initialized) {
            Pivot2MonikerVisitor.initialize();
        }
    }

    public Pivot2MonikerVisitor(Abstract2Moniker context, Map<TemplateParameter, ParameterableElement> templateBindings) {
        super(context);
        this.templateBindings = templateBindings;
    }

    public void appendExpPrefix(NamedElement object) {
        CallExp callExpParent;
        EObject parent = object.eContainer();
        if (parent instanceof CallExp && (callExpParent = (CallExp)parent).isImplicit()) {
            if (callExpParent instanceof IteratorExp) {
                if (callExpParent.getSource() == object) {
                    ((Abstract2Moniker)this.context).appendElement(((IteratorExp)callExpParent).getBody());
                    ((Abstract2Moniker)this.context).append("!");
                    ((Abstract2Moniker)this.context).appendRole(object);
                    ((Abstract2Moniker)this.context).append("~");
                    return;
                }
                ((Abstract2Moniker)this.context).appendParent(callExpParent, "!");
                ((Abstract2Moniker)this.context).appendRole(callExpParent);
                ((Abstract2Moniker)this.context).append("~");
                return;
            }
            if (callExpParent.getSource() == object) {
                object = callExpParent;
            }
        }
        ((Abstract2Moniker)this.context).appendParent(object, "!");
        ((Abstract2Moniker)this.context).appendRole(object);
        ((Abstract2Moniker)this.context).append("~");
    }

    public String toString() {
        return ((Abstract2Moniker)this.context).toString();
    }

    @Override
    public Object visitAnnotation(Annotation object) {
        ((Abstract2Moniker)this.context).appendParent(object, "!");
        ((Abstract2Moniker)this.context).append("'");
        ((Abstract2Moniker)this.context).append(String.valueOf(object.getName()));
        ((Abstract2Moniker)this.context).append("'");
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            for (Object element : (List)container) {
                if (element == object) break;
                if (!(element instanceof Annotation) || !((Annotation)element).getName().equals(object.getName())) continue;
                ++index;
            }
            if (index > 0) {
                ((Abstract2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public Object visitBooleanLiteralExp(BooleanLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append(Boolean.toString(object.isBooleanSymbol()));
        return true;
    }

    @Override
    public Object visitClass(Class object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            ParameterableElement parameterableElement;
            if (this.templateBindings != null && (parameterableElement = this.templateBindings.get(owningTemplateParameter)) != null && parameterableElement != object) {
                ((Abstract2Moniker)this.context).appendElement(parameterableElement);
                return true;
            }
            TemplateableElement owningTemplateElement = owningTemplateParameter.getSignature().getTemplate();
            if (!((Abstract2Moniker)this.context).hasEmitted(owningTemplateParameter)) {
                ((Abstract2Moniker)this.context).appendElement(owningTemplateElement);
                ((Abstract2Moniker)this.context).append("?");
            }
            ((Abstract2Moniker)this.context).appendName(object);
        } else if (!object.getTemplateBindings().isEmpty()) {
            Class templateableClass = PivotUtil.getUnspecializedTemplateableElement(object);
            ((Abstract2Moniker)this.context).appendParent(templateableClass, "!");
            ((Abstract2Moniker)this.context).appendName(templateableClass);
            ((Abstract2Moniker)this.context).appendTemplateBindings(object, this.templateBindings);
        } else if (object.eContainer() instanceof TemplateParameterSubstitution) {
            TemplateParameter formal = ((TemplateParameterSubstitution)object.eContainer()).getFormal();
            int index = formal.getSignature().getParameters().indexOf((Object)formal);
            ((Abstract2Moniker)this.context).appendParent(object, "!");
            ((Abstract2Moniker)this.context).append("?" + index);
        } else {
            ((Abstract2Moniker)this.context).appendParent(object, "!");
            ((Abstract2Moniker)this.context).appendName(object);
            ((Abstract2Moniker)this.context).appendTemplateParameters(object);
        }
        return true;
    }

    @Override
    public Object visitCollectionLiteralExp(CollectionLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getType());
        return true;
    }

    @Override
    public Object visitCollectionLiteralPart(CollectionLiteralPart object) {
        ((Abstract2Moniker)this.context).appendParent(object, "@");
        ((Abstract2Moniker)this.context).appendIndex(object);
        return true;
    }

    @Override
    public Object visitConstraint(Constraint object) {
        ((Abstract2Moniker)this.context).appendParent(object, "!");
        ((Abstract2Moniker)this.context).append(object.getStereotype());
        Object container = object.eContainer().eGet(object.eContainingFeature());
        if (container instanceof List) {
            int index = 0;
            String name2 = object.getName();
            for (Object content : (List)container) {
                Constraint sibling;
                if (content == object) break;
                if (!(content instanceof Constraint) || !(sibling = (Constraint)content).getStereotype().equals(object.getStereotype())) continue;
                String name1 = sibling.getName();
                if (name1 != name2 && (name1 == null || !name1.equals(name2))) break;
                ++index;
            }
            ((Abstract2Moniker)this.context).append("~");
            if (name2 != null) {
                ((Abstract2Moniker)this.context).append(name2);
            }
            if (index != 0) {
                ((Abstract2Moniker)this.context).append("~");
                ((Abstract2Moniker)this.context).append(index);
            }
        }
        return true;
    }

    @Override
    public Object visitDetail(Detail object) {
        ((Abstract2Moniker)this.context).appendParent(object, "/");
        ((Abstract2Moniker)this.context).append(object.getName());
        return true;
    }

    @Override
    public Object visitEnumLiteralExp(EnumLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getReferredEnumLiteral());
        return true;
    }

    @Override
    public Object visitExpressionInOcl(ExpressionInOcl object) {
        if (object.eContainer() != null) {
            ((Abstract2Moniker)this.context).appendParent(object, "!");
            ((Abstract2Moniker)this.context).appendRole(object);
        } else {
            ((Abstract2Moniker)this.context).append("root");
        }
        return true;
    }

    @Override
    public Object visitIfExp(IfExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("if");
        return true;
    }

    @Override
    public Object visitIntegerLiteralExp(IntegerLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append(object.getIntegerSymbol().toString());
        return true;
    }

    @Override
    public Object visitInvalidLiteralExp(InvalidLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("invalid");
        return true;
    }

    @Override
    public Object visitLambdaType(LambdaType object) {
        ((Abstract2Moniker)this.context).append(object.getName());
        Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, object);
        ((Abstract2Moniker)this.context).appendLambdaType(object.getContextType(), (List<? extends Type>)object.getParameterTypes(), object.getResultType(), bindings);
        return true;
    }

    @Override
    public Object visitLetExp(LetExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("let");
        return true;
    }

    @Override
    public Object visitLoopExp(LoopExp object) {
        OclExpression body;
        this.appendExpPrefix(object);
        if (object.isImplicit() && (body = object.getBody()) instanceof CallExp) {
            Feature referredFeature = PivotUtil.getReferredFeature((CallExp)body);
            ((Abstract2Moniker)this.context).appendName(referredFeature);
            return true;
        }
        ((Abstract2Moniker)this.context).appendName(object.getReferredIteration());
        return true;
    }

    @Override
    public Object visitNamedElement(NamedElement object) {
        ((Abstract2Moniker)this.context).appendParent(object, "!");
        ((Abstract2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitNullLiteralExp(NullLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("null");
        return true;
    }

    @Override
    public Object visitOperation(Operation object) {
        TemplateParameter owningTemplateParameter = object.getOwningTemplateParameter();
        if (owningTemplateParameter != null) {
            TemplateableElement owningTemplateElement = owningTemplateParameter.getSignature().getTemplate();
            if (!((Abstract2Moniker)this.context).hasEmitted(owningTemplateParameter)) {
                ((Abstract2Moniker)this.context).appendElement(owningTemplateElement);
                ((Abstract2Moniker)this.context).append("?");
            }
            ((Abstract2Moniker)this.context).appendName(object);
        } else {
            if (!object.getTemplateBindings().isEmpty()) {
                Operation templateableOperation = PivotUtil.getUnspecializedTemplateableElement(object);
                ((Abstract2Moniker)this.context).appendParent(templateableOperation, "!");
                ((Abstract2Moniker)this.context).appendName(object);
                Map<TemplateParameter, ParameterableElement> bindings = PivotUtil.getAllTemplateParameterSubstitutions(null, object);
                if (this.templateBindings != null && bindings == null) {
                    bindings = this.templateBindings;
                }
                ((Abstract2Moniker)this.context).appendTemplateBindings(object, bindings);
                ((Abstract2Moniker)this.context).appendParameters(object, bindings);
                return true;
            }
            ((Abstract2Moniker)this.context).appendParent(object, "!");
            ((Abstract2Moniker)this.context).appendName(object);
            ((Abstract2Moniker)this.context).appendTemplateParameters(object);
            ((Abstract2Moniker)this.context).appendParameters(object, null);
        }
        return true;
    }

    @Override
    public Object visitOperationCallExp(OperationCallExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getReferredOperation());
        return true;
    }

    @Override
    public Object visitPackage(Package object) {
        if (!object.hasMoniker()) {
            throw new IllegalStateException("No moniker has been configured for " + object);
        }
        ((Abstract2Moniker)this.context).append(object.getMoniker());
        return true;
    }

    @Override
    public Object visitPrecedence(Precedence object) {
        ((Abstract2Moniker)this.context).appendParent(object, "~");
        ((Abstract2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPrimitiveType(PrimitiveType object) {
        ((Abstract2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitPropertyCallExp(PropertyCallExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getReferredProperty());
        return true;
    }

    @Override
    public Object visitRealLiteralExp(RealLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append(object.getRealSymbol().toString());
        return true;
    }

    @Override
    public Object visitStringLiteralExp(StringLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("string");
        return true;
    }

    @Override
    public Object visitTemplateBinding(TemplateBinding object) {
        TemplateSignature signature = object.getSignature();
        if (signature != null) {
            ((Abstract2Moniker)this.context).appendElement(signature.getTemplate());
        }
        ((Abstract2Moniker)this.context).append("/");
        return true;
    }

    @Override
    public Object visitTemplateParameter(TemplateParameter object) {
        TemplateableElement owningTemplateElement = object.getSignature().getTemplate();
        ((Abstract2Moniker)this.context).appendElement(owningTemplateElement);
        ((Abstract2Moniker)this.context).append("?");
        ((Abstract2Moniker)this.context).appendName(object.getParameteredElement());
        return true;
    }

    @Override
    public Object visitTemplateParameterSubstitution(TemplateParameterSubstitution object) {
        ((Abstract2Moniker)this.context).appendElement(object.getTemplateBinding());
        ((Abstract2Moniker)this.context).appendName(object.getFormal().getParameteredElement());
        return true;
    }

    @Override
    public Object visitTemplateSignature(TemplateSignature object) {
        ((Abstract2Moniker)this.context).appendParent(object, "!");
        return true;
    }

    @Override
    public Object visitTupleLiteralExp(TupleLiteralExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).append("tuple");
        return true;
    }

    @Override
    public Object visitTupleType(TupleType object) {
        EList<Property> ownedAttributes = object.getOwnedAttributes();
        if (ownedAttributes.isEmpty()) {
            super.visitTupleType(object);
        } else {
            ((Abstract2Moniker)this.context).appendName(object);
            ((Abstract2Moniker)this.context).appendTupleType((Collection<? extends TypedElement>)ownedAttributes);
        }
        return true;
    }

    @Override
    public Object visitTypeExp(TypeExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getReferredType());
        return true;
    }

    @Override
    public Object visitUnlimitedNaturalLiteralExp(UnlimitedNaturalLiteralExp object) {
        this.appendExpPrefix(object);
        BigInteger unlimitedNaturalSymbol = object.getUnlimitedNaturalSymbol();
        if (unlimitedNaturalSymbol.signum() < 0) {
            ((Abstract2Moniker)this.context).append("*");
        } else {
            ((Abstract2Moniker)this.context).append(unlimitedNaturalSymbol.toString());
        }
        return true;
    }

    @Override
    public Object visitVariable(Variable object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object);
        return true;
    }

    @Override
    public Object visitVariableExp(VariableExp object) {
        this.appendExpPrefix(object);
        ((Abstract2Moniker)this.context).appendName(object.getReferredVariable());
        return true;
    }

    @Override
    public Object visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for Pivot2Moniker");
    }
}

