/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values;

import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.ElementValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.ObjectValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.SetValue;
import org.eclipse.ocl.examples.pivot.values.StringValue;
import org.eclipse.ocl.examples.pivot.values.TypeValue;
import org.eclipse.ocl.examples.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Value {
    public static final String INVALID_NAME = "invalid";

    public BagValue asBagValue() throws InvalidValueException;

    public boolean asBoolean() throws InvalidValueException;

    public BooleanValue asBooleanValue() throws InvalidValueException;

    public CollectionValue asCollectionValue() throws InvalidValueException;

    public Double asDouble() throws InvalidValueException;

    public Element asElement();

    public ElementValue<?> asElementValue() throws InvalidValueException;

    public Integer asInteger() throws InvalidValueException;

    public IntegerValue asIntegerValue() throws InvalidValueException;

    public Object asObject();

    public ObjectValue asObjectValue() throws InvalidValueException;

    public OrderedCollectionValue asOrderedCollectionValue() throws InvalidValueException;

    public OrderedSetValue asOrderedSetValue() throws InvalidValueException;

    public RealValue asRealValue() throws InvalidValueException;

    public SequenceValue asSequenceValue() throws InvalidValueException;

    public SetValue asSetValue() throws InvalidValueException;

    public String asString() throws InvalidValueException;

    public StringValue asStringValue() throws InvalidValueException;

    public TypeValue asTypeValue() throws InvalidValueException;

    public UniqueCollectionValue asUniqueCollectionValue() throws InvalidValueException;

    public Value asValidValue() throws InvalidValueException;

    public Type getType(TypeManager var1, Type var2);

    public ValueFactory getValueFactory();

    public CollectionValue isCollectionValue();

    public boolean isFalse();

    public IntegerValue isIntegerValue();

    public boolean isInvalid();

    public boolean isNull();

    public RealValue isRealValue();

    public boolean isTrue();

    public boolean isUndefined();

    public boolean isUnlimited();

    public boolean isUnlimitedNatural();

    public String oclToString();

    public IntegerValue toIntegerValue() throws InvalidValueException;

    public RealValue toRealValue() throws InvalidValueException;

    public void toString(StringBuffer var1, int var2);

    public static interface BinaryOperation {
        public Value evaluate(ValueFactory var1, Value var2, Value var3) throws InvalidValueException;
    }
}

