/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.SetValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractedCollectionValue
extends AbstractValue
implements CollectionValue {
    protected AbstractedCollectionValue(ValueFactory valueFactory) {
        super(valueFactory);
    }

    @Override
    public BagValue asBagValue() {
        return this.valueFactory.createBagValue(this.getElements());
    }

    @Override
    public Collection<Value> asCollection() {
        return this.getElements();
    }

    @Override
    public CollectionValue asCollectionValue() {
        return this;
    }

    @Override
    public List<Value> asList() {
        return new ArrayList<Value>(this.getElements());
    }

    @Override
    public Object asObject() {
        return this.getElements();
    }

    @Override
    public OrderedSetValue asOrderedSetValue() {
        return this.valueFactory.createOrderedSetValue(this.getElements());
    }

    @Override
    public SequenceValue asSequenceValue() {
        return this.valueFactory.createSequenceValue(this.getElements());
    }

    @Override
    public SetValue asSetValue() {
        return this.valueFactory.createSetValue(this.getElements());
    }

    @Override
    public Value asValidValue() {
        return this;
    }

    protected abstract Collection<Value> getElements();

    @Override
    public CollectionValue isCollectionValue() {
        return this;
    }

    @Override
    public BooleanValue isEmpty() {
        return this.valueFactory.booleanValueOf(this.intSize() == 0);
    }

    @Override
    public BooleanValue notEmpty() {
        return this.valueFactory.booleanValueOf(this.intSize() != 0);
    }

    @Override
    public IntegerValue size() {
        return this.valueFactory.integerValueOf(this.intSize());
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        this.toString(s, 100);
        return s.toString();
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("{");
        boolean isFirst = true;
        for (Value element : this) {
            if (!isFirst) {
                s.append(",");
            }
            if (s.length() >= lengthLimit) {
                s.append("...");
                break;
            }
            element.toString(s, lengthLimit - 1);
            isFirst = false;
        }
        s.append("}");
    }
}

