/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.Bag;
import org.eclipse.ocl.examples.pivot.values.BagValue;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractCollectionValue;
import org.eclipse.ocl.examples.pivot.values.impl.BagImpl;
import org.eclipse.ocl.examples.pivot.values.impl.SequenceValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BagValueImpl
extends AbstractCollectionValue<Bag<Value>>
implements BagValue {
    public static BagValue intersection(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        int leftSize = leftElements.size();
        int rightSize = rightElements.size();
        if (leftSize == 0 || rightSize == 0) {
            return valueFactory.getEmptyBagValue();
        }
        BagImpl<Value> results = new BagImpl<Value>();
        HashSet<Value> minElements = new HashSet<Value>(leftSize < rightSize ? leftElements : rightElements);
        for (Value e : minElements) {
            IntegerValue leftCount = left.count(e);
            IntegerValue rightCount = right.count(e);
            int i = Math.min(leftCount.asInteger(), rightCount.asInteger());
            while (i > 0) {
                results.add(e);
                --i;
            }
        }
        return results.size() > 0 ? new BagValueImpl(valueFactory, (Bag<Value>)results) : valueFactory.getEmptyBagValue();
    }

    public static BagValue union(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asBagValue();
        }
        if (rightElements.isEmpty()) {
            return left.asBagValue();
        }
        BagImpl<Value> result = new BagImpl<Value>(leftElements);
        result.addAll(rightElements);
        return new BagValueImpl(valueFactory, (Bag<Value>)result);
    }

    public BagValueImpl(ValueFactory valueFactory, Value ... elements) {
        super(valueFactory, new BagImpl());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((Bag)this.elements).add(element);
                ++n2;
            }
        }
    }

    public BagValueImpl(ValueFactory valueFactory, Collection<? extends Value> elements) {
        super(valueFactory, new BagImpl<Value>(elements));
    }

    public BagValueImpl(ValueFactory valueFactory, Bag<Value> elements) {
        super(valueFactory, elements);
    }

    @Override
    public BagValue asBagValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof BagValueImpl)) {
            return false;
        }
        return ((Bag)this.elements).equals(((BagValueImpl)obj).elements);
    }

    @Override
    public BagValue excluding(Value value) {
        BagImpl<Value> result = new BagImpl<Value>();
        for (Value element : (Bag)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((Bag)this.elements).size()) {
            return new BagValueImpl(this.valueFactory, (Bag<Value>)result);
        }
        return this;
    }

    @Override
    public BagValue flatten() throws InvalidValueException {
        BagImpl<Value> flattened = new BagImpl<Value>();
        if (this.flatten(flattened)) {
            return new BagValueImpl(this.valueFactory, (Bag<Value>)flattened);
        }
        return this;
    }

    @Override
    public CollectionKind getKind() {
        return CollectionKind.BAG;
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        return staticType;
    }

    @Override
    public BagValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        BagImpl<Value> result = new BagImpl<Value>(this.elements);
        result.add(value);
        return new BagValueImpl(this.valueFactory, (Bag<Value>)result);
    }

    @Override
    public SequenceValue sort(Comparator<Value> comparator) {
        ArrayList<Value> values = new ArrayList<Value>(this.elements);
        Collections.sort(values, comparator);
        return new SequenceValueImpl(this.valueFactory, (List<Value>)values);
    }

    @Override
    public OrderedCollectionValue toOrderedCollectionValue() {
        return new SequenceValueImpl(this.valueFactory, this.elements);
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("Bag");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends BagValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory) {
            super(valueFactory, new Value[0]);
        }

        public boolean add(Value value) {
            return ((Bag)this.elements).add(value);
        }
    }
}

