/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.SequenceValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractSequenceValue;
import org.eclipse.ocl.examples.pivot.values.impl.IntegerRangeImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegerRangeValueImpl
extends AbstractSequenceValue<IntegerRangeImpl> {
    private Type type = null;

    public IntegerRangeValueImpl(ValueFactory valueFactory, int first, int last) {
        super(valueFactory, new IntegerRangeImpl(valueFactory, first, last));
    }

    @Override
    public SequenceValue append(Value value) throws InvalidValueException {
        int nextValue;
        IntegerValue integerValue = value.asIntegerValue();
        int intValue = integerValue.asInteger();
        if (intValue == (nextValue = ((IntegerRangeImpl)this.elements).getLast() + ((IntegerRangeImpl)this.elements).getDelta())) {
            return new IntegerRangeValueImpl(this.valueFactory, ((IntegerRangeImpl)this.elements).getFirst(), nextValue);
        }
        List<Value> elements = this.createElements();
        elements.add(value);
        return this.valueFactory.createSequenceValue(elements);
    }

    @Override
    public IntegerValue count(Value value) throws InvalidValueException {
        IntegerValue integerValue = value.isIntegerValue();
        if (integerValue != null && !integerValue.isUndefined()) {
            BigInteger first = BigInteger.valueOf(((IntegerRangeImpl)this.elements).getFirst());
            BigInteger last = BigInteger.valueOf(((IntegerRangeImpl)this.elements).getLast());
            BigInteger val = integerValue.bigIntegerValue();
            if (((IntegerRangeImpl)this.elements).getDelta() > 0 ? first.compareTo(val) <= 0 && val.compareTo(last) <= 0 : last.compareTo(val) <= 0 && val.compareTo(first) <= 0) {
                return this.valueFactory.integerValueOf(1L);
            }
        }
        return this.valueFactory.integerValueOf(0L);
    }

    protected List<Value> createElements() {
        ArrayList<Value> elements = new ArrayList<Value>(this.intSize());
        for (Value value : this) {
            elements.add(value);
        }
        return elements;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof IntegerRangeValueImpl) {
            IntegerRangeValueImpl that = (IntegerRangeValueImpl)obj;
            return ((IntegerRangeImpl)this.elements).equals(that.elements);
        }
        return super.equals(obj);
    }

    @Override
    public Value first() {
        return this.valueFactory.integerValueOf(((IntegerRangeImpl)this.elements).getFirst());
    }

    @Override
    public SequenceValue flatten() {
        return this;
    }

    public List<Value> getElements() {
        if (this.elements == null) {
            this.createElements();
        }
        return (List)this.elements;
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        if (this.type == null) {
            this.type = ((IntegerRangeImpl)this.elements).getFirst() >= 0 && ((IntegerRangeImpl)this.elements).getLast() >= 0 ? typeManager.getCollectionType(true, false, typeManager.getUnlimitedNaturalType()) : typeManager.getCollectionType(true, false, typeManager.getIntegerType());
        }
        return this.type;
    }

    @Override
    public SequenceValue including(Value value) throws InvalidValueException {
        return this.append(value);
    }

    @Override
    public Value last() {
        return this.valueFactory.integerValueOf(((IntegerRangeImpl)this.elements).getLast());
    }

    @Override
    public SequenceValue prepend(Value value) throws InvalidValueException {
        int previousValue;
        IntegerValue integerValue = value.asIntegerValue();
        int intValue = integerValue.asInteger();
        if (intValue == (previousValue = ((IntegerRangeImpl)this.elements).getFirst() - ((IntegerRangeImpl)this.elements).getDelta())) {
            return new IntegerRangeValueImpl(this.valueFactory, previousValue, ((IntegerRangeImpl)this.elements).getLast());
        }
        List<Value> elements = this.createElements();
        elements.add(0, value);
        return this.valueFactory.createSequenceValue(elements);
    }

    @Override
    public SequenceValue reverse() {
        return new IntegerRangeValueImpl(this.valueFactory, ((IntegerRangeImpl)this.elements).getLast(), ((IntegerRangeImpl)this.elements).getFirst());
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("Sequence{");
        s.append(((IntegerRangeImpl)this.elements).getFirst());
        s.append("..");
        s.append(((IntegerRangeImpl)this.elements).getLast());
        s.append("}");
        s.toString();
    }
}

