/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.NumericValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

public class RealValueImpl
extends AbstractValue
implements RealValue {
    private static final int MINIMUM_SCALE = 32;
    private final BigDecimal value;
    private Object integerValue = null;

    protected static RealValue divideBigDecimal(ValueFactory valueFactory, BigDecimal left, BigDecimal right) throws InvalidValueException {
        block3: {
            try {
                if (right.signum() != 0) break block3;
                return null;
            }
            catch (ArithmeticException e) {
                throw new InvalidValueException(e);
            }
        }
        int scale = Math.max(left.scale() - right.scale(), 32);
        BigDecimal result = left.divide(right, scale, RoundingMode.HALF_EVEN);
        return valueFactory.realValueOf(result);
    }

    public RealValueImpl(ValueFactory valueFactory, double value) {
        this(valueFactory, BigDecimal.valueOf(value));
    }

    public RealValueImpl(ValueFactory valueFactory, BigDecimal value) {
        super(valueFactory);
        this.value = value;
        assert (value != null);
    }

    public RealValue abs() {
        return this.valueFactory.realValueOf(this.value.abs());
    }

    public RealValue add(RealValue right) {
        return this.valueFactory.realValueOf(this.value.add(right.bigDecimalValue()));
    }

    public Double asDouble() {
        return this.value.doubleValue();
    }

    public Object asObject() {
        return this.value;
    }

    public RealValue asRealValue() {
        return this;
    }

    public Value asValidValue() {
        return this;
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public int compareTo(NumericValue o) {
        try {
            RealValue that = o.toRealValue();
            return this.value.compareTo(that.bigDecimalValue());
        }
        catch (InvalidValueException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public RealValue divide(RealValue right) throws InvalidValueException {
        return RealValueImpl.divideBigDecimal(this.valueFactory, this.value, right.bigDecimalValue());
    }

    public double doubleValue() {
        return this.value.doubleValue();
    }

    public boolean equals(Object obj) {
        if (obj instanceof RealValue) {
            BigDecimal bigDecimalValue = ((RealValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.value.compareTo(bigDecimalValue) == 0;
        }
        if (obj instanceof IntegerValue) {
            BigDecimal bigDecimalValue = ((IntegerValue)obj).bigDecimalValue();
            return bigDecimalValue != null && this.value.compareTo(bigDecimalValue) == 0;
        }
        return false;
    }

    public IntegerValue floor() {
        return this.valueFactory.integerValueOf(this.value.setScale(0, RoundingMode.FLOOR).toBigInteger());
    }

    protected Object getIntegerValue() {
        if (this.integerValue == null) {
            try {
                BigInteger intValue = this.value.toBigIntegerExact();
                this.integerValue = this.valueFactory.integerValueOf(intValue);
            }
            catch (ArithmeticException e) {
                this.integerValue = e;
            }
        }
        return this.integerValue;
    }

    public Type getType(TypeManager typeManager, Type staticType) {
        return typeManager.getRealType();
    }

    public int hashCode() {
        Object intValue = this.getIntegerValue();
        if (intValue instanceof IntegerValue) {
            return intValue.hashCode();
        }
        return this.value.hashCode();
    }

    public RealValue isRealValue() {
        return this;
    }

    public RealValue max(RealValue right) {
        return this.valueFactory.realValueOf(this.value.max(right.bigDecimalValue()));
    }

    public RealValue min(RealValue right) {
        return this.valueFactory.realValueOf(this.value.min(right.bigDecimalValue()));
    }

    public RealValue multiply(RealValue right) {
        return this.valueFactory.realValueOf(this.value.multiply(right.bigDecimalValue()));
    }

    public RealValue negate() {
        return this.valueFactory.realValueOf(this.value.negate());
    }

    public IntegerValue round() {
        BigDecimal rounded = this.value.signum() >= 0 ? this.value.setScale(0, RoundingMode.HALF_UP) : this.value.negate().setScale(0, RoundingMode.HALF_DOWN).negate();
        return this.valueFactory.integerValueOf(rounded.toBigInteger());
    }

    public int signum() {
        return this.value.signum();
    }

    public RealValue subtract(RealValue right) {
        return this.valueFactory.realValueOf(this.value.subtract(right.bigDecimalValue()));
    }

    public IntegerValue toIntegerValue() throws InvalidValueException {
        Object intValue = this.getIntegerValue();
        if (this.integerValue instanceof Exception) {
            throw new InvalidValueException((Exception)intValue);
        }
        return (IntegerValue)intValue;
    }

    public RealValue toRealValue() {
        return this;
    }

    public String toString() {
        return this.value.toString();
    }
}

