/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.ocl.examples.pivot.CollectionKind;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.OrderedCollectionValue;
import org.eclipse.ocl.examples.pivot.values.OrderedSetValue;
import org.eclipse.ocl.examples.pivot.values.SetValue;
import org.eclipse.ocl.examples.pivot.values.UniqueCollectionValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractCollectionValue;
import org.eclipse.ocl.examples.pivot.values.impl.OrderedSetValueImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetValueImpl
extends AbstractCollectionValue<Set<Value>>
implements SetValue {
    public static SetValue intersection(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        int leftSize = leftElements.size();
        int rightSize = rightElements.size();
        if (leftSize == 0 || rightSize == 0) {
            return valueFactory.getEmptySetValue();
        }
        HashSet<Object> results = new HashSet();
        if (leftSize <= rightSize) {
            results = new HashSet<Value>(leftElements);
            results.retainAll(rightElements);
        } else {
            results = new HashSet<Value>(rightElements);
            results.retainAll(leftElements);
        }
        return results.size() > 0 ? new SetValueImpl(valueFactory, (Set<Value>)results) : valueFactory.getEmptySetValue();
    }

    public static SetValue union(ValueFactory valueFactory, CollectionValue left, CollectionValue right) throws InvalidValueException {
        assert (!left.isUndefined() && !right.isUndefined());
        Collection<Value> leftElements = left.asCollection();
        Collection<Value> rightElements = right.asCollection();
        if (leftElements.isEmpty()) {
            return right.asSetValue();
        }
        if (rightElements.isEmpty()) {
            return left.asSetValue();
        }
        HashSet<Value> result = new HashSet<Value>(leftElements);
        result.addAll(rightElements);
        return new SetValueImpl(valueFactory, (Set<Value>)result);
    }

    public static SetValue valueOfElements(ValueFactory valueFactory, Collection<? extends Element> elements) {
        HashSet<Value> results = new HashSet<Value>();
        for (Element element : elements) {
            results.add(valueFactory.createElementValue(element));
        }
        return new SetValueImpl(valueFactory, (Set<Value>)results);
    }

    public static SetValue valueOfObjects(ValueFactory valueFactory, Collection<? extends Object> objects) {
        HashSet<Value> results = new HashSet<Value>();
        for (Object object : objects) {
            results.add(valueFactory.createObjectValue(object));
        }
        return new SetValueImpl(valueFactory, (Set<Value>)results);
    }

    public SetValueImpl(ValueFactory valueFactory, Value ... elements) {
        super(valueFactory, new HashSet());
        if (elements != null) {
            Value[] valueArray = elements;
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Value element = valueArray[n2];
                ((Set)this.elements).add(element);
                ++n2;
            }
        }
    }

    public SetValueImpl(ValueFactory valueFactory, Collection<? extends Value> elements) {
        super(valueFactory, new HashSet<Value>(elements));
    }

    public SetValueImpl(ValueFactory valueFactory, Set<Value> elements) {
        super(valueFactory, elements);
    }

    @Override
    public UniqueCollectionValue asUniqueCollectionValue() {
        return this;
    }

    @Override
    public SetValue asSetValue() {
        return this;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SetValueImpl)) {
            return false;
        }
        return ((Set)this.elements).equals(((SetValueImpl)obj).elements);
    }

    @Override
    public SetValue excluding(Value value) {
        HashSet<Value> result = new HashSet<Value>();
        for (Value element : (Set)this.elements) {
            if (element.equals(value)) continue;
            result.add(element);
        }
        if (result.size() < ((Set)this.elements).size()) {
            return new SetValueImpl(this.valueFactory, (Set<Value>)result);
        }
        return this;
    }

    @Override
    public SetValue flatten() throws InvalidValueException {
        HashSet<Value> flattened = new HashSet<Value>();
        if (this.flatten(flattened)) {
            return new SetValueImpl(this.valueFactory, (Set<Value>)flattened);
        }
        return this;
    }

    @Override
    public CollectionKind getKind() {
        return CollectionKind.SET;
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        return staticType;
    }

    @Override
    public SetValue including(Value value) throws InvalidValueException {
        if (value.isInvalid()) {
            this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidSource, "including");
        }
        HashSet<Value> result = new HashSet<Value>(this.elements);
        result.add(value);
        return new SetValueImpl(this.valueFactory, (Set<Value>)result);
    }

    @Override
    public SetValue minus(UniqueCollectionValue set) throws InvalidValueException {
        HashSet<Value> result = new HashSet<Value>(this.elements);
        result.removeAll(set.asCollection());
        return new SetValueImpl(this.valueFactory, (Set<Value>)result);
    }

    @Override
    public OrderedSetValue sort(Comparator<Value> comparator) {
        ArrayList values = new ArrayList(this.elements);
        Collections.sort(values, comparator);
        return new OrderedSetValueImpl(this.valueFactory, values);
    }

    @Override
    public SetValue symmetricDifference(UniqueCollectionValue set) {
        HashSet<Value> result = new HashSet<Value>(this.elements);
        for (Value e : set) {
            if (result.contains(e)) {
                result.remove(e);
                continue;
            }
            result.add(e);
        }
        return new SetValueImpl(this.valueFactory, (Set<Value>)result);
    }

    @Override
    public OrderedCollectionValue toOrderedCollectionValue() {
        return new OrderedSetValueImpl(this.valueFactory, this.elements);
    }

    @Override
    public void toString(StringBuffer s, int lengthLimit) {
        s.append("Set");
        super.toString(s, lengthLimit);
    }

    public static class Accumulator
    extends SetValueImpl
    implements CollectionValue.Accumulator {
        public Accumulator(ValueFactory valueFactory) {
            super(valueFactory, new Value[0]);
        }

        public boolean add(Value value) {
            return ((Set)this.elements).add(value);
        }
    }
}

