/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.CollectionValue;
import org.eclipse.ocl.examples.pivot.values.TupleValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TupleValueImpl
extends AbstractValue
implements TupleValue {
    private final TupleType type;
    private final Map<String, Value> parts = new HashMap<String, Value>();
    private Integer hashCode = null;

    public TupleValueImpl(ValueFactory valueFactory, TupleType type, Map<? extends TypedElement, Value> values) {
        super(valueFactory);
        this.type = type;
        for (Map.Entry<? extends TypedElement, Value> entry : values.entrySet()) {
            this.parts.put(entry.getKey().getName(), entry.getValue());
        }
    }

    public TupleValueImpl(ValueFactory valueFactory, TupleType type, Value firstValue, Value secondValue) {
        super(valueFactory);
        this.type = type;
        this.parts.put("first", firstValue);
        this.parts.put("second", secondValue);
    }

    @Override
    public Object asObject() {
        return this.parts;
    }

    @Override
    public Value asValidValue() {
        return this;
    }

    @Override
    public TupleType getTupleType() {
        return this.type;
    }

    @Override
    public Value getValue(String partName) {
        return this.parts.get(partName);
    }

    @Override
    public Value getValue(Property part) {
        return this.getValue(part.getName());
    }

    public boolean equals(Object o) {
        boolean result = o instanceof TupleValueImpl;
        if (result) {
            TupleValueImpl other = (TupleValueImpl)o;
            result &= other.type.equals(this.type);
            result &= other.parts.equals(this.parts);
        }
        return result;
    }

    @Override
    public Type getType(TypeManager typeManager, Type staticType) {
        return this.type;
    }

    public int hashCode() {
        if (this.hashCode == null) {
            int typeHashCode = this.type.hashCode();
            int partsHashCode = this.parts.hashCode();
            this.hashCode = 37 * typeHashCode + 17 * partsHashCode;
        }
        return this.hashCode;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Tuple{");
        Iterator iter = this.getTupleType().getOwnedAttributes().iterator();
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            result.append(p.getName());
            result.append(" = ");
            result.append(this.toString(this.getValue(p)));
            if (!iter.hasNext()) continue;
            result.append(", ");
        }
        result.append("}");
        return result.toString();
    }

    private String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString();
    }

    public static String toString(CollectionValue c) {
        StringBuilder result = new StringBuilder();
        result.append(c.getKind().getName());
        result.append('{');
        boolean notFirst = false;
        Iterator<Value> iter = c.iterator();
        while (iter.hasNext()) {
            if (notFirst) {
                result.append(", ");
            } else {
                notFirst = true;
            }
            Value next = iter.next();
            if (next instanceof CollectionValue) {
                result.append(TupleValueImpl.toString((CollectionValue)next));
                continue;
            }
            if (next instanceof String) {
                result.append('\'').append(next).append('\'');
                continue;
            }
            result.append(next);
        }
        result.append('}');
        return result.toString();
    }
}

