/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.pivot.values.impl;

import java.math.BigDecimal;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.messages.EvaluatorMessages;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.values.NumericValue;
import org.eclipse.ocl.examples.pivot.values.UnlimitedValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.AbstractValue;

public class UnlimitedValueImpl
extends AbstractValue
implements UnlimitedValue {
    public UnlimitedValueImpl(ValueFactory valueFactory) {
        super(valueFactory);
    }

    public UnlimitedValueImpl abs() {
        return this;
    }

    public Object asObject() {
        return this;
    }

    public Value asValidValue() {
        return this;
    }

    public BigDecimal bigDecimalValue() {
        return null;
    }

    public int compareTo(NumericValue o) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".compareTo");
    }

    public double doubleValue() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + ".doubleValue");
    }

    public Type getType(TypeManager typeManager, Type staticType) {
        return typeManager.getUnlimitedNaturalType();
    }

    public boolean isUnlimited() {
        return true;
    }

    public boolean isUnlimitedNatural() {
        return true;
    }

    public UnlimitedValue negate() throws InvalidValueException {
        this.valueFactory.throwInvalidValueException(EvaluatorMessages.InvalidOperation, "negate", "UnlimitedValue");
        return null;
    }

    public int signum() {
        return 1;
    }

    public String toString() {
        return "*";
    }
}

