/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.internal.impl.MonikeredElementImpl;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.utilities.AbstractConversion;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TuplePartCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.impl.MonikeredElementCSImpl;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.TerminalRule;
import org.eclipse.xtext.diagnostics.DiagnosticMessage;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2Pivot
extends AbstractConversion
implements Adapter {
    private static final Logger logger = Logger.getLogger(CS2Pivot.class);
    private static Map<EPackage, Factory> factoryMap = new HashMap<EPackage, Factory>();
    private static Map<EReference, UnresolvedProxyMessageProvider> unresolvedProxyMessageProviderMap = new HashMap<EReference, UnresolvedProxyMessageProvider>();
    protected final TypeManager typeManager;
    protected final Map<? extends Resource, ? extends Resource> cs2pivotResourceMap;
    protected Map<String, MonikeredElementCS> moniker2PivotCSMap = null;
    private final Map<EPackage, BaseCSVisitor<ScopeCSAdapter, TypeManager>> scopeVisitorMap = new HashMap<EPackage, BaseCSVisitor<ScopeCSAdapter, TypeManager>>();

    public static void addFactory(Factory factory) {
        factoryMap.put(factory.getEPackage(), factory);
    }

    public static void addUnresolvedProxyMessageProvider(UnresolvedProxyMessageProvider unresolvedProxyMessageProvider) {
        unresolvedProxyMessageProviderMap.put(unresolvedProxyMessageProvider.getEReference(), unresolvedProxyMessageProvider);
    }

    public static DiagnosticMessage getUnresolvedProxyMessage(EReference eReference, EObject csContext, String linkText) {
        String message = CS2Pivot.getUnresolvedProxyText(eReference, csContext, linkText);
        return new DiagnosticMessage(message, Severity.ERROR, "org.eclipse.xtext.diagnostics.Diagnostic.Linking", new String[0]);
    }

    public static String getUnresolvedProxyText(EReference eReference, EObject csContext, String linkText) {
        EClass referenceType;
        String message;
        UnresolvedProxyMessageProvider unresolvedProxyMessageProvider = unresolvedProxyMessageProviderMap.get(eReference);
        if (unresolvedProxyMessageProvider != null && (message = unresolvedProxyMessageProvider.getMessage(csContext, linkText)) != null) {
            return message;
        }
        String messageTemplate = OCLMessages.Unresolved_ERROR_;
        String errorContext = "Unknown";
        if (eReference != null && (referenceType = eReference.getEReferenceType()) != null) {
            errorContext = referenceType.getName();
        }
        return NLS.bind((String)messageTemplate, (Object)errorContext, (Object)linkText);
    }

    public static CS2Pivot findAdapter(ResourceSet resourceSet) {
        if (resourceSet == null) {
            return null;
        }
        return (CS2Pivot)((Object)PivotUtil.getAdapter(CS2Pivot.class, (Notifier)resourceSet));
    }

    public static List<ILeafNode> getDocumentationNodes(ICompositeNode node) {
        ArrayList<ILeafNode> documentationNodes = null;
        for (INode childNode : node.getChildren()) {
            ILeafNode leafNode;
            EObject grammarElement;
            if (!(childNode instanceof ILeafNode) || !((grammarElement = (leafNode = (ILeafNode)childNode).getGrammarElement()) instanceof TerminalRule)) break;
            TerminalRule terminalRule = (TerminalRule)grammarElement;
            String name = terminalRule.getName();
            if ("DOCUMENTATION".equals(name)) {
                if (documentationNodes == null) {
                    documentationNodes = new ArrayList<ILeafNode>();
                }
                documentationNodes.add(leafNode);
                continue;
            }
            if (!"WS".equals(name) && !"SL_COMMENT".equals(name) && !"ML_COMMENT".equals(name)) break;
        }
        return documentationNodes;
    }

    public CS2Pivot(Map<? extends Resource, ? extends Resource> cs2pivotResourceMap, TypeManager typeManager) {
        this.cs2pivotResourceMap = cs2pivotResourceMap;
        this.typeManager = typeManager;
        typeManager.getPivotResourceSet().eAdapters().add((Object)this);
    }

    public CS2Pivot(CS2Pivot aConverter) {
        this.cs2pivotResourceMap = aConverter.cs2pivotResourceMap;
        this.typeManager = aConverter.typeManager;
    }

    public Map<String, MonikeredElementCS> computeMoniker2CSMap() {
        if (this.moniker2PivotCSMap == null) {
            this.moniker2PivotCSMap = this.computeMoniker2CSMap(this.getCSResources());
        }
        return this.moniker2PivotCSMap;
    }

    public Map<String, MonikeredElementCS> computeMoniker2CSMap(Collection<? extends Resource> csResources) {
        HashMap<String, MonikeredElementCS> map = new HashMap<String, MonikeredElementCS>();
        for (Resource resource : csResources) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementCS)) continue;
                MonikeredElementCS monikeredElement = (MonikeredElementCS)eObject;
                String moniker = monikeredElement.getMoniker();
                assert (moniker != null);
                MonikeredElementCS oldMonikeredElement = (MonikeredElementCS)map.get(moniker);
                if (monikeredElement instanceof NamedElementCS && !(monikeredElement instanceof TypeRefCS) && !(monikeredElement instanceof TuplePartCS)) {
                    if (oldMonikeredElement instanceof NamedElementCS && !(oldMonikeredElement instanceof TypeRefCS) && !(oldMonikeredElement instanceof TuplePartCS)) {
                        logger.warn((Object)("Duplicate CS '" + moniker + "'"));
                        continue;
                    }
                    map.put(moniker, monikeredElement);
                    continue;
                }
                if (oldMonikeredElement != null) continue;
                map.put(moniker, monikeredElement);
            }
        }
        return map;
    }

    public Collection<? extends Resource> getCSResources() {
        return this.cs2pivotResourceMap.keySet();
    }

    public Factory getFactory(EPackage ePackage) {
        return factoryMap.get(ePackage);
    }

    public Resource getPivotResource(Resource csResource) {
        return this.cs2pivotResourceMap.get(csResource);
    }

    public Collection<? extends Resource> getPivotResources() {
        return this.typeManager.getPivotResourceSet().getResources();
    }

    public BaseCSVisitor<ScopeCSAdapter, TypeManager> getScopeVisitor(EPackage ePackage) {
        BaseCSVisitor<ScopeCSAdapter, TypeManager> scopeVisitor = this.scopeVisitorMap.get(ePackage);
        if (scopeVisitor == null && !this.scopeVisitorMap.containsKey(ePackage)) {
            Factory factory = this.getFactory(ePackage);
            if (factory != null) {
                scopeVisitor = factory.createScopeVisitor(this.typeManager);
                if (scopeVisitor == null) {
                    logger.error((Object)("No Scope Visitor created for " + ePackage.getName()));
                }
            } else {
                logger.error((Object)("No Scope Visitor Factory registered for " + ePackage.getName()));
            }
            this.scopeVisitorMap.put(ePackage, scopeVisitor);
        }
        return scopeVisitor;
    }

    public Notifier getTarget() {
        return this.typeManager.getPivotResourceSet();
    }

    public TypeManager getTypeManager() {
        return this.typeManager;
    }

    public boolean isAdapterForType(Object type) {
        if (type instanceof Class) {
            return ((Class)type).isAssignableFrom(((Object)((Object)this)).getClass());
        }
        return false;
    }

    public void notifyChanged(Notification notification) {
    }

    public void resetCSMonikers() {
        for (Resource resource : this.getCSResources()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementCSImpl)) continue;
                ((MonikeredElementCSImpl)eObject).resetMoniker();
            }
        }
    }

    public void resetPivotMonikers() {
        for (Resource resource : this.getPivotResources()) {
            TreeIterator it = resource.getAllContents();
            while (it.hasNext()) {
                EObject eObject = (EObject)it.next();
                if (!(eObject instanceof MonikeredElementImpl)) continue;
                ((MonikeredElementImpl)eObject).resetMoniker();
            }
        }
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.typeManager.getPivotResourceSet());
    }

    public void update(IDiagnosticConsumer diagnosticsConsumer) {
        this.moniker2PivotCSMap = null;
        CS2PivotConversion conversion = new CS2PivotConversion(this, diagnosticsConsumer, this.getCSResources());
        conversion.update();
        Collection<? extends Resource> pivotResources = this.cs2pivotResourceMap.values();
        conversion.garbageCollect(pivotResources);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Factory {
        public BaseCSVisitor<MonikeredElement, CS2PivotConversion> createLeft2RightVisitor(CS2PivotConversion var1);

        public BaseCSVisitor<Continuation<?>, CS2PivotConversion> createPostOrderVisitor(CS2PivotConversion var1);

        public BaseCSVisitor<Continuation<?>, CS2PivotConversion> createPreOrderVisitor(CS2PivotConversion var1);

        public BaseCSVisitor<ScopeCSAdapter, TypeManager> createScopeVisitor(TypeManager var1);

        public EPackage getEPackage();
    }

    public static abstract class UnresolvedProxyMessageProvider {
        protected final EReference eReference;

        public UnresolvedProxyMessageProvider(EReference eReference) {
            this.eReference = eReference;
        }

        public EReference getEReference() {
            return this.eReference;
        }

        public abstract String getMessage(EObject var1, String var2);
    }
}

