/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.cs2pivot;

import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.DataType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Enumeration;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeTemplateParameter;
import org.eclipse.ocl.examples.pivot.UnspecifiedType;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.VoidType;
import org.eclipse.ocl.examples.pivot.util.AbstractExtendingVisitor;
import org.eclipse.ocl.examples.pivot.util.Visitable;
import org.eclipse.ocl.examples.pivot.utilities.PivotConstants;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.AbstractScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.ClassScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.EmptyScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.EnumerationScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.ExpressionInOclScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.IterateExpScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.IteratorExpScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.LetExpScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.OperationCallExpScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.OperationScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.PackageScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.RootPackageScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.pivot.VoidTypeScopeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PivotScopeVisitor
extends AbstractExtendingVisitor<ScopeAdapter, TypeManager>
implements PivotConstants {
    public PivotScopeVisitor(TypeManager context) {
        super((Object)context);
        assert (context != null);
    }

    public ScopeAdapter visitClass(Class pivotElement) {
        return new ClassScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitConstraint(Constraint pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitDataType(DataType pivotElement) {
        Type behavioralType = pivotElement.getBehavioralType();
        if (behavioralType != null) {
            return AbstractScopeAdapter.getScopeAdapter((TypeManager)this.context, (Element)behavioralType);
        }
        return (ScopeAdapter)super.visitDataType(pivotElement);
    }

    public ScopeAdapter visitEnumeration(Enumeration pivotElement) {
        return new EnumerationScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitExpressionInOcl(ExpressionInOcl pivotElement) {
        return new ExpressionInOclScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitIfExp(IfExp pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitInvalidLiteralExp(InvalidLiteralExp pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitInvalidType(InvalidType pivotElement) {
        return new VoidTypeScopeAdapter((TypeManager)this.context, (Class)pivotElement);
    }

    public ScopeAdapter visitIterateExp(IterateExp pivotElement) {
        return new IterateExpScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitIteratorExp(IteratorExp pivotElement) {
        return new IteratorExpScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitLetExp(LetExp pivotElement) {
        return new LetExpScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitOperation(Operation pivotElement) {
        return new OperationScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitOperationCallExp(OperationCallExp pivotElement) {
        return new OperationCallExpScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitPackage(Package pivotElement) {
        if (pivotElement.eContainer() == null) {
            return new RootPackageScopeAdapter((TypeManager)this.context, pivotElement);
        }
        return new PackageScopeAdapter((TypeManager)this.context, pivotElement);
    }

    public ScopeAdapter visitProperty(Property pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitPropertyCallExp(PropertyCallExp pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitTemplateSignature(TemplateSignature pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitTypeTemplateParameter(TypeTemplateParameter pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitUnspecifiedType(UnspecifiedType pivotElement) {
        return AbstractScopeAdapter.getScopeAdapter((TypeManager)this.context, (Element)pivotElement.getLowerBound());
    }

    public ScopeAdapter visitVariable(Variable pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitVariableExp(VariableExp pivotElement) {
        return new EmptyScopeAdapter((TypeManager)this.context, (Element)pivotElement);
    }

    public ScopeAdapter visitVoidType(VoidType pivotElement) {
        return new VoidTypeScopeAdapter((TypeManager)this.context, (Class)pivotElement);
    }

    public ScopeAdapter visiting(Visitable visitable) {
        throw new IllegalArgumentException("Unsupported " + visitable.eClass().getName() + " for PivotScopeVisitor");
    }
}

