/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scoping.cs;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.util.Nameable;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.scope.BaseScopeView;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.cs.ElementCSScopeAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModelElementCSScopeAdapter<CS extends ModelElementCS, P extends Element>
extends ElementCSScopeAdapter<CS> {
    protected final Class<CS> csClass;
    protected final Class<P> pivotClass;

    protected ModelElementCSScopeAdapter(TypeManager typeManager, CS csElement, Class<P> pivotClass) {
        this(typeManager, csElement.eContainer(), csElement, pivotClass);
    }

    protected ModelElementCSScopeAdapter(TypeManager typeManager, EObject csParent, CS csElement, Class<P> pivotClass) {
        this(typeManager, csParent != null ? ModelElementCSScopeAdapter.getScopeCSAdapter((ElementCS)csParent) : null, csElement, pivotClass);
    }

    private ModelElementCSScopeAdapter(TypeManager typeManager, ScopeCSAdapter parentScopeAdapter, CS csElement, Class<P> pivotClass) {
        super(typeManager, parentScopeAdapter, csElement);
        this.csClass = csElement.getClass();
        this.pivotClass = pivotClass;
    }

    public P getPivot() {
        Element pivot = ((ModelElementCS)this.target).getPivot();
        if (pivot == null) {
            return null;
        }
        if (!this.pivotClass.isAssignableFrom(pivot.getClass())) {
            throw new ClassCastException(String.valueOf(pivot.getClass().getName()) + " is not assignable to " + this.pivotClass.getName());
        }
        Element castPivot = pivot;
        return (P)castPivot;
    }

    protected ScopeView getNamespaceScope(EnvironmentView environmentView, ScopeView scopeView, List<Namespace> namespaces) {
        int namespaceCount = namespaces.size();
        if (namespaceCount > 0) {
            Namespace namespace = namespaces.get(namespaceCount - 1);
            if (namespace == null || namespace.eIsProxy()) {
                return null;
            }
            ScopeAdapter scopeAdapter = ModelElementCSScopeAdapter.getScopeAdapter(this.typeManager, (Element)namespace);
            if (scopeAdapter != null) {
                BaseScopeView nestedScopeView = new BaseScopeView(this.typeManager, scopeAdapter, null, (EStructuralFeature)scopeView.getTargetReference(), null);
                environmentView.computeLookups(nestedScopeView);
            }
            return null;
        }
        return scopeView.getOuterScope();
    }

    protected ScopeView getNextNamespaceScope(EnvironmentView environmentView, ScopeView scopeView, EList<Namespace> namespaces) {
        InternalEList internalNamespaces = (InternalEList)namespaces;
        int iMax = internalNamespaces.size();
        int i = 0;
        while (i < iMax) {
            Namespace namespace = (Namespace)internalNamespaces.basicGet(i);
            if (namespace.eIsProxy()) {
                if (i <= 0) {
                    return scopeView.getOuterScope();
                }
                Namespace parentNamespace = (Namespace)internalNamespaces.get(i - 1);
                ScopeAdapter scopeAdapter = ModelElementCSScopeAdapter.getScopeAdapter(this.typeManager, (Element)parentNamespace);
                if (scopeAdapter != null) {
                    BaseScopeView nestedScopeView = new BaseScopeView(this.typeManager, scopeAdapter, null, (EStructuralFeature)scopeView.getTargetReference(), null);
                    environmentView.computeLookups(nestedScopeView);
                }
                return null;
            }
            ++i;
        }
        for (Namespace namespace : namespaces) {
            environmentView.addNamedElement((Nameable)namespace);
            if (environmentView.hasFinalResult()) break;
        }
        return null;
    }
}

