/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.scoping.pivot;

import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.PivotScopeVisitor;
import org.eclipse.ocl.examples.xtext.base.scope.BaseScopeView;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.RootScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.util.BaseCSVisitor;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractScopeAdapter<T extends EObject>
implements ScopeAdapter,
Adapter.Internal {
    private static final Logger logger = Logger.getLogger(AbstractScopeAdapter.class);
    protected final T target;
    protected final ScopeAdapter parent;

    public static RootScopeAdapter getDocumentScopeAdapter(TypeManager typeManager, Element context) {
        ScopeAdapter scopeAdapter = AbstractScopeAdapter.getScopeAdapter(typeManager, context);
        while (scopeAdapter != null) {
            if (scopeAdapter instanceof RootScopeAdapter) {
                return (RootScopeAdapter)scopeAdapter;
            }
            scopeAdapter = scopeAdapter.getParent();
        }
        return null;
    }

    public static RootScopeAdapter getDocumentScopeAdapter(ModelElementCS context) {
        ScopeAdapter scopeAdapter = AbstractScopeAdapter.getScopeCSAdapter(context);
        while (scopeAdapter != null) {
            if (scopeAdapter instanceof RootScopeAdapter) {
                return (RootScopeAdapter)scopeAdapter;
            }
            scopeAdapter = scopeAdapter.getParent();
        }
        return null;
    }

    public static ScopeAdapter getScopeAdapter(TypeManager typeManager, Element eObject) {
        if (eObject == null) {
            logger.warn((Object)"getScopeAdapter for null");
            return null;
        }
        if (eObject.eIsProxy()) {
            logger.warn((Object)("getScopeAdapter for proxy " + eObject));
            return null;
        }
        ScopeAdapter adapter = (ScopeAdapter)PivotUtil.getAdapter(ScopeAdapter.class, (Notifier)eObject);
        if (adapter != null) {
            return adapter;
        }
        PivotScopeVisitor visitor = new PivotScopeVisitor(typeManager);
        return (ScopeAdapter)eObject.accept((Visitor)visitor);
    }

    public static ScopeCSAdapter getScopeCSAdapter(ElementCS csElement) {
        if (csElement == null) {
            logger.warn((Object)"getScopeCSAdapter for null");
            return null;
        }
        if (csElement.eIsProxy()) {
            logger.warn((Object)("getScopeCSAdapter for proxy " + csElement));
            return null;
        }
        ScopeCSAdapter adapter = (ScopeCSAdapter)PivotUtil.getAdapter(ScopeCSAdapter.class, (Notifier)csElement, ScopeAdapter.class);
        if (adapter != null) {
            return adapter;
        }
        BaseCSResource csResource = (BaseCSResource)csElement.eResource();
        CS2PivotResourceAdapter resourceAdapter = CS2PivotResourceAdapter.getAdapter(csResource, null);
        CS2Pivot converter = resourceAdapter.getConverter();
        EClass eClass = csElement.eClass();
        EPackage ePackage = eClass.getEPackage();
        BaseCSVisitor<ScopeCSAdapter, TypeManager> visitor = converter.getScopeVisitor(ePackage);
        return (ScopeCSAdapter)csElement.accept(visitor);
    }

    protected AbstractScopeAdapter(TypeManager typeManager, ScopeAdapter parent, T target) {
        this.parent = parent;
        this.target = target;
        target.eAdapters().add((Object)this);
    }

    @Override
    public ScopeView computeLookup(EnvironmentView environmentView, ScopeView scopeView) {
        return scopeView.getOuterScope();
    }

    @Override
    public final void computeLookup(EnvironmentView environmentView, EReference targetReference) {
        ScopeView scopeView = this.getInnerScopeView(environmentView.getTypeManager(), targetReference);
        this.computeLookup(environmentView, scopeView);
    }

    public void dispose() {
        if (this.target != null) {
            this.target.eAdapters().remove((Object)this);
        }
    }

    @Override
    public ScopeView getInnerScopeView(TypeManager typeManager, EReference targetReference) {
        return new BaseScopeView(typeManager, this, null, null, targetReference);
    }

    @Override
    public ScopeView getOuterScopeView(TypeManager typeManager, EReference targetReference) {
        ScopeAdapter parent = this.getParent();
        return new BaseScopeView(typeManager, parent, (EObject)this.target, this.target.eContainingFeature(), targetReference);
    }

    @Override
    public ScopeAdapter getParent() {
        return this.parent;
    }

    @Override
    public ScopeAdapter getSourceScope(EStructuralFeature containmentFeature) {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getSimpleName()) + ".getSourceScope for " + this.target.eClass().getName());
    }

    public T getTarget() {
        return this.target;
    }

    public boolean isAdapterFor(TypeManager typeManager) {
        return false;
    }

    public boolean isAdapterForType(Object type) {
        return type == ScopeAdapter.class;
    }

    public void notifyChanged(Notification msg) {
    }

    public void setTarget(Notifier newTarget) {
        assert (newTarget == this.target);
        int count = 0;
        for (Adapter adapter : newTarget.eAdapters()) {
            if (!(adapter instanceof ScopeAdapter)) continue;
            ++count;
        }
        assert (count == 1);
    }

    public void unsetTarget(Notifier oldTarget) {
        if (oldTarget != this.target) {
            throw new UnsupportedOperationException();
        }
    }
}

