/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.LibraryDiagnostic;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.xtext.diagnostics.Diagnostic;
import org.eclipse.xtext.diagnostics.ExceptionDiagnostic;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.linking.lazy.LazyLinker;

public class CS2PivotLinker
extends LazyLinker {
    protected void afterModelLinked(EObject model, IDiagnosticConsumer diagnosticsConsumer) {
        Resource eResource = model.eResource();
        if (eResource instanceof BaseCSResource && eResource.getErrors().isEmpty()) {
            BaseCSResource csResource = (BaseCSResource)eResource;
            try {
                CS2PivotResourceAdapter resourceAdapter = CS2PivotResourceAdapter.getAdapter(csResource, null);
                resourceAdapter.refreshPivotMappings(diagnosticsConsumer);
            }
            catch (Exception exception) {
                Exception cause;
                Exception exception2 = cause = exception instanceof Resource.IOWrappedException ? (Exception)exception.getCause() : exception;
                if (cause instanceof IllegalLibraryException) {
                    diagnosticsConsumer.consume((Diagnostic)new LibraryDiagnostic(cause), Severity.ERROR);
                }
                diagnosticsConsumer.consume((Diagnostic)new ExceptionDiagnostic(cause), Severity.ERROR);
            }
        }
    }

    public static class DiagnosticWrappedException
    extends WrappedException
    implements Resource.Diagnostic {
        private static final long serialVersionUID = 1L;

        public DiagnosticWrappedException(Exception exception) {
            super(exception);
        }

        public String getLocation() {
            return "unknown";
        }

        public int getColumn() {
            return 0;
        }

        public int getLine() {
            return 0;
        }
    }
}

