/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceAdapter;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.xtext.diagnostics.IDiagnosticConsumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CS2PivotResourceAdapter
extends TypeManagerResourceAdapter {
    private final CS2Pivot converter;

    public static CS2PivotResourceAdapter findAdapter(BaseCSResource csResource) {
        if (csResource == null) {
            return null;
        }
        TypeManagerResourceAdapter adapter = (TypeManagerResourceAdapter)PivotUtil.getAdapter(TypeManagerResourceAdapter.class, (Notifier)csResource);
        if (adapter == null) {
            return null;
        }
        if (adapter instanceof CS2PivotResourceAdapter) {
            return (CS2PivotResourceAdapter)adapter;
        }
        EList eAdapters = csResource.eAdapters();
        eAdapters.remove(adapter);
        CS2PivotResourceAdapter derivedAdapter = new CS2PivotResourceAdapter(csResource, adapter.getTypeManager());
        eAdapters.add(derivedAdapter);
        return derivedAdapter;
    }

    public static CS2PivotResourceAdapter getAdapter(BaseCSResource csResource, TypeManager typeManager) {
        EList eAdapters = csResource.eAdapters();
        CS2PivotResourceAdapter adapter = CS2PivotResourceAdapter.findAdapter(csResource);
        if (adapter == null) {
            if (typeManager == null) {
                TypeManagerResourceSetAdapter rsAdapter = TypeManagerResourceSetAdapter.findAdapter((ResourceSet)csResource.getResourceSet());
                if (rsAdapter != null) {
                    typeManager = rsAdapter.getTypeManager();
                }
                if (typeManager == null) {
                    typeManager = csResource.createTypeManager();
                }
            }
            adapter = new CS2PivotResourceAdapter(csResource, typeManager);
            eAdapters.add(adapter);
        }
        return adapter;
    }

    public CS2PivotResourceAdapter(BaseCSResource csResource, TypeManager typeManager) {
        super((Resource)csResource, typeManager);
        Map<Resource, Resource> cs2pivotResourceMap = this.computeCS2PivotResourceMap(csResource, typeManager);
        this.converter = csResource.createCS2Pivot(cs2pivotResourceMap, typeManager);
    }

    public Map<Resource, Resource> computeCS2PivotResourceMap(Resource csResource, TypeManager typeManager) {
        ResourceSet pivotResourceSet = typeManager.getTarget();
        HashMap<Resource, Resource> cs2pivotResourceMap = new HashMap<Resource, Resource>();
        Resource acsResource = csResource;
        URI uri = acsResource.getURI();
        EList contents = acsResource.getContents();
        if (contents.size() > 0 && contents.get(0) instanceof ModelElementCS) {
            URI pivotURI = PivotUtil.getPivotURI((URI)uri);
            Resource pivotResource = pivotResourceSet.getResource(pivotURI, false);
            if (pivotResource == null) {
                pivotResource = pivotResourceSet.createResource(pivotURI, "org.eclipse.ocl.examples.pivot");
            }
            cs2pivotResourceMap.put(acsResource, pivotResource);
        }
        return cs2pivotResourceMap;
    }

    public CS2Pivot getConverter() {
        return this.converter;
    }

    public Resource getPivotResource(Resource csResource) {
        return this.converter.getPivotResource(csResource);
    }

    public boolean isAdapterForType(Object type) {
        return super.isAdapterForType(type) || type == CS2PivotResourceAdapter.class;
    }

    public void refreshPivotMappings(IDiagnosticConsumer diagnosticsConsumer) throws Exception {
        try {
            this.converter.update(diagnosticsConsumer);
        }
        catch (Exception e) {
            this.dispose();
            throw e;
        }
    }
}

