/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.base.utilities;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.TemplateBinding;
import org.eclipse.ocl.examples.pivot.TemplateParameter;
import org.eclipse.ocl.examples.pivot.TemplateSignature;
import org.eclipse.ocl.examples.pivot.TemplateableElement;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ClassCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.OperationCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ParameterableElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateBindingCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TemplateParameterSubstitutionCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.WildcardTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2Pivot;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.scoping.cs.ModelElementCSScopeAdapter;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementUtil {
    public static String getCollectionTypeName(TypedElementCS csTypedElement) {
        int upper;
        String multiplicity = csTypedElement.getMultiplicity();
        if (multiplicity != null ? "?".equals(multiplicity) : (upper = csTypedElement.getUpper()) == 1) {
            return null;
        }
        EList<String> qualifiers = csTypedElement.getQualifier();
        boolean isOrdered = true;
        boolean isUnique = true;
        if (qualifiers.contains("!ordered")) {
            isOrdered = false;
        } else if (qualifiers.contains("ordered")) {
            isOrdered = true;
        }
        if (qualifiers.contains("!unique")) {
            isUnique = false;
        } else if (qualifiers.contains("unique")) {
            isUnique = true;
        }
        if (isOrdered) {
            return isUnique ? "OrderedSet" : "Sequence";
        }
        return isUnique ? "Set" : "Bag";
    }

    public static MonikeredElementCS getCsElement(MonikeredElement obj) {
        Resource resource = obj.eResource();
        if (resource == null) {
            return null;
        }
        ResourceSet resourceSet = resource.getResourceSet();
        if (resourceSet == null) {
            return null;
        }
        CS2Pivot cs2Pivot = CS2Pivot.findAdapter(resourceSet);
        if (cs2Pivot == null) {
            return null;
        }
        String moniker = obj.getMoniker();
        Map<String, MonikeredElementCS> moniker2CSMap = cs2Pivot.computeMoniker2CSMap();
        MonikeredElementCS csMonikeredElement = moniker2CSMap.get(moniker);
        return csMonikeredElement;
    }

    public static TemplateParameter getFormalTemplateParameter(TemplateParameterSubstitutionCS csTemplateParameterSubstitution) {
        TemplateBindingCS csTemplateBinding = csTemplateParameterSubstitution.getOwningTemplateBinding();
        int index = csTemplateBinding.getOwnedParameterSubstitution().indexOf((Object)csTemplateParameterSubstitution);
        if (index < 0) {
            return null;
        }
        TemplateBinding templateBinding = (TemplateBinding)csTemplateBinding.getPivot();
        TemplateSignature templateSignature = templateBinding.getSignature();
        EList templateParameters = templateSignature.getOwnedParameters();
        if (templateParameters.size() <= index) {
            return null;
        }
        return (TemplateParameter)templateParameters.get(index);
    }

    public static ILeafNode getLeafNode(INode node) {
        ILeafNode leafNode = null;
        if (node instanceof ILeafNode) {
            return (ILeafNode)node;
        }
        for (ILeafNode lNode : node.getLeafNodes()) {
            if (lNode.isHidden()) continue;
            leafNode = lNode;
            return leafNode;
        }
        return null;
    }

    public static int getLower(TypedElementCS csTypedElement) {
        String multiplicity = csTypedElement.getMultiplicity();
        if (multiplicity == null) {
            if (csTypedElement.getOwnedType() == null) {
                return 0;
            }
        } else {
            if ("*".equals(multiplicity)) {
                return 0;
            }
            if ("+".equals(multiplicity)) {
                return 1;
            }
            if ("?".equals(multiplicity)) {
                return 0;
            }
        }
        return csTypedElement.getLower();
    }

    public static <T extends NamedElementCS> T getNamedElementCS(Collection<T> namedElements, String name) {
        for (NamedElementCS namedElement : namedElements) {
            if (!name.equals(namedElement.getName())) continue;
            return (T)namedElement;
        }
        return null;
    }

    public static boolean getQualifier(List<String> qualifiers, String trueString, String falseString, boolean defaultValue) {
        if (qualifiers.contains(trueString)) {
            return true;
        }
        if (qualifiers.contains(falseString)) {
            return false;
        }
        return defaultValue;
    }

    public static ScopeAdapter getScopeAdapter(TypeManager typeManager, Element element) {
        return ModelElementCSScopeAdapter.getScopeAdapter(typeManager, element);
    }

    public static ScopeCSAdapter getScopeCSAdapter(ElementCS csElement) {
        return ModelElementCSScopeAdapter.getScopeCSAdapter(csElement);
    }

    public static String getText(ElementCS csElement) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)csElement);
        return NodeModelUtils.getTokenText((INode)node);
    }

    public static String getText(TypedTypeRefCS csElement, EReference feature) {
        List nodes = NodeModelUtils.findNodesForFeature((EObject)csElement, (EStructuralFeature)feature);
        assert (nodes.size() == 1);
        if (nodes == null || nodes.isEmpty()) {
            return null;
        }
        if (nodes.size() == 1) {
            return NodeModelUtils.getTokenText((INode)((INode)nodes.get(0)));
        }
        StringBuffer s = new StringBuffer();
        for (INode node : nodes) {
            s.append(NodeModelUtils.getTokenText((INode)node));
        }
        return s.toString();
    }

    public static int getUpper(TypedElementCS csTypedElement) {
        String multiplicity = csTypedElement.getMultiplicity();
        if (multiplicity == null) {
            if (csTypedElement.getOwnedType() == null) {
                return 1;
            }
        } else {
            if ("*".equals(multiplicity)) {
                return -1;
            }
            if ("+".equals(multiplicity)) {
                return -1;
            }
            if ("?".equals(multiplicity)) {
                return 1;
            }
        }
        return csTypedElement.getUpper();
    }

    public static boolean isInOperation(ElementCS csElement) {
        ElementCS eObject = csElement;
        while (eObject != null) {
            if (eObject instanceof OperationCS) {
                return true;
            }
            if (eObject instanceof ClassCS) {
                return false;
            }
            eObject = eObject.eContainer();
        }
        return false;
    }

    public static boolean isOrdered(TypedElementCS csTypedElement) {
        return csTypedElement.getQualifier().contains((Object)"ordered");
    }

    public static boolean isUnique(TypedElementCS csTypedElement) {
        return ElementUtil.getQualifier(csTypedElement.getQualifier(), "unique", "!unique", true);
    }

    public static boolean isSpecialization(TemplateBindingCS csTemplateBinding) {
        TypedTypeRefCS csTypedTypeRef = csTemplateBinding.getOwningTemplateBindableElement();
        Element type = csTypedTypeRef.getPivot();
        for (TemplateParameterSubstitutionCS csTemplateParameterSubstitution : csTemplateBinding.getOwnedParameterSubstitution()) {
            ParameterableElementCS ownedActualParameter = csTemplateParameterSubstitution.getOwnedActualParameter();
            if (ownedActualParameter instanceof WildcardTypeRefCS) {
                return true;
            }
            Class actualParameterClass = (Class)ownedActualParameter.getPivot();
            TemplateParameter owningTemplateParameter = actualParameterClass.getOwningTemplateParameter();
            if (owningTemplateParameter == null) {
                return true;
            }
            TemplateSignature signature = owningTemplateParameter.getSignature();
            TemplateableElement template = signature.getTemplate();
            if (template == type) continue;
            return true;
        }
        return false;
    }
}

