/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.scoping;

import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Namespace;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.ValidationDiagnostic;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.scoping.cs.MonikeredElementCSScopeAdapter;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.CompleteOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.completeocl.completeOCLCST.IncludeCS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IncludeScopeAdapter
extends MonikeredElementCSScopeAdapter<IncludeCS, Namespace> {
    private URI uri = null;
    private Element importedElement = null;
    private Throwable throwable = null;

    public IncludeScopeAdapter(TypeManager typeManager, IncludeCS csElement) {
        super(typeManager, (MonikeredElementCS)csElement, Namespace.class);
    }

    public ScopeView computeLookup(EnvironmentView environmentView, ScopeView scopeView) {
        EReference targetReference = scopeView.getTargetReference();
        if (targetReference == CompleteOCLCSTPackage.Literals.INCLUDE_CS__NAMESPACE) {
            Resource importedResource;
            EList errors;
            String name = environmentView.getName();
            if (name != null) {
                this.importComplement(environmentView);
            }
            if (this.importedElement != null && (errors = (importedResource = this.importedElement.eResource()).getErrors()).size() == 0) {
                environmentView.addElement(name, (EObject)this.importedElement);
            }
            return null;
        }
        EStructuralFeature containmentFeature = scopeView.getContainmentFeature();
        if (containmentFeature == null) {
            environmentView.addElementsOfScope(this.importedElement, scopeView);
        } else {
            environmentView.addElementsOfScope(this.importedElement, scopeView);
        }
        return scopeView.getOuterScope();
    }

    public String getMessage() {
        return this.throwable != null ? this.throwable.getMessage() : null;
    }

    protected void importComplement(EnvironmentView environmentView) {
        String name = environmentView.getName();
        if (name == null) {
            return;
        }
        BaseCSResource csResource = (BaseCSResource)((IncludeCS)this.target).eResource();
        try {
            URI newURI = URI.createURI((String)name);
            newURI = csResource.resolve(newURI);
            if (newURI.equals((Object)this.uri)) {
                return;
            }
            this.uri = newURI;
            this.importedElement = null;
            this.throwable = null;
        }
        catch (WrappedException e) {
            this.throwable = e.exception();
            return;
        }
        catch (Exception e) {
            this.throwable = e;
            return;
        }
        try {
            EList errors;
            this.importedElement = this.typeManager.loadResource(this.uri, ((IncludeCS)this.target).getName());
            Resource importedResource = this.importedElement.eResource();
            EList warnings = importedResource.getWarnings();
            if (warnings.size() > 0) {
                ICompositeNode node = NodeModelUtils.getNode((EObject)this.target);
                String errorMessage = PivotUtil.formatResourceDiagnostics((List)warnings, (String)("Warnings in '" + this.uri + "'"), (String)"\n\t");
                ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                csResource.getWarnings().add((Object)resourceDiagnostic);
            }
            if ((errors = importedResource.getErrors()).size() > 0) {
                ICompositeNode node = NodeModelUtils.getNode((EObject)this.target);
                String errorMessage = PivotUtil.formatResourceDiagnostics((List)errors, (String)("Errors in '" + this.uri + "'"), (String)"\n\t");
                ValidationDiagnostic resourceDiagnostic = new ValidationDiagnostic((INode)node, errorMessage);
                csResource.getErrors().add((Object)resourceDiagnostic);
            }
        }
        catch (WrappedException e) {
            this.throwable = e.exception();
        }
        catch (Exception e) {
            this.throwable = e;
        }
    }
}

