/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.completeocl.validation;

import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.ocl.examples.pivot.Constraint;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.ValueSpecification;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.ecore.Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Visitor;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.xtext.base.utilities.BaseCSResource;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2PivotResourceAdapter;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompleteOCLEObjectValidator
extends EObjectValidator {
    private static final Logger logger = Logger.getLogger(CompleteOCLEObjectValidator.class);
    protected final EPackage ePackage;
    protected final URI oclURI;
    private Ecore2Pivot ecore2Pivot = null;
    private EnvironmentFactory environmentFactory = null;
    private Environment rootEnvironment = null;

    public CompleteOCLEObjectValidator(EPackage ePackage, URI oclURI) {
        this.ePackage = ePackage;
        this.oclURI = oclURI;
    }

    protected EPackage getEPackage() {
        return this.ePackage;
    }

    protected String getLabel(EClassifier eClassifier, Object object, Map<Object, Object> context) {
        if (eClassifier instanceof EDataType) {
            return EObjectValidator.getValueLabel((EDataType)((EDataType)eClassifier), (Object)object, context);
        }
        if (object instanceof EObject) {
            return EObjectValidator.getObjectLabel((EObject)((EObject)object), context);
        }
        return String.valueOf(object);
    }

    protected void initialize() {
        CS2PivotResourceAdapter adapter;
        Resource pivotResource;
        Ecore2Pivot ecore2Pivot;
        Package pivotRoot;
        this.ecore2Pivot = Ecore2Pivot.getAdapter((Resource)this.ePackage.eResource(), null);
        TypeManager typeManager = this.ecore2Pivot.getTypeManager();
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        TypeManagerResourceSetAdapter.getAdapter((ResourceSet)resourceSet, (TypeManager)typeManager);
        Resource ecoreResource = this.ePackage.eResource();
        String message = PivotUtil.formatResourceDiagnostics((List)ecoreResource.getErrors(), (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load Ecore '" + ecoreResource.getURI() + message));
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)(pivotRoot = (ecore2Pivot = Ecore2Pivot.getAdapter((Resource)ecoreResource, (TypeManager)typeManager)).getPivotRoot()).eResource().getErrors(), (String)"", (String)"\n")) != null) {
            logger.error((Object)("Failed to load Pivot from '" + ecoreResource.getURI() + message));
        }
        BaseCSResource xtextResource = null;
        try {
            xtextResource = (BaseCSResource)resourceSet.getResource(this.oclURI, true);
        }
        catch (WrappedException e) {
            IStatus status;
            URI retryURI = null;
            Throwable cause = e.getCause();
            if (cause instanceof CoreException && (status = ((CoreException)cause).getStatus()).getCode() == 368 && status.getPlugin().equals("org.eclipse.core.resources") && this.oclURI.isPlatformResource()) {
                retryURI = URI.createPlatformPluginURI((String)this.oclURI.toPlatformString(false), (boolean)false);
            }
            if (retryURI != null) {
                xtextResource = (BaseCSResource)resourceSet.getResource(retryURI, true);
            }
            throw e;
        }
        message = PivotUtil.formatResourceDiagnostics((List)xtextResource.getErrors(), (String)"", (String)"\n");
        if (message != null) {
            logger.error((Object)("Failed to load '" + this.oclURI + message));
        }
        if ((message = PivotUtil.formatResourceDiagnostics((List)(pivotResource = (adapter = CS2PivotResourceAdapter.getAdapter((BaseCSResource)xtextResource, (TypeManager)typeManager)).getPivotResource((Resource)xtextResource)).getErrors(), (String)"", (String)"\n")) != null) {
            logger.error((Object)("Failed to load Pivot from '" + this.oclURI + message));
        }
        this.environmentFactory = new PivotEnvironmentFactory(null, typeManager);
        this.rootEnvironment = this.environmentFactory.createEnvironment();
    }

    public boolean validate(EClass eClass, EObject eObject, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (eObject.eIsProxy()) {
            return true;
        }
        return this.validatePivot((EClassifier)eClass, eObject, diagnostics, context);
    }

    public boolean validate(EDataType eDataType, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (!eDataType.isInstance(value)) {
            return true;
        }
        return this.validatePivot((EClassifier)eDataType, value, diagnostics, context);
    }

    protected boolean validatePivot(EClassifier eClassifier, Object object, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (this.ecore2Pivot == null) {
            this.initialize();
        }
        boolean allOk = true;
        TypeManager typeManager = this.ecore2Pivot.getTypeManager();
        Type type = (Type)this.ecore2Pivot.getCreated(Type.class, (EObject)eClassifier);
        for (Constraint constraint : typeManager.getAllConstraints(type)) {
            String message;
            int severity;
            block16: {
                if (!"invariant".equals(constraint.getStereotype())) continue;
                String constraintName = constraint.getName();
                ValueSpecification specification = constraint.getSpecification();
                if (!(specification instanceof ExpressionInOcl)) continue;
                ExpressionInOcl query = (ExpressionInOcl)specification;
                EvaluationEnvironment evaluationEnvironment = this.environmentFactory.createEvaluationEnvironment();
                ValueFactory valueFactory = typeManager.getValueFactory();
                Value value = valueFactory.valueOf(object);
                evaluationEnvironment.add((VariableDeclaration)query.getContextVariable(), value);
                ModelManager extents = evaluationEnvironment.createModelManager(object);
                EvaluationVisitor evaluationVisitor = this.environmentFactory.createEvaluationVisitor(this.rootEnvironment, evaluationEnvironment, extents);
                severity = 4;
                message = null;
                if (query.getType() != evaluationVisitor.getTypeManager().getBooleanType()) {
                    if (diagnostics == null) {
                        return false;
                    }
                    message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotBoolean_ERROR_, (Object)constraintName);
                } else {
                    block17: {
                        Value expressionResult = (Value)query.accept((Visitor)evaluationVisitor);
                        boolean isOk = false;
                        if (!expressionResult.isNull()) {
                            isOk = expressionResult.asBoolean();
                            severity = 2;
                        }
                        if (isOk) break block16;
                        if (diagnostics != null) break block17;
                        return false;
                    }
                    try {
                        String objectLabel = this.getLabel(eClassifier, object, context);
                        OclExpression messageExpression = query.getMessageExpression();
                        if (messageExpression != null) {
                            try {
                                Value messageResult = (Value)messageExpression.accept((Visitor)evaluationVisitor);
                                if (!messageResult.isNull()) {
                                    message = messageResult.asString();
                                }
                            }
                            catch (InvalidValueException e) {
                                message = NLS.bind((String)OCLMessages.ValidationMessageIsNotString_ERROR_, (Object)constraintName);
                                severity = 4;
                            }
                            catch (Exception e) {
                                message = NLS.bind((String)OCLMessages.ValidationMessageException_ERROR_, (Object[])new Object[]{constraintName, objectLabel, e.getMessage()});
                                severity = 4;
                            }
                        }
                        if (message == null) {
                            message = NLS.bind((String)OCLMessages.ValidationConstraintIsNotSatisfied_ERROR_, (Object)constraintName, (Object)objectLabel);
                        }
                    }
                    catch (InvalidValueException e) {
                        message = NLS.bind((String)OCLMessages.ValidationResultIsNotBoolean_ERROR_, (Object)constraintName);
                    }
                    catch (InvalidEvaluationException e) {
                        message = NLS.bind((String)OCLMessages.ValidationResultIsInvalid_ERROR_, (Object)constraintName);
                    }
                }
            }
            if (message == null) continue;
            diagnostics.add((Diagnostic)new BasicDiagnostic(severity, "org.eclipse.emf.ecore", 0, message, new Object[]{object}));
            allOk = false;
            if (severity == 4) break;
        }
        return allOk;
    }
}

