/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.console;

import com.google.inject.Injector;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ocl.examples.pivot.AssociationClassCallExp;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.Environment;
import org.eclipse.ocl.examples.pivot.EnvironmentFactory;
import org.eclipse.ocl.examples.pivot.EvaluationHaltedException;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.InvalidEvaluationException;
import org.eclipse.ocl.examples.pivot.InvalidValueException;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.ParserException;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitor;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationVisitorImpl;
import org.eclipse.ocl.examples.pivot.evaluation.ModelManager;
import org.eclipse.ocl.examples.pivot.evaluation.PivotEvaluationEnvironment;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironment;
import org.eclipse.ocl.examples.pivot.utilities.PivotEnvironmentFactory;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceSetAdapter;
import org.eclipse.ocl.examples.pivot.values.BooleanValue;
import org.eclipse.ocl.examples.pivot.values.IntegerValue;
import org.eclipse.ocl.examples.pivot.values.RealValue;
import org.eclipse.ocl.examples.pivot.values.StringValue;
import org.eclipse.ocl.examples.pivot.values.Value;
import org.eclipse.ocl.examples.pivot.values.ValueFactory;
import org.eclipse.ocl.examples.pivot.values.impl.InvalidValueImpl;
import org.eclipse.ocl.examples.pivot.values.impl.ValueFactoryImpl;
import org.eclipse.ocl.examples.xtext.console.ColorManager;
import org.eclipse.ocl.examples.xtext.console.ModelingLevel;
import org.eclipse.ocl.examples.xtext.console.OCLConsole;
import org.eclipse.ocl.examples.xtext.console.XtextConsolePlugin;
import org.eclipse.ocl.examples.xtext.console.actions.CloseAction;
import org.eclipse.ocl.examples.xtext.console.actions.LoadExpressionAction;
import org.eclipse.ocl.examples.xtext.console.actions.LoadResourceAction;
import org.eclipse.ocl.examples.xtext.console.actions.SaveExpressionAction;
import org.eclipse.ocl.examples.xtext.console.messages.ConsoleMessages;
import org.eclipse.ocl.examples.xtext.console.xtfo.EmbeddedXtextEditor;
import org.eclipse.ocl.examples.xtext.essentialocl.ui.model.BaseDocument;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLCSResource;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.VerifyKeyListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.console.actions.ClearOutputAction;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.progress.IProgressService;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.outline.IOutlineNode;
import org.eclipse.xtext.ui.editor.outline.impl.EObjectNode;
import org.eclipse.xtext.ui.editor.outline.impl.EStructuralFeatureNode;
import org.eclipse.xtext.ui.editor.outline.impl.OutlinePage;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;
import org.osgi.framework.Bundle;

public class OCLConsolePage
extends Page {
    private static int BUNDLE_AVAILABLE = 44;
    private final OCLConsole console;
    private Composite page;
    private ModelingLevel modelingLevel = ModelingLevel.M2;
    private ITextViewer output;
    private ColorManager colorManager;
    private SourceViewer input;
    private EmbeddedXtextEditor editor;
    private String lastOCLExpression;
    private ISelectionService selectionService;
    private ISelectionListener selectionListener;
    private EObject contextObject;
    private EClassifier contextClassifier;
    private final CancelableTypeManager typeManager = new CancelableTypeManager();
    private ModelManager modelManager = null;

    static boolean isAvailable(Bundle bundle) {
        return (bundle.getState() & BUNDLE_AVAILABLE) != 0;
    }

    OCLConsolePage(OCLConsole console) {
        this.console = console;
    }

    private void append(String text, Color color, boolean bold) {
        IDocument doc = this.getDocument();
        try {
            int offset = doc.getLength();
            int length = text.length();
            text = String.valueOf(text) + '\n';
            if (offset > 0) {
                doc.replace(offset, 0, text);
            } else {
                doc.set(text);
            }
            StyleRange style = new StyleRange();
            style.start = offset;
            style.length = length;
            style.foreground = color;
            if (bold) {
                style.fontStyle = 1;
            }
            this.output.getTextWidget().setStyleRange(style);
        }
        catch (BadLocationException e) {
            Status status = new Status(4, XtextConsolePlugin.getPluginId(), 1, ConsoleMessages.Output_Exception, (Throwable)e);
            XtextConsolePlugin.getInstance().getLog().log((IStatus)status);
        }
    }

    public void createControl(Composite parent) {
        this.page = new SashForm(parent, 0x2000200);
        this.output = new TextViewer(this.page, 2818);
        this.output.getTextWidget().setLayoutData((Object)new GridData(1808));
        this.output.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.output.setEditable(false);
        this.output.setDocument((IDocument)new Document());
        this.colorManager = new ColorManager();
        this.createEditor(this.page);
        this.input = this.editor.getViewer();
        this.input.getTextWidget().addKeyListener((KeyListener)new InputKeyListener());
        this.input.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.jface.textfont"));
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, final ISelection selection) {
                OutlinePage outlinePage;
                IXtextDocument xtextDocument;
                Element pivotElement;
                ContentOutline contentOutline;
                IPage currentPage;
                IConsole console;
                if (part instanceof IConsoleView && (console = ((IConsoleView)part).getConsole()) instanceof OCLConsole) {
                    return;
                }
                if (part instanceof ContentOutline && (currentPage = (contentOutline = (ContentOutline)part).getCurrentPage()) instanceof OutlinePage && (pivotElement = (Element)(xtextDocument = (outlinePage = (OutlinePage)currentPage).getXtextDocument()).readOnly((IUnitOfWork)new IUnitOfWork<Element, XtextResource>(){

                    public Element exec(XtextResource state) throws Exception {
                        Element pivotObject;
                        EObjectNode eObjectNode;
                        URI uri;
                        EObject csObject;
                        Object selectedObject;
                        IStructuredSelection structuredSelection;
                        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1 && (selectedObject = structuredSelection.getFirstElement()) instanceof EObjectNode && (csObject = state.getEObject((uri = (eObjectNode = (EObjectNode)selectedObject).getEObjectURI()).fragment())) instanceof Pivotable && (pivotObject = ((Pivotable)csObject).getPivot()) != null) {
                            return pivotObject;
                        }
                        return null;
                    }
                })) != null) {
                    OCLConsolePage.this.selectionChanged((ISelection)new StructuredSelection((Object)pivotElement));
                    return;
                }
                OCLConsolePage.this.selectionChanged(selection);
            }
        };
        this.selectionService = this.getSite().getWorkbenchWindow().getSelectionService();
        this.selectionService.addPostSelectionListener(this.selectionListener);
        ISelection selection = this.getActiveSelection();
        this.selectionChanged(selection);
        ((SashForm)this.page).setWeights(new int[]{2, 1});
        ClearOutputAction clear = new ClearOutputAction(this.output);
        CloseAction close = new CloseAction();
        SaveExpressionAction saveExpression = new SaveExpressionAction(this);
        LoadExpressionAction loadExpression = new LoadExpressionAction(this);
        LoadResourceAction loadResource = new LoadResourceAction(this);
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        menu.add((IAction)loadResource);
        menu.add((IAction)loadExpression);
        menu.add((IAction)saveExpression);
        menu.add((IAction)clear);
        menu.add((IAction)close);
        IToolBarManager toolbar = this.getSite().getActionBars().getToolBarManager();
        toolbar.appendToGroup("outputGroup", (IAction)loadResource);
        toolbar.appendToGroup("outputGroup", (IAction)loadExpression);
        toolbar.appendToGroup("outputGroup", (IAction)saveExpression);
        toolbar.appendToGroup("outputGroup", (IAction)clear);
        toolbar.appendToGroup("outputGroup", (IAction)close);
    }

    private int convertHeightInCharsToPixels(int i) {
        GC gc = new GC((Drawable)Display.getDefault());
        gc.setFont(this.editor.getViewer().getTextWidget().getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        int ret = (fontMetrics.getHeight() + fontMetrics.getAscent() + fontMetrics.getDescent() + fontMetrics.getLeading()) * i;
        gc.dispose();
        return ret;
    }

    private void createEditor(Composite s1) {
        Composite client = s1;
        Injector injector = XtextConsolePlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Composite editorComposite = client;
        this.editor = new EmbeddedXtextEditor(editorComposite, injector, 770);
        TypeManagerResourceSetAdapter.getAdapter((ResourceSet)this.editor.getResourceSet(), (TypeManager)this.typeManager);
        this.editor.getViewer().getTextWidget().addVerifyKeyListener(new VerifyKeyListener(){

            public void verifyKey(VerifyEvent e) {
                if (e.keyCode == 0x1000050 || e.keyCode == 13) {
                    e.doit = false;
                }
            }
        });
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.convertHeightInCharsToPixels(1);
        editorComposite.setLayoutData((Object)data);
    }

    public void dispose() {
        this.colorManager.dispose();
        this.selectionService.removePostSelectionListener(this.selectionListener);
        super.dispose();
    }

    private void error(String message) {
        this.append(message, this.colorManager.getColor(ColorManager.OUTPUT_ERROR), false);
        this.scrollText();
    }

    boolean evaluate(final String expression) {
        if (expression == null || expression.trim().length() <= 0) {
            this.error(ConsoleMessages.Result_NoExpression);
            return false;
        }
        boolean result = true;
        try {
            IDocument doc = this.getDocument();
            Color defaultColor = this.colorManager.getColor(ColorManager.DEFAULT);
            Color resultsColor = this.colorManager.getColor(ColorManager.OUTPUT_RESULTS);
            Color errorColor = this.colorManager.getColor(ColorManager.OUTPUT_ERROR);
            if (doc.getLength() > 0) {
                this.append("", defaultColor, false);
            }
            this.append(ConsoleMessages.Heading_Evaluating, defaultColor, true);
            this.append(expression, defaultColor, false);
            this.append(ConsoleMessages.Heading_Results, defaultColor, true);
            switch (this.modelingLevel) {
                case M2: {
                    BaseDocument editorDocument = this.getEditorDocument();
                    Value value = null;
                    try {
                        value = (Value)editorDocument.readOnly((IUnitOfWork)new IUnitOfWork<Value, XtextResource>(){

                            public Value exec(XtextResource state) throws Exception {
                                IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                                EvaluationRunnable runnable = new EvaluationRunnable(state, expression);
                                progressService.busyCursorWhile((IRunnableWithProgress)runnable);
                                return runnable.getValue();
                            }
                        });
                    }
                    catch (Exception e) {
                        this.append(e.getMessage(), errorColor, false);
                    }
                    if (value instanceof ExceptionValue) {
                        this.append(((ExceptionValue)value).getMessage(), errorColor, true);
                        this.append(String.valueOf(value), errorColor, false);
                    } else if (value != null && value.isCollectionValue() != null) {
                        for (Value elementValue : value.isCollectionValue()) {
                            this.append(String.valueOf(elementValue), resultsColor, false);
                        }
                    } else if (value != null) {
                        this.append(String.valueOf(value), resultsColor, false);
                    } else {
                        this.append(String.valueOf(value), errorColor, false);
                    }
                    this.scrollText();
                    break;
                }
                case M1: {
                    this.append(ConsoleMessages.Result_Parsed, resultsColor, false);
                    this.scrollText();
                }
            }
            this.lastOCLExpression = expression;
        }
        catch (Exception e) {
            result = false;
            this.error(e.getLocalizedMessage() == null ? e.getClass().getName() : e.getLocalizedMessage());
        }
        return result;
    }

    protected ISelection getActiveSelection() {
        ISelectionProvider selectionProvider;
        block13: {
            IEditorSite editorSite;
            block12: {
                IEditorPart activeEditor;
                block11: {
                    IWorkbenchPage activePage;
                    block10: {
                        IWorkbenchWindow workbenchWindow;
                        block9: {
                            IPageSite site;
                            block8: {
                                try {
                                    site = this.getSite();
                                    if (site != null) break block8;
                                    return null;
                                }
                                catch (Exception e) {
                                    return null;
                                }
                            }
                            workbenchWindow = site.getWorkbenchWindow();
                            if (workbenchWindow != null) break block9;
                            return null;
                        }
                        activePage = workbenchWindow.getActivePage();
                        if (activePage != null) break block10;
                        return null;
                    }
                    activeEditor = activePage.getActiveEditor();
                    if (activeEditor != null) break block11;
                    return null;
                }
                editorSite = activeEditor.getEditorSite();
                if (editorSite != null) break block12;
                return null;
            }
            selectionProvider = editorSite.getSelectionProvider();
            if (selectionProvider != null) break block13;
            return null;
        }
        return selectionProvider.getSelection();
    }

    public Control getControl() {
        return this.page;
    }

    private IDocument getDocument() {
        return this.output.getDocument();
    }

    public IXtextDocument getDocument(URI trimFragment) {
        return this.getEditorDocument();
    }

    public BaseDocument getEditorDocument() {
        return (BaseDocument)this.editor.getDocument();
    }

    public String getLastOCLExpression() {
        return this.lastOCLExpression;
    }

    protected void refreshSelection(final Object selected) {
        final BaseDocument editorDocument = this.getEditorDocument();
        editorDocument.modify((IUnitOfWork)new IUnitOfWork<Object, XtextResource>(){

            public Value exec(XtextResource resource) throws Exception {
                Object selectedObject = selected;
                if (selectedObject instanceof IOutlineNode) {
                    if (selectedObject instanceof EObjectNode) {
                        EObjectNode selectedObjectNode = (EObjectNode)selectedObject;
                        URI eObjectURI = selectedObjectNode.getEObjectURI();
                        OCLConsolePage.this.contextObject = (EObject)OCLConsolePage.this.typeManager.loadResource(eObjectURI, null);
                        OCLConsolePage.this.contextClassifier = (EClassifier)selectedObjectNode.getEClass();
                    } else if (selectedObject instanceof EStructuralFeatureNode) {
                        OCLConsolePage.this.contextObject = null;
                        OCLConsolePage.this.contextClassifier = (EClassifier)((EStructuralFeatureNode)selectedObject).getEStructuralFeature().getEContainingClass();
                    } else {
                        OCLConsolePage.this.contextObject = null;
                        OCLConsolePage.this.contextClassifier = null;
                    }
                } else {
                    if (selectedObject instanceof IAdaptable) {
                        selectedObject = ((IAdaptable)selectedObject).getAdapter(EObject.class);
                    }
                    if (selectedObject instanceof EObject) {
                        OCLConsolePage.this.contextObject = (EObject)selectedObject;
                        OCLConsolePage.this.contextClassifier = (EClassifier)OCLConsolePage.this.contextObject.eClass();
                    } else {
                        OCLConsolePage.this.contextObject = null;
                        OCLConsolePage.this.contextClassifier = null;
                    }
                }
                editorDocument.setContext((EssentialOCLCSResource)resource, OCLConsolePage.this.contextClassifier, null);
                OCLConsolePage.this.console.setSelection(OCLConsolePage.this.contextClassifier, OCLConsolePage.this.contextObject);
                return null;
            }
        });
    }

    private void scrollText() {
        this.output.revealRange(this.getDocument().getLength(), 0);
    }

    private void selectionChanged(ISelection sel) {
        IStructuredSelection ssel;
        Object selectedObject = null;
        if (sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty()) {
            selectedObject = ssel.getFirstElement();
        }
        this.refreshSelection(selectedObject);
    }

    public void setFocus() {
        this.input.getTextWidget().setFocus();
    }

    protected static class CancelableEvaluationVisitor
    extends EvaluationVisitorImpl {
        private final IProgressMonitor monitor;

        protected CancelableEvaluationVisitor(IProgressMonitor monitor, Environment env, EvaluationEnvironment evalEnv, ModelManager modelManager) {
            super(env, evalEnv, modelManager);
            this.monitor = monitor;
        }

        protected void checkMonitor() {
            if (this.monitor.isCanceled()) {
                throw new EvaluationHaltedException("Manual termination");
            }
        }

        public EvaluationVisitor createNestedVisitor() {
            EnvironmentFactory factory = this.environment.getFactory();
            EvaluationEnvironment nestedEvalEnv = factory.createEvaluationEnvironment(this.evaluationEnvironment);
            return new CancelableEvaluationVisitor(this.monitor, this.environment, nestedEvalEnv, this.modelManager);
        }

        public Value visitAssociationClassCallExp(AssociationClassCallExp ae) {
            this.checkMonitor();
            return super.visitAssociationClassCallExp(ae);
        }

        public Value visitCollectionItem(CollectionItem item) {
            this.checkMonitor();
            return super.visitCollectionItem(item);
        }

        public Value visitIterateExp(IterateExp iterateExp) {
            this.checkMonitor();
            return super.visitIterateExp(iterateExp);
        }

        public Value visitIteratorExp(IteratorExp iteratorExp) {
            this.checkMonitor();
            return super.visitIteratorExp(iteratorExp);
        }

        public Value visitOperationCallExp(OperationCallExp operationCallExp) {
            this.checkMonitor();
            return super.visitOperationCallExp(operationCallExp);
        }

        public Value visitPropertyCallExp(PropertyCallExp propertyCallExp) {
            this.checkMonitor();
            return super.visitPropertyCallExp(propertyCallExp);
        }

        public Value visitTupleLiteralPart(TupleLiteralPart tp) {
            this.checkMonitor();
            return super.visitTupleLiteralPart(tp);
        }
    }

    protected static class CancelableTypeManager
    extends TypeManager {
        private IProgressMonitor monitor = null;
        private final ValueFactory valueFactory = new ValueFactoryImpl(ConsoleMessages.ValueFactory_Cancelable){

            public BooleanValue booleanValueOf(boolean value) {
                CancelableTypeManager.this.checkMonitor();
                return super.booleanValueOf(value);
            }

            public IntegerValue integerValueOf(BigInteger value) {
                CancelableTypeManager.this.checkMonitor();
                return super.integerValueOf(value);
            }

            public IntegerValue integerValueOf(long value) {
                CancelableTypeManager.this.checkMonitor();
                return super.integerValueOf(value);
            }

            public IntegerValue integerValueOf(String aValue) throws InvalidValueException {
                CancelableTypeManager.this.checkMonitor();
                return super.integerValueOf(aValue);
            }

            public RealValue realValueOf(double value) {
                CancelableTypeManager.this.checkMonitor();
                return super.realValueOf(value);
            }

            public RealValue realValueOf(BigDecimal value) {
                CancelableTypeManager.this.checkMonitor();
                return super.realValueOf(value);
            }

            public RealValue realValueOf(IntegerValue integerValue) {
                CancelableTypeManager.this.checkMonitor();
                return super.realValueOf(integerValue);
            }

            public RealValue realValueOf(String aValue) throws InvalidValueException {
                CancelableTypeManager.this.checkMonitor();
                return super.realValueOf(aValue);
            }

            public StringValue stringValueOf(String value) {
                CancelableTypeManager.this.checkMonitor();
                return super.stringValueOf(value);
            }
        };

        protected void checkMonitor() {
            if (this.monitor != null && this.monitor.isCanceled()) {
                throw new EvaluationHaltedException(ConsoleMessages.Result_EvaluationTerminated);
            }
        }

        public ValueFactory getValueFactory() {
            return this.valueFactory;
        }

        public void setMonitor(IProgressMonitor monitor) {
            this.monitor = monitor;
        }
    }

    private class EvaluationRunnable
    implements IRunnableWithProgress {
        private final XtextResource resource;
        private final String expression;
        private Value value = null;

        public EvaluationRunnable(XtextResource resource, String expression) {
            this.resource = resource;
            this.expression = expression;
        }

        public Value getValue() {
            return this.value;
        }

        public void run(IProgressMonitor monitor) {
            block9: {
                ExpressionInOcl expressionInOcl;
                monitor.beginTask(NLS.bind((String)ConsoleMessages.Progress_Title, (Object)this.expression), 10);
                monitor.subTask(ConsoleMessages.Progress_Synchronising);
                monitor.worked(1);
                ValueFactory valueFactory = OCLConsolePage.this.typeManager.getValueFactory();
                try {
                    PivotUtil.checkResourceErrors(null, (Resource)this.resource);
                    expressionInOcl = PivotUtil.getExpressionInOcl((Resource)this.resource);
                }
                catch (ParserException e) {
                    this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_ParsingFailure, (Exception)((Object)e));
                    return;
                }
                monitor.subTask(ConsoleMessages.Progress_Extent);
                PivotEnvironmentFactory envFactory = new PivotEnvironmentFactory(null, (TypeManager)OCLConsolePage.this.typeManager);
                PivotEnvironment environment = envFactory.createEnvironment();
                PivotEvaluationEnvironment evaluationEnvironment = envFactory.createEvaluationEnvironment();
                Value contextValue = valueFactory.valueOf((Object)OCLConsolePage.this.contextObject);
                evaluationEnvironment.add((VariableDeclaration)expressionInOcl.getContextVariable(), contextValue);
                OCLConsolePage.this.modelManager = evaluationEnvironment.createModelManager((Object)OCLConsolePage.this.contextObject);
                monitor.worked(2);
                monitor.subTask(ConsoleMessages.Progress_Evaluating);
                try {
                    OCLConsolePage.this.typeManager.setMonitor(monitor);
                    CancelableEvaluationVisitor evaluationVisitor = new CancelableEvaluationVisitor(monitor, (Environment)environment, (EvaluationEnvironment)evaluationEnvironment, OCLConsolePage.this.modelManager);
                    this.value = (Value)evaluationVisitor.visitExpressionInOcl(expressionInOcl);
                }
                catch (EvaluationHaltedException e) {
                    this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_EvaluationTerminated, null);
                    OCLConsolePage.this.typeManager.setMonitor(null);
                    break block9;
                }
                catch (InvalidEvaluationException e) {
                    try {
                        this.value = new ExceptionValue(valueFactory, ConsoleMessages.Result_EvaluationFailure, (Exception)((Object)e));
                        break block9;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                    finally {
                        OCLConsolePage.this.typeManager.setMonitor(null);
                    }
                }
                OCLConsolePage.this.typeManager.setMonitor(null);
            }
            monitor.worked(4);
        }
    }

    protected static class ExceptionValue
    extends InvalidValueImpl {
        private final String message;
        private final Exception exception;

        protected ExceptionValue(ValueFactory valueFactory, String message, Exception exception) {
            super(valueFactory);
            this.message = message;
            this.exception = exception;
        }

        public Exception getException() {
            return this.exception;
        }

        public String getMessage() {
            return this.message;
        }

        public String toString() {
            StringBuffer s = new StringBuffer();
            if (this.exception != null) {
                s.append(this.exception.getMessage());
            }
            return s.toString();
        }
    }

    private class InputKeyListener
    implements KeyListener {
        private boolean evaluationSuccess = false;
        private List<String> history = new ArrayList<String>();
        private int currentHistoryPointer = 0;

        private InputKeyListener() {
        }

        public void keyPressed(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    String text = OCLConsolePage.this.getEditorDocument().get();
                    this.evaluationSuccess = OCLConsolePage.this.evaluate(text.trim());
                    break;
                }
                case 0x1000005: {
                    if ((e.stateMask & 0x60000) != 0) break;
                    if (this.currentHistoryPointer == 0 && this.history.size() > 0) {
                        if (this.history.size() > 0 && this.history.get(0).length() == 0) {
                            this.history.remove(0);
                        }
                        this.history.add(0, OCLConsolePage.this.getEditorDocument().get().trim());
                        this.currentHistoryPointer = 1;
                        this.setTextFromHistory();
                        break;
                    }
                    if (this.currentHistoryPointer >= this.history.size() - 1) break;
                    ++this.currentHistoryPointer;
                    this.setTextFromHistory();
                    break;
                }
                case 0x1000006: {
                    if ((e.stateMask & 0x60000) != 0 || this.currentHistoryPointer <= 0) break;
                    --this.currentHistoryPointer;
                    this.setTextFromHistory();
                }
            }
        }

        public void keyReleased(KeyEvent e) {
            switch (e.keyCode) {
                case 13: {
                    if ((e.stateMask & 0x40000) != 0) break;
                    if (this.evaluationSuccess) {
                        OCLConsolePage.this.getEditorDocument().set("");
                        if (this.history.size() > 0 && this.history.get(0).trim().length() == 0) {
                            this.history.remove(0);
                        }
                        if (this.history.size() == 0 || !this.history.get(0).equals(OCLConsolePage.this.lastOCLExpression.trim())) {
                            this.history.add(0, OCLConsolePage.this.lastOCLExpression.trim());
                        }
                        this.currentHistoryPointer = 0;
                    }
                    this.evaluationSuccess = false;
                }
            }
        }

        protected void setTextFromHistory() {
            String newText = this.history.get(this.currentHistoryPointer);
            OCLConsolePage.this.getEditorDocument().set(newText);
            OCLConsolePage.this.input.setSelectedRange(newText.length(), 0);
        }
    }
}

