/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ocl.examples.pivot.BooleanLiteralExp;
import org.eclipse.ocl.examples.pivot.CallExp;
import org.eclipse.ocl.examples.pivot.Class;
import org.eclipse.ocl.examples.pivot.CollectionItem;
import org.eclipse.ocl.examples.pivot.CollectionLiteralExp;
import org.eclipse.ocl.examples.pivot.CollectionLiteralPart;
import org.eclipse.ocl.examples.pivot.CollectionRange;
import org.eclipse.ocl.examples.pivot.CollectionType;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.EnumLiteralExp;
import org.eclipse.ocl.examples.pivot.EnumerationLiteral;
import org.eclipse.ocl.examples.pivot.ExpressionInOcl;
import org.eclipse.ocl.examples.pivot.Feature;
import org.eclipse.ocl.examples.pivot.IfExp;
import org.eclipse.ocl.examples.pivot.IntegerLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidLiteralExp;
import org.eclipse.ocl.examples.pivot.InvalidType;
import org.eclipse.ocl.examples.pivot.IterateExp;
import org.eclipse.ocl.examples.pivot.Iteration;
import org.eclipse.ocl.examples.pivot.IteratorExp;
import org.eclipse.ocl.examples.pivot.LetExp;
import org.eclipse.ocl.examples.pivot.LoopExp;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.NullLiteralExp;
import org.eclipse.ocl.examples.pivot.OclExpression;
import org.eclipse.ocl.examples.pivot.Operation;
import org.eclipse.ocl.examples.pivot.OperationCallExp;
import org.eclipse.ocl.examples.pivot.Parameter;
import org.eclipse.ocl.examples.pivot.PivotFactory;
import org.eclipse.ocl.examples.pivot.PivotPackage;
import org.eclipse.ocl.examples.pivot.Property;
import org.eclipse.ocl.examples.pivot.PropertyCallExp;
import org.eclipse.ocl.examples.pivot.RealLiteralExp;
import org.eclipse.ocl.examples.pivot.StringLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralExp;
import org.eclipse.ocl.examples.pivot.TupleLiteralPart;
import org.eclipse.ocl.examples.pivot.TupleType;
import org.eclipse.ocl.examples.pivot.Type;
import org.eclipse.ocl.examples.pivot.TypeExp;
import org.eclipse.ocl.examples.pivot.TypedElement;
import org.eclipse.ocl.examples.pivot.TypedMultiplicityElement;
import org.eclipse.ocl.examples.pivot.UnlimitedNaturalLiteralExp;
import org.eclipse.ocl.examples.pivot.Variable;
import org.eclipse.ocl.examples.pivot.VariableDeclaration;
import org.eclipse.ocl.examples.pivot.VariableExp;
import org.eclipse.ocl.examples.pivot.evaluation.CallableImplementation;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationContext;
import org.eclipse.ocl.examples.pivot.messages.OCLMessages;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.ElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedRefCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BaseLeft2RightVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.scope.EnvironmentView;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeCSAdapter;
import org.eclipse.ocl.examples.xtext.base.scope.ScopeView;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BooleanLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.EssentialOCLCSTPackage;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpSpecificationCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.IndexExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InvalidLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.LetVariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NameExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NamedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NestedExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NullLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NumberLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.SelfExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.StringLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TupleLiteralPartCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.TypeLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnlimitedNaturalLiteralExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.BinaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.ImplicitCollectFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.ImplicitCollectionFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.scoping.UnaryOperationFilter;
import org.eclipse.ocl.examples.xtext.essentialocl.util.AbstractExtendingDelegatingEssentialOCLCSVisitor;
import org.eclipse.ocl.examples.xtext.essentialocl.utilities.EssentialOCLUtils;
import org.eclipse.osgi.util.NLS;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLLeft2RightVisitor
extends AbstractExtendingDelegatingEssentialOCLCSVisitor<MonikeredElement, CS2PivotConversion, BaseLeft2RightVisitor> {
    private static final Logger logger = Logger.getLogger(EssentialOCLLeft2RightVisitor.class);
    protected final TypeManager typeManager;

    public EssentialOCLLeft2RightVisitor(CS2PivotConversion context) {
        super(new BaseLeft2RightVisitor(context), context);
        this.typeManager = context.getTypeManager();
    }

    protected OclExpression checkImplementation(NamedExpCS csNavigatingExp, Feature feature, CallExp callExp, OclExpression expression) {
        Diagnostic diagnostic;
        CallableImplementation implementation;
        try {
            implementation = this.typeManager.getImplementation(feature);
        }
        catch (Exception e) {
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNavigatingExp, "Failed to load '" + feature.getImplementationClass() + "': " + e);
        }
        if (implementation != null && (diagnostic = implementation.validate(this.typeManager, callExp)) != null) {
            ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, diagnostic);
        }
        return expression;
    }

    protected Operation getBadOperation() {
        InvalidType invalidType = this.typeManager.getOclInvalidType();
        Operation badOperation = (Operation)PivotUtil.getNamedElement((Iterable)invalidType.getOwnedOperations(), (String)"oclBadOperation");
        return badOperation;
    }

    protected Property getBadProperty() {
        InvalidType invalidType = this.typeManager.getOclInvalidType();
        Property badProperty = (Property)PivotUtil.getNamedElement((Iterable)invalidType.getOwnedAttributes(), (String)"oclBadProperty");
        return badProperty;
    }

    protected VariableDeclaration getImplicitSource(ModelElementCS csExp, Feature feature) {
        EObject eContainer = csExp.eContainer();
        if (eContainer instanceof NavigatingExpCS) {
            EReference eContainmentFeature = csExp.eContainmentFeature();
            if (eContainmentFeature == EssentialOCLCSTPackage.Literals.DECORATED_NAMED_EXP_CS__NAMED_EXP || eContainmentFeature == EssentialOCLCSTPackage.Literals.NAVIGATING_EXP_CS__ARGUMENT) {
                Class namedElementType = PivotUtil.getFeaturingClass((Feature)feature);
                NavigatingExpCS csNavigatingExp = (NavigatingExpCS)eContainer;
                CallExp iteratorExp = (CallExp)PivotUtil.getPivot(CallExp.class, (Pivotable)csNavigatingExp);
                if (iteratorExp instanceof LoopExp) {
                    Type type;
                    Variable iterator2;
                    for (Variable iterator2 : ((LoopExp)iteratorExp).getIterators()) {
                        Type type2 = iterator2.getType();
                        if (!this.typeManager.conformsTo(type2, (Type)namedElementType)) continue;
                        return iterator2;
                    }
                    if (iteratorExp instanceof IterateExp && this.typeManager.conformsTo(type = (iterator2 = ((IterateExp)iteratorExp).getResult()).getType(), (Type)namedElementType)) {
                        return iterator2;
                    }
                }
            }
        } else {
            if (csExp instanceof ContextCS) {
                ContextCS csContext = (ContextCS)csExp;
                ExpressionInOcl pivotElement = (ExpressionInOcl)PivotUtil.getPivot(ExpressionInOcl.class, (Pivotable)csContext);
                return pivotElement.getContextVariable();
            }
            if (csExp instanceof ExpSpecificationCS) {
                ExpressionInOcl pivotElement = (ExpressionInOcl)PivotUtil.getPivot(ExpressionInOcl.class, (Pivotable)csExp);
                return pivotElement.getContextVariable();
            }
        }
        if (eContainer instanceof ContextCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof ExpSpecificationCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof ExpCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        if (eContainer instanceof NavigatingArgCS) {
            return this.getImplicitSource((ModelElementCS)eContainer, feature);
        }
        return null;
    }

    protected Type getSourceElementType(NavigatingExpCS csNavigatingExp, OclExpression source) {
        Type sourceType = source.getType();
        boolean isCollectionNavigation = "->".equals(csNavigatingExp.getParent().getName());
        if (!isCollectionNavigation) {
            return sourceType;
        }
        if (sourceType instanceof CollectionType) {
            return ((CollectionType)sourceType).getElementType();
        }
        return sourceType;
    }

    protected EnumLiteralExp resolveEnumLiteral(ExpCS csExp, EnumerationLiteral enumerationLiteral) {
        EnumLiteralExp expression = (EnumLiteralExp)((CS2PivotConversion)this.context).refreshExpression(EnumLiteralExp.class, PivotPackage.Literals.ENUM_LITERAL_EXP, (MonikeredElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getClassifierType((Type)enumerationLiteral.getEnumeration()));
        expression.setReferredEnumLiteral(enumerationLiteral);
        return expression;
    }

    protected void resolveIterationAccumulators(NavigatingExpCS csNavigatingExp, LoopExp expression) {
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotAccumulators = new ArrayList<Variable>();
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ACCUMULATOR) {
                if (csArgument.getInit() == null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Missing initializer for accumulator");
                }
                ExpCS csName = csArgument.getName();
                Variable acc = (Variable)PivotUtil.getPivot(Variable.class, (Pivotable)csName);
                acc.setRepresentedParameter((Parameter)iteration.getOwnedAccumulators().get(pivotAccumulators.size()));
                pivotAccumulators.add(acc);
            }
            ++argIndex;
        }
        if (expression instanceof IterateExp) {
            IterateExp iterateExp = (IterateExp)expression;
            if (pivotAccumulators.size() > 1) {
                ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, "Iterate calls cannot have more than one accumulator");
            } else {
                iterateExp.setResult((Variable)pivotAccumulators.get(0));
            }
        } else if (pivotAccumulators.size() > 0) {
            ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, "Iteration calls cannot have an accumulator");
        }
    }

    protected void resolveIterationBody(NavigatingExpCS csNavigatingExp, LoopExp expression) {
        ArrayList<OclExpression> pivotBodies = new ArrayList<OclExpression>();
        for (NavigatingArgCS csArgument : csNavigatingExp.getArgument()) {
            if (csArgument.getRole() != NavigationRole.EXPRESSION) continue;
            if (csArgument.getInit() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Unexpected initializer for expression");
            }
            if (csArgument.getOwnedType() != null) {
                ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Unexpected type for expression");
            }
            OclExpression exp = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csArgument.getName());
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csArgument, (Element)exp);
            pivotBodies.add(exp);
        }
        if (pivotBodies.size() != 1) {
            expression.setBody(((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNavigatingExp, "Iteration calls must have exactly one body"));
        } else {
            expression.setBody((OclExpression)pivotBodies.get(0));
        }
    }

    protected LoopExp resolveIterationCall(NavigatingExpCS csNavigatingExp, OclExpression source, Iteration iteration) {
        NamedExpCS csNamedExp = csNavigatingExp.getNamedExp();
        LoopExp expression = iteration.getOwnedAccumulators().size() > 0 ? (LoopExp)((CS2PivotConversion)this.context).refreshExpression(IterateExp.class, PivotPackage.Literals.ITERATE_EXP, (MonikeredElementCS)csNamedExp) : (LoopExp)((CS2PivotConversion)this.context).refreshExpression(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, (MonikeredElementCS)csNamedExp);
        ((CS2PivotConversion)this.context).setReferredIteration(expression, iteration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, iteration.getType());
        ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csNavigatingExp, (Element)expression);
        this.resolveIterationAccumulators(csNavigatingExp, expression);
        this.resolveIterationIterators(csNavigatingExp, source, expression);
        return expression;
    }

    protected void resolveIterationExplicitAccumulators(NavigatingExpCS csNavigatingExp) {
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ACCUMULATOR) {
                ExpCS csName = csArgument.getName();
                ICompositeNode node = NodeModelUtils.getNode((EObject)csName);
                ILeafNode leafNode = ElementUtil.getLeafNode((INode)node);
                String varName = leafNode.getText();
                Variable acc = (Variable)((CS2PivotConversion)this.context).refreshMonikeredElement(Variable.class, PivotPackage.Literals.VARIABLE, (MonikeredElementCS)csName);
                ((NameExpCS)csName).setElement((NamedElement)acc);
                ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csName, (Element)acc);
                ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csArgument, (Element)acc);
                ((CS2PivotConversion)this.context).refreshName((NamedElement)acc, varName);
                OclExpression initExpression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csArgument.getInit());
                acc.setInitExpression(initExpression);
                TypedRefCS csAccType = csArgument.getOwnedType();
                Type accType = csAccType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csAccType) : initExpression.getType();
                ((CS2PivotConversion)this.context).setType((TypedElement)acc, accType);
            }
            ++argIndex;
        }
    }

    protected void resolveIterationIterators(NavigatingExpCS csNavigatingExp, OclExpression source, LoopExp expression) {
        NamedExpCS csNamedExp = csNavigatingExp.getNamedExp();
        Iteration iteration = expression.getReferredIteration();
        ArrayList<Variable> pivotIterators = new ArrayList<Variable>();
        int iterationIteratorsSize = iteration.getOwnedIterators().size();
        int argIndex = 0;
        while (argIndex < csNavigatingExp.getArgument().size()) {
            NavigatingArgCS csArgument = (NavigatingArgCS)csNavigatingExp.getArgument().get(argIndex);
            if (csArgument.getRole() == NavigationRole.ITERATOR) {
                if (iterationIteratorsSize <= argIndex) {
                    ((CS2PivotConversion)this.context).addWarning((ModelElementCS)csArgument, OCLMessages.RedundantIterator_WARNING_, new Object[]{iteration.getName()});
                } else {
                    Type varType;
                    if (csArgument.getInit() != null) {
                        ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Unexpected initializer for iterator");
                    }
                    ExpCS csName = csArgument.getName();
                    ICompositeNode node = NodeModelUtils.getNode((EObject)csName);
                    ILeafNode leafNode = ElementUtil.getLeafNode((INode)node);
                    String varName = leafNode.getText();
                    Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshMonikeredElement(Variable.class, PivotPackage.Literals.VARIABLE, (MonikeredElementCS)csName);
                    ((NameExpCS)csName).setElement((NamedElement)iterator);
                    ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csName, (Element)iterator);
                    ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csArgument, (Element)iterator);
                    ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, varName);
                    iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterators().get(pivotIterators.size()));
                    TypedRefCS csType = csArgument.getOwnedType();
                    Type type = varType = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : null;
                    if (varType == null) {
                        varType = this.getSourceElementType(csNavigatingExp, source);
                    }
                    ((CS2PivotConversion)this.context).setType((TypedElement)iterator, varType);
                    pivotIterators.add(iterator);
                }
            }
            ++argIndex;
        }
        while (pivotIterators.size() < iterationIteratorsSize) {
            String varName = String.valueOf(Integer.toString(pivotIterators.size() + 1)) + "_";
            String moniker = String.valueOf(csNamedExp.getMoniker()) + "!" + PivotPackage.Literals.LOOP_EXP__ITERATOR.getName() + "~" + varName;
            Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshMonikeredElement(Variable.class, PivotPackage.Literals.VARIABLE, moniker);
            ((CS2PivotConversion)this.context).usePivotElement((ModelElementCS)csNavigatingExp, (Element)iterator);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, varName);
            Type varType = this.getSourceElementType(csNavigatingExp, source);
            ((CS2PivotConversion)this.context).setType((TypedElement)iterator, varType);
            iterator.setImplicit(true);
            iterator.setRepresentedParameter((Parameter)iteration.getOwnedIterators().get(pivotIterators.size()));
            pivotIterators.add(iterator);
        }
        ((CS2PivotConversion)this.context).refreshList((List)expression.getIterators(), pivotIterators);
    }

    protected OclExpression resolveNavigationFeature(NamedExpCS csElement, OclExpression source, Feature feature, CallExp callExp) {
        CallExp navigationExp = callExp;
        Type actualSourceType = source.getType();
        Class requiredSourceType = PivotUtil.getFeaturingClass((Feature)feature);
        boolean isDotNavigation = false;
        if (csElement.getParent() instanceof NavigationOperatorCS) {
            isDotNavigation = ".".equals(((NavigationOperatorCS)csElement.getParent()).getName());
        }
        if (isDotNavigation && !(requiredSourceType instanceof CollectionType) && actualSourceType instanceof CollectionType) {
            Type elementType = ((CollectionType)actualSourceType).getElementType();
            String csMoniker = csElement.getMoniker();
            int lastIndex = csMoniker.lastIndexOf("~");
            String baseMoniker = csMoniker.substring(0, lastIndex + 1);
            String moniker = String.valueOf(baseMoniker) + "collect";
            IteratorExp iteratorExp = (IteratorExp)((CS2PivotConversion)this.context).refreshMonikeredElement(IteratorExp.class, PivotPackage.Literals.ITERATOR_EXP, moniker);
            iteratorExp.setImplicit(true);
            EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)PivotPackage.Literals.LOOP_EXP__REFERRED_ITERATION, "collect");
            environmentView.addFilter((EnvironmentView.Filter)new ImplicitCollectFilter(this.typeManager, (CollectionType)actualSourceType, elementType));
            environmentView.computeLookups(actualSourceType);
            Iteration resolvedIteration = (Iteration)environmentView.getResolvedContent();
            ((CS2PivotConversion)this.context).setReferredIteration((LoopExp)iteratorExp, resolvedIteration);
            Variable iterator = (Variable)((CS2PivotConversion)this.context).refreshMonikeredElement(Variable.class, PivotPackage.Literals.VARIABLE, String.valueOf(baseMoniker) + "1_");
            Parameter resolvedIterator = (Parameter)resolvedIteration.getOwnedIterators().get(0);
            iterator.setRepresentedParameter(resolvedIterator);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)iterator, "1_");
            ((CS2PivotConversion)this.context).setType((TypedElement)iterator, resolvedIterator.getType());
            iterator.setImplicit(true);
            iteratorExp.getIterators().add((Object)iterator);
            String iteratorRefMoniker = String.valueOf(csMoniker) + "!" + "source" + "~" + "1_";
            VariableExp variableExp = (VariableExp)((CS2PivotConversion)this.context).refreshMonikeredElement(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, iteratorRefMoniker);
            variableExp.setReferredVariable((VariableDeclaration)iterator);
            variableExp.setImplicit(true);
            ((CS2PivotConversion)this.context).setType((TypedElement)variableExp, resolvedIterator.getType());
            callExp.setSource((OclExpression)variableExp);
            iteratorExp.setBody((OclExpression)callExp);
            ((CS2PivotConversion)this.context).setType((TypedElement)iteratorExp, resolvedIteration.getType());
            navigationExp = iteratorExp;
        }
        navigationExp.setSource(source);
        return navigationExp;
    }

    protected OclExpression resolveNavigationSource(NamedExpCS csNameExp, Feature feature) {
        ExpCS csSource;
        boolean isCollectionNavigation = false;
        OperatorCS csOperator = csNameExp.getParent();
        OclExpression source = null;
        if (csOperator instanceof NavigationOperatorCS && (csSource = csOperator.getSource()) != csNameExp) {
            source = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csSource);
            isCollectionNavigation = csOperator.getName().equals("->");
        }
        if (source == null) {
            MonikeredElementCS csPivoted = EssentialOCLUtils.getPivotedCS((EObject)(csOperator != null ? csOperator : csNameExp));
            ElementCS csChild = EssentialOCLUtils.getPivotingChildCS((ElementCS)csPivoted);
            MonikeredElementCS csParent = EssentialOCLUtils.getPivotingParentCS(csChild);
            MonikeredElementCS csPivotedParent = EssentialOCLUtils.getPivotedCS((EObject)csParent);
            VariableDeclaration implicitSource = this.getImplicitSource((ModelElementCS)csPivotedParent, feature);
            VariableExp sourceAccess = PivotFactory.eINSTANCE.createVariableExp();
            sourceAccess.setReferredVariable(implicitSource);
            ((CS2PivotConversion)this.context).setType((TypedElement)sourceAccess, implicitSource.getType());
            sourceAccess.setImplicit(true);
            source = sourceAccess;
        }
        Type actualSourceType = source.getType();
        if (isCollectionNavigation && !(actualSourceType instanceof CollectionType)) {
            OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshMonikeredElement(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (MonikeredElementCS)csOperator);
            expression.setImplicit(true);
            expression.setSource(source);
            expression.setName("oclAsSet");
            this.resolveOperationCall(expression, csOperator, new ImplicitCollectionFilter(this.typeManager, actualSourceType));
            source = expression;
        }
        return source;
    }

    protected OclExpression resolveOperation(NavigatingExpCS csNavigatingExp) {
        NamedExpCS csNamedExp = csNavigatingExp.getNamedExp();
        this.resolveOperationArgumentTypes(csNavigatingExp);
        this.resolveIterationExplicitAccumulators(csNavigatingExp);
        NamedElement namedElement = csNamedExp.getNamedElement();
        if (namedElement.eIsProxy()) {
            namedElement = this.getBadOperation();
        }
        if (namedElement == null || namedElement.eIsProxy()) {
            OperationCallExp operationCallExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshExpression(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (MonikeredElementCS)csNamedExp);
            ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, null);
            ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csNavigatingExp, (Element)operationCallExp);
            ((CS2PivotConversion)this.context).setType((TypedElement)operationCallExp, (Type)this.typeManager.getOclInvalidType());
            return operationCallExp;
        }
        if (namedElement instanceof Operation) {
            OclExpression expression;
            LoopExp callExp;
            Operation operation = (Operation)namedElement;
            OclExpression source = this.resolveNavigationSource(csNavigatingExp, (Feature)operation);
            if (operation instanceof Iteration) {
                Iteration iteration = (Iteration)operation;
                callExp = this.resolveIterationCall(csNavigatingExp, source, iteration);
                expression = this.resolveNavigationFeature(csNavigatingExp, source, (Feature)operation, (CallExp)callExp);
                this.resolveIterationBody(csNavigatingExp, callExp);
                ((CS2PivotConversion)this.context).resolveIterationSpecialization(callExp);
                if (expression != callExp && expression instanceof LoopExp) {
                    ((CS2PivotConversion)this.context).resolveIterationSpecialization((LoopExp)expression);
                }
            } else {
                OperationCallExp operationCallExp = (OperationCallExp)((CS2PivotConversion)this.context).refreshExpression(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (MonikeredElementCS)csNamedExp);
                ((CS2PivotConversion)this.context).setReferredOperation(operationCallExp, operation);
                ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csNavigatingExp, (Element)operationCallExp);
                callExp = operationCallExp;
                expression = this.resolveNavigationFeature(csNavigatingExp, source, (Feature)operation, (CallExp)callExp);
                this.resolveOperationArguments(csNavigatingExp, source, operation, operationCallExp);
                ((CS2PivotConversion)this.context).setTypeWithMultiplicity((TypedElement)operationCallExp, (TypedMultiplicityElement)operation);
                if (expression instanceof LoopExp) {
                    ((CS2PivotConversion)this.context).resolveIterationSpecialization((LoopExp)expression);
                }
            }
            return this.checkImplementation(csNavigatingExp, (Feature)operation, (CallExp)callExp, expression);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNamedExp, "Operation name expected");
    }

    protected void resolveOperationArgumentTypes(NavigatingExpCS csNavigatingExp) {
        for (NavigatingArgCS csArgument : csNavigatingExp.getArgument()) {
            OclExpression arg;
            if (csArgument.getRole() == NavigationRole.ITERATOR || csArgument.getRole() == NavigationRole.ACCUMULATOR) break;
            if (csArgument.getRole() != NavigationRole.EXPRESSION || (arg = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csArgument.getName())) == null) continue;
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csArgument, (Element)arg);
        }
    }

    protected void resolveOperationArguments(NavigatingExpCS csNavigatingExp, OclExpression source, Operation operation, OperationCallExp expression) {
        ArrayList<OclExpression> pivotArguments = new ArrayList<OclExpression>();
        EList<NavigatingArgCS> csArguments = csNavigatingExp.getArgument();
        EList ownedParameters = operation.getOwnedParameters();
        int parametersCount = ownedParameters.size();
        int csArgumentCount = csArguments.size();
        if (csArgumentCount > 0) {
            if (((NavigatingArgCS)csArguments.get(0)).getRole() != NavigationRole.EXPRESSION) {
                ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, "Operation calls can only specify expressions");
            }
            int argIndex = 0;
            while (argIndex < csArgumentCount) {
                OclExpression arg;
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(argIndex);
                if (csArgument.getInit() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Unexpected initializer for expression");
                }
                if (csArgument.getOwnedType() != null) {
                    ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csArgument, "Unexpected type for expression");
                }
                if ((arg = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csArgument)) != null) {
                    pivotArguments.add(arg);
                }
                ++argIndex;
            }
        }
        if (csArgumentCount != parametersCount && operation != this.getBadOperation()) {
            String boundMessage = NLS.bind((String)OCLMessages.MismatchedArgumentCount_ERROR_, (Object)csArgumentCount, (Object)parametersCount);
            ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csNavigatingExp, boundMessage);
        }
        ((CS2PivotConversion)this.context).refreshList((List)expression.getArguments(), pivotArguments);
    }

    protected void resolveOperationCall(OperationCallExp expression, OperatorCS csOperator, EnvironmentView.Filter filter) {
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)PivotPackage.Literals.OPERATION_CALL_EXP__REFERRED_OPERATION, expression.getName());
        environmentView.addFilter(filter);
        Type sourceType = expression.getSource().getType();
        int size = 0;
        if (sourceType != null) {
            size = environmentView.computeLookups(sourceType);
        }
        if (size == 1) {
            Operation operation = (Operation)environmentView.getResolvedContent();
            ((CS2PivotConversion)this.context).setReferredOperation(expression, operation);
            ((CS2PivotConversion)this.context).setTypeWithMultiplicity((TypedElement)expression, (TypedMultiplicityElement)operation);
        } else {
            StringBuffer s = new StringBuffer();
            for (OclExpression argument : expression.getArguments()) {
                Type argumentType = argument.getType();
                if (s.length() > 0) {
                    s.append(",");
                }
                if (argumentType == null) continue;
                s.append(argumentType.toString());
            }
            String boundMessage = s.length() > 0 ? NLS.bind((String)OCLMessages.UnresolvedOperationCall_ERROR_, (Object[])new Object[]{csOperator, sourceType, s.toString()}) : NLS.bind((String)OCLMessages.UnresolvedOperation_ERROR_, (Object[])new Object[]{csOperator, sourceType});
            ((CS2PivotConversion)this.context).addDiagnostic((ModelElementCS)csOperator, boundMessage);
            Operation badOperation = this.getBadOperation();
            ((CS2PivotConversion)this.context).setReferredOperation(expression, badOperation);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getOclInvalidType());
        }
    }

    protected OclExpression resolvePropertyCallExp(NamedExpCS csNameExp, Property property) {
        OclExpression source = this.resolveNavigationSource(csNameExp, (Feature)property);
        PropertyCallExp expression = (PropertyCallExp)((CS2PivotConversion)this.context).refreshExpression(PropertyCallExp.class, PivotPackage.Literals.PROPERTY_CALL_EXP, (MonikeredElementCS)csNameExp);
        expression.setReferredProperty(property);
        ((CS2PivotConversion)this.context).setTypeWithMultiplicity((TypedElement)expression, (TypedMultiplicityElement)property);
        OclExpression navigationExpression = this.resolveNavigationFeature(csNameExp, source, (Feature)property, (CallExp)expression);
        if (navigationExpression instanceof LoopExp) {
            ((CS2PivotConversion)this.context).resolveIterationSpecialization((LoopExp)navigationExpression);
        }
        return navigationExpression;
    }

    protected OclExpression resolvePropertyNavigation(NamedExpCS csNamedExp) {
        NamedElement namedElement = csNamedExp.getNamedElement();
        if (namedElement.eIsProxy()) {
            namedElement = this.getBadProperty();
        }
        if (namedElement == null || namedElement.eIsProxy()) {
            PropertyCallExp expression = (PropertyCallExp)((CS2PivotConversion)this.context).refreshExpression(PropertyCallExp.class, PivotPackage.Literals.PROPERTY_CALL_EXP, (MonikeredElementCS)csNamedExp);
            expression.setReferredProperty(null);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getOclInvalidType());
            return expression;
        }
        if (namedElement instanceof Property) {
            return this.resolvePropertyCallExp(csNamedExp, (Property)namedElement);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNamedExp, "Property name expected");
    }

    protected TypeExp resolveTypeExp(ExpCS csExp, Type type) {
        TypeExp expression = (TypeExp)((CS2PivotConversion)this.context).refreshExpression(TypeExp.class, PivotPackage.Literals.TYPE_EXP, (MonikeredElementCS)csExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getClassifierType(type));
        expression.setReferredType(type);
        return expression;
    }

    protected VariableExp resolveVariableExp(NameExpCS csNameExp, VariableDeclaration variableDeclaration) {
        VariableExp expression = (VariableExp)((CS2PivotConversion)this.context).refreshExpression(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (MonikeredElementCS)csNameExp);
        expression.setReferredVariable(variableDeclaration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, variableDeclaration.getType());
        return expression;
    }

    @Override
    public MonikeredElement visitBinaryOperatorCS(BinaryOperatorCS csOperator) {
        OclExpression source = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csOperator.getSource());
        OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshExpression(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (MonikeredElementCS)csOperator);
        ((CS2PivotConversion)this.context).refreshName((NamedElement)expression, csOperator.getName());
        expression.setSource(source);
        OclExpression argument = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csOperator.getArgument());
        ((CS2PivotConversion)this.context).refreshList((List)expression.getArguments(), Collections.singletonList(argument));
        this.resolveOperationCall(expression, csOperator, new BinaryOperationFilter(this.typeManager, source.getType(), argument.getType()));
        return expression;
    }

    @Override
    public MonikeredElement visitBooleanLiteralExpCS(BooleanLiteralExpCS csBooleanLiteralExp) {
        BooleanLiteralExp expression = (BooleanLiteralExp)((CS2PivotConversion)this.context).refreshExpression(BooleanLiteralExp.class, PivotPackage.Literals.BOOLEAN_LITERAL_EXP, (MonikeredElementCS)csBooleanLiteralExp);
        expression.setBooleanSymbol(Boolean.valueOf(csBooleanLiteralExp.getName()).booleanValue());
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getBooleanType());
        return expression;
    }

    @Override
    public MonikeredElement visitCollectionLiteralExpCS(CollectionLiteralExpCS csCollectionLiteralExp) {
        Type commonType = null;
        for (CollectionLiteralPartCS csPart : csCollectionLiteralExp.getOwnedParts()) {
            CollectionLiteralPart pivotPart = (CollectionLiteralPart)((CS2PivotConversion)this.context).visitLeft2Right(CollectionLiteralPart.class, (VisitableCS)csPart);
            Type type = pivotPart.getType();
            commonType = commonType == null ? type : this.typeManager.getCommonType(commonType, type);
        }
        CollectionLiteralExp expression = (CollectionLiteralExp)((CS2PivotConversion)this.context).refreshExpression(CollectionLiteralExp.class, PivotPackage.Literals.COLLECTION_LITERAL_EXP, (MonikeredElementCS)csCollectionLiteralExp);
        ((CS2PivotConversion)this.context).refreshPivotList(CollectionLiteralPart.class, (List)expression.getParts(), csCollectionLiteralExp.getOwnedParts());
        CollectionTypeCS ownedCollectionType = csCollectionLiteralExp.getOwnedType();
        String collectionTypeName = ownedCollectionType.getName();
        TypedRefCS ownedElementType = ownedCollectionType.getOwnedType();
        if (ownedElementType != null) {
            commonType = (Type)ownedElementType.getPivot();
        }
        if (commonType == null) {
            commonType = this.typeManager.createUnspecifiedType();
        }
        Type type = this.typeManager.getLibraryType(collectionTypeName, Collections.singletonList(commonType));
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, type);
        expression.setKind(PivotUtil.getCollectionKind((CollectionType)((CollectionType)type)));
        return expression;
    }

    @Override
    public MonikeredElement visitCollectionLiteralPartCS(CollectionLiteralPartCS csCollectionLiteralPart) {
        OclExpression pivotLast;
        CollectionItem expression;
        ExpCS csFirst = csCollectionLiteralPart.getExpressionCS();
        OclExpression pivotFirst = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csFirst);
        ExpCS csLast = csCollectionLiteralPart.getLastExpressionCS();
        if (csLast == null) {
            expression = (CollectionItem)((CS2PivotConversion)this.context).refreshMonikeredElement(CollectionItem.class, PivotPackage.Literals.COLLECTION_ITEM, (MonikeredElementCS)csCollectionLiteralPart);
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csCollectionLiteralPart, (Element)expression);
            expression.setItem(pivotFirst);
        } else {
            expression = (CollectionRange)((CS2PivotConversion)this.context).refreshMonikeredElement(CollectionRange.class, PivotPackage.Literals.COLLECTION_RANGE, (MonikeredElementCS)csCollectionLiteralPart);
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csCollectionLiteralPart, (Element)expression);
            expression.setFirst(pivotFirst);
            pivotLast = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csLast);
            expression.setLast(pivotLast);
        }
        Type type = pivotFirst.getType();
        if (csLast != null) {
            pivotLast = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csLast);
            Type secondType = pivotLast.getType();
            type = this.typeManager.getCommonType(type, secondType);
        }
        CollectionLiteralPart expression2 = (CollectionLiteralPart)PivotUtil.getPivot(CollectionLiteralPart.class, (Pivotable)csCollectionLiteralPart);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression2, type);
        return expression2;
    }

    @Override
    public MonikeredElement visitCollectionTypeCS(CollectionTypeCS object) {
        return null;
    }

    @Override
    public MonikeredElement visitContextCS(ContextCS csContext) {
        ExpressionInOcl pivotElement;
        NamedElement specificationContext = null;
        Resource resource = csContext.eResource();
        if (resource instanceof EvaluationContext) {
            specificationContext = ((EvaluationContext)resource).getSpecificationContext();
        }
        if (specificationContext instanceof ExpressionInOcl) {
            pivotElement = (ExpressionInOcl)specificationContext;
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csContext, (Element)pivotElement);
            ExpCS csExpression = csContext.getOwnedExpression();
            OclExpression expression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csExpression);
            if (expression != null) {
                if (pivotElement.getBodyExpression() == null) {
                    pivotElement.setBodyExpression(expression);
                    ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, expression.getType());
                } else {
                    pivotElement.setMessageExpression(expression);
                }
            }
        } else {
            Type contextType;
            pivotElement = (ExpressionInOcl)((CS2PivotConversion)this.context).refreshMonikeredElement(ExpressionInOcl.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (MonikeredElementCS)csContext);
            Variable contextVariable = pivotElement.getContextVariable();
            if (contextVariable == null) {
                contextVariable = PivotFactory.eINSTANCE.createVariable();
            }
            if (specificationContext instanceof Type) {
                contextType = (Type)specificationContext;
            } else if (specificationContext instanceof Feature) {
                contextType = PivotUtil.getFeaturingClass((Feature)((Feature)specificationContext));
                if (specificationContext instanceof Operation) {
                    ((CS2PivotConversion)this.context).setType((TypedElement)contextVariable, contextType);
                    for (Parameter parameter : ((Operation)specificationContext).getOwnedParameters()) {
                        Variable param = PivotFactory.eINSTANCE.createVariable();
                        param.setName(parameter.getName());
                        ((CS2PivotConversion)this.context).setTypeWithMultiplicity((TypedElement)param, (TypedMultiplicityElement)parameter);
                        param.setRepresentedParameter(parameter);
                        pivotElement.getParameterVariables().add((Object)param);
                    }
                }
            } else {
                contextType = this.typeManager.getOclInvalidType();
            }
            ((CS2PivotConversion)this.context).setType((TypedElement)contextVariable, contextType);
            ((CS2PivotConversion)this.context).refreshName((NamedElement)contextVariable, "self");
            pivotElement.setContextVariable(contextVariable);
            ((CS2PivotConversion)this.context).putPivotElement((MonikeredElement)contextVariable);
            ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csContext, (Element)pivotElement);
            ExpCS csExpression = csContext.getOwnedExpression();
            OclExpression expression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csExpression);
            if (expression != null) {
                pivotElement.setBodyExpression(expression);
                ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, expression.getType());
            }
        }
        return pivotElement;
    }

    @Override
    public MonikeredElement visitExpCS(ExpCS object) {
        return null;
    }

    @Override
    public MonikeredElement visitExpSpecificationCS(ExpSpecificationCS object) {
        ExpressionInOcl pivotElement = (ExpressionInOcl)((CS2PivotConversion)this.context).refreshMonikeredElement(ExpressionInOcl.class, PivotPackage.Literals.EXPRESSION_IN_OCL, (MonikeredElementCS)object);
        pivotElement.getLanguages().add((Object)"OCL");
        pivotElement.getBodies().add((Object)object.getExprString());
        pivotElement.getMessages().add(null);
        OclExpression expression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)object.getOwnedExpression());
        pivotElement.setBodyExpression(expression);
        return pivotElement;
    }

    @Override
    public MonikeredElement visitIfExpCS(IfExpCS csIfExp) {
        IfExp expression = (IfExp)((CS2PivotConversion)this.context).refreshExpression(IfExp.class, PivotPackage.Literals.IF_EXP, (MonikeredElementCS)csIfExp);
        expression.setCondition((OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csIfExp.getCondition()));
        OclExpression thenExpression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csIfExp.getThenExpression());
        expression.setThenExpression(thenExpression);
        OclExpression elseExpression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csIfExp.getElseExpression());
        expression.setElseExpression(elseExpression);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, this.typeManager.getCommonType(thenExpression.getType(), elseExpression.getType()));
        return expression;
    }

    @Override
    public MonikeredElement visitIndexExpCS(IndexExpCS csIndexExp) {
        return null;
    }

    @Override
    public MonikeredElement visitInfixExpCS(InfixExpCS csInfixExp) {
        OperatorCS csRoot = (OperatorCS)csInfixExp.getOwnedOperator().get(0);
        OperatorCS csParent = csRoot.getParent();
        while (csParent != null) {
            csRoot = csParent;
            csParent = csParent.getParent();
        }
        OclExpression pivot = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csRoot);
        ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csInfixExp, (Element)pivot);
        return pivot;
    }

    @Override
    public MonikeredElement visitInvalidLiteralExpCS(InvalidLiteralExpCS csInvalidLiteralExp) {
        InvalidLiteralExp expression = (InvalidLiteralExp)PivotUtil.getPivot(InvalidLiteralExp.class, (Pivotable)csInvalidLiteralExp);
        if (expression == null) {
            expression = this.typeManager.createInvalidExpression();
        }
        ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csInvalidLiteralExp, (Element)expression);
        return expression;
    }

    @Override
    public MonikeredElement visitLetExpCS(LetExpCS csLetExp) {
        LetExp letExp;
        String letMoniker = csLetExp.getMoniker();
        LetExp firstLetExp = null;
        LetExp lastLetExp = null;
        for (LetVariableCS csLetVariable : csLetExp.getVariable()) {
            Type variableType;
            letExp = (LetExp)((CS2PivotConversion)this.context).refreshMonikeredElement(LetExp.class, PivotPackage.Literals.LET_EXP, letMoniker);
            Variable variable = (Variable)((CS2PivotConversion)this.context).refreshNamedElement(Variable.class, PivotPackage.Literals.VARIABLE, (NamedElementCS)csLetVariable);
            letExp.setVariable(variable);
            ExpCS csInitExpression = csLetVariable.getInitExpression();
            OclExpression initExpression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csInitExpression);
            variable.setInitExpression(initExpression);
            Type initType = initExpression != null ? initExpression.getType() : null;
            TypedRefCS csVariableType = csLetVariable.getOwnedType();
            Type type = variableType = csVariableType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csVariableType) : null;
            if (variableType == null) {
                variableType = initType;
            }
            ((CS2PivotConversion)this.context).setType((TypedElement)variable, variableType);
            if (lastLetExp != null) {
                lastLetExp.setIn((OclExpression)letExp);
                ((CS2PivotConversion)this.context).usePivotElement((ModelElementCS)csLetExp, (Element)letExp);
            } else {
                firstLetExp = letExp;
                ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csLetExp, (Element)firstLetExp);
            }
            lastLetExp = letExp;
            letMoniker = String.valueOf(letMoniker) + "!" + "in" + "~" + "let";
        }
        if (lastLetExp != null) {
            OclExpression in = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csLetExp.getIn());
            lastLetExp.setIn(in);
            Type type = in.getType();
            letExp = firstLetExp;
            while (letExp != in && letExp != null) {
                ((CS2PivotConversion)this.context).setType((TypedElement)letExp, type);
                letExp = letExp.getIn();
            }
        }
        return firstLetExp;
    }

    @Override
    public MonikeredElement visitLetVariableCS(LetVariableCS csLetVariable) {
        return null;
    }

    @Override
    public MonikeredElement visitNameExpCS(NameExpCS csNameExp) {
        EObject eContainer = csNameExp.eContainer();
        if (eContainer instanceof NavigatingExpCS) {
            EObject eContainerContainer = eContainer.eContainer();
            if (eContainerContainer instanceof NamedExpCS) {
                logger.warn((Object)("Unsupported '" + eContainerContainer.eClass().getName() + "' for () navigation"));
            }
            return null;
        }
        NamedElement element = csNameExp.getElement();
        if (element.eIsProxy()) {
            Element pivot = csNameExp.getPivot();
            if (pivot instanceof InvalidLiteralExp) {
                return (InvalidLiteralExp)pivot;
            }
            InvalidLiteralExp invalidLiteralExp = this.typeManager.createInvalidExpression();
            ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csNameExp, (Element)invalidLiteralExp);
            return invalidLiteralExp;
        }
        if (element instanceof VariableDeclaration) {
            return this.resolveVariableExp(csNameExp, (VariableDeclaration)element);
        }
        if (element instanceof Property) {
            return this.resolvePropertyCallExp(csNameExp, (Property)element);
        }
        if (element instanceof Operation) {
            return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "No parameters for operation " + element.getName());
        }
        if (element instanceof Type) {
            return this.resolveTypeExp(csNameExp, (Type)element);
        }
        if (element instanceof EnumerationLiteral) {
            return this.resolveEnumLiteral(csNameExp, (EnumerationLiteral)element);
        }
        return ((CS2PivotConversion)this.context).addBadExpressionError((ModelElementCS)csNameExp, "Unsupported NameExpCS " + element.eClass().getName());
    }

    @Override
    public MonikeredElement visitNavigatingArgCS(NavigatingArgCS csNavigatingArg) {
        OclExpression pivot = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csNavigatingArg.getName());
        ((CS2PivotConversion)this.context).installPivotElement((ModelElementCS)csNavigatingArg, (Element)pivot);
        return pivot;
    }

    @Override
    public MonikeredElement visitNavigatingExpCS(NavigatingExpCS csNavigatingExp) {
        OperatorCS csParent = csNavigatingExp.getParent();
        if (csParent instanceof NavigationOperatorCS && csNavigatingExp != csParent.getSource()) {
            return (MonikeredElement)PivotUtil.getPivot(OclExpression.class, (Pivotable)csNavigatingExp);
        }
        return this.resolveOperation(csNavigatingExp);
    }

    @Override
    public OclExpression visitNavigationOperatorCS(NavigationOperatorCS csOperator) {
        OclExpression sourceExp = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csOperator.getSource());
        ExpCS argument = csOperator.getArgument();
        OclExpression navigatingExp = argument instanceof NavigatingExpCS ? this.resolveOperation((NavigatingExpCS)argument) : this.resolvePropertyNavigation((NamedExpCS)argument);
        ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csOperator, (Element)navigatingExp);
        return navigatingExp;
    }

    @Override
    public MonikeredElement visitNestedExpCS(NestedExpCS csNestedExp) {
        OclExpression pivot = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csNestedExp.getSource());
        ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csNestedExp, (Element)pivot);
        return pivot;
    }

    @Override
    public MonikeredElement visitNullLiteralExpCS(NullLiteralExpCS csNullLiteralExp) {
        NullLiteralExp expression = (NullLiteralExp)((CS2PivotConversion)this.context).refreshExpression(NullLiteralExp.class, PivotPackage.Literals.NULL_LITERAL_EXP, (MonikeredElementCS)csNullLiteralExp);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getOclVoidType());
        return expression;
    }

    @Override
    public MonikeredElement visitNumberLiteralExpCS(NumberLiteralExpCS csNumberLiteralExp) {
        Number number = csNumberLiteralExp.getName();
        if (number instanceof BigDecimal) {
            RealLiteralExp expression = (RealLiteralExp)((CS2PivotConversion)this.context).refreshExpression(RealLiteralExp.class, PivotPackage.Literals.REAL_LITERAL_EXP, (MonikeredElementCS)csNumberLiteralExp);
            expression.setRealSymbol((BigDecimal)number);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getRealType());
            return expression;
        }
        BigInteger bigInteger = (BigInteger)number;
        if (bigInteger.signum() < 0) {
            IntegerLiteralExp expression = (IntegerLiteralExp)((CS2PivotConversion)this.context).refreshExpression(IntegerLiteralExp.class, PivotPackage.Literals.INTEGER_LITERAL_EXP, (MonikeredElementCS)csNumberLiteralExp);
            expression.setIntegerSymbol(bigInteger);
            ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getIntegerType());
            return expression;
        }
        UnlimitedNaturalLiteralExp expression = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshExpression(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (MonikeredElementCS)csNumberLiteralExp);
        expression.setUnlimitedNaturalSymbol(bigInteger);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getUnlimitedNaturalType());
        return expression;
    }

    @Override
    public MonikeredElement visitOperatorCS(OperatorCS object) {
        return null;
    }

    @Override
    public MonikeredElement visitPrefixExpCS(PrefixExpCS csPrefixExp) {
        UnaryOperatorCS csRoot = (UnaryOperatorCS)csPrefixExp.getOwnedOperator().get(0);
        if (!(csPrefixExp.eContainer() instanceof InfixExpCS)) {
            ((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csRoot);
        }
        OclExpression pivotElement = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csRoot);
        ((CS2PivotConversion)this.context).reusePivotElement((ModelElementCS)csPrefixExp, (Element)pivotElement);
        return pivotElement;
    }

    @Override
    public MonikeredElement visitSelfExpCS(SelfExpCS csSelfExp) {
        VariableExp expression = (VariableExp)((CS2PivotConversion)this.context).refreshExpression(VariableExp.class, PivotPackage.Literals.VARIABLE_EXP, (MonikeredElementCS)csSelfExp);
        ScopeCSAdapter scopeAdapter = ElementUtil.getScopeCSAdapter((ElementCS)csSelfExp);
        EnvironmentView environmentView = new EnvironmentView(this.typeManager, (EStructuralFeature)PivotPackage.Literals.EXPRESSION_IN_OCL__CONTEXT_VARIABLE, "self");
        ScopeView scopeView = scopeAdapter.getOuterScopeView(this.typeManager, null);
        environmentView.computeLookups(scopeView);
        VariableDeclaration variableDeclaration = (VariableDeclaration)environmentView.getContent();
        expression.setReferredVariable(variableDeclaration);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)(variableDeclaration != null ? variableDeclaration.getType() : this.typeManager.getOclVoidType()));
        return expression;
    }

    @Override
    public MonikeredElement visitStringLiteralExpCS(StringLiteralExpCS csStringLiteralExp) {
        StringLiteralExp expression = (StringLiteralExp)((CS2PivotConversion)this.context).refreshExpression(StringLiteralExp.class, PivotPackage.Literals.STRING_LITERAL_EXP, (MonikeredElementCS)csStringLiteralExp);
        EList<String> names = csStringLiteralExp.getName();
        if (names.size() == 0) {
            expression.setStringSymbol("");
        } else if (names.size() == 1) {
            expression.setStringSymbol((String)names.get(0));
        } else {
            StringBuffer s = new StringBuffer();
            for (String name : names) {
                s.append(name);
            }
            expression.setStringSymbol(s.toString());
        }
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getStringType());
        return expression;
    }

    @Override
    public MonikeredElement visitTupleLiteralExpCS(TupleLiteralExpCS csTupleLiteralExp) {
        TupleLiteralExp expression = (TupleLiteralExp)((CS2PivotConversion)this.context).refreshExpression(TupleLiteralExp.class, PivotPackage.Literals.TUPLE_LITERAL_EXP, (MonikeredElementCS)csTupleLiteralExp);
        for (TupleLiteralPartCS csPart : csTupleLiteralExp.getOwnedParts()) {
            TupleLiteralPart tupleLiteralPart = (TupleLiteralPart)((CS2PivotConversion)this.context).visitLeft2Right(TupleLiteralPart.class, (VisitableCS)csPart);
        }
        ((CS2PivotConversion)this.context).refreshPivotList(TupleLiteralPart.class, (List)expression.getParts(), csTupleLiteralExp.getOwnedParts());
        String tupleTypeName = "Tuple";
        TupleType type = this.typeManager.getTupleType(tupleTypeName, (Collection)expression.getParts(), null, null);
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)type);
        return expression;
    }

    @Override
    public MonikeredElement visitTupleLiteralPartCS(TupleLiteralPartCS csTupleLiteralPart) {
        TupleLiteralPart pivotElement = (TupleLiteralPart)((CS2PivotConversion)this.context).refreshNamedElement(TupleLiteralPart.class, PivotPackage.Literals.TUPLE_LITERAL_PART, (NamedElementCS)csTupleLiteralPart);
        OclExpression initExpression = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csTupleLiteralPart.getInitExpression());
        pivotElement.setInitExpression(initExpression);
        TypedRefCS csType = csTupleLiteralPart.getOwnedType();
        Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initExpression.getType();
        ((CS2PivotConversion)this.context).setType((TypedElement)pivotElement, type);
        return pivotElement;
    }

    @Override
    public MonikeredElement visitTypeLiteralExpCS(TypeLiteralExpCS csTypeLiteralExp) {
        TypedRefCS csType = csTypeLiteralExp.getOwnedType();
        Type type = (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType);
        return this.resolveTypeExp(csTypeLiteralExp, type);
    }

    @Override
    public MonikeredElement visitUnaryOperatorCS(UnaryOperatorCS csOperator) {
        OclExpression source = (OclExpression)((CS2PivotConversion)this.context).visitLeft2Right(OclExpression.class, (VisitableCS)csOperator.getSource());
        OperationCallExp expression = (OperationCallExp)((CS2PivotConversion)this.context).refreshExpression(OperationCallExp.class, PivotPackage.Literals.OPERATION_CALL_EXP, (MonikeredElementCS)csOperator);
        ((CS2PivotConversion)this.context).refreshName((NamedElement)expression, csOperator.getName());
        expression.setSource(source);
        this.resolveOperationCall(expression, csOperator, new UnaryOperationFilter(this.typeManager, source.getType()));
        return expression;
    }

    @Override
    public MonikeredElement visitUnlimitedNaturalLiteralExpCS(UnlimitedNaturalLiteralExpCS csUnlimitedNaturalLiteralExp) {
        UnlimitedNaturalLiteralExp expression = (UnlimitedNaturalLiteralExp)((CS2PivotConversion)this.context).refreshExpression(UnlimitedNaturalLiteralExp.class, PivotPackage.Literals.UNLIMITED_NATURAL_LITERAL_EXP, (MonikeredElementCS)csUnlimitedNaturalLiteralExp);
        expression.setName("*");
        ((CS2PivotConversion)this.context).setType((TypedElement)expression, (Type)this.typeManager.getUnlimitedNaturalType());
        expression.setUnlimitedNaturalSymbol(BigInteger.valueOf(-1L));
        return expression;
    }

    @Override
    public MonikeredElement visitVariableCS(VariableCS csVariable) {
        Variable variable = (Variable)((CS2PivotConversion)this.context).refreshNamedElement(Variable.class, PivotPackage.Literals.VARIABLE, (NamedElementCS)csVariable);
        OclExpression initExpression = (OclExpression)PivotUtil.getPivot(OclExpression.class, (Pivotable)csVariable.getInitExpression());
        TypedRefCS csType = csVariable.getOwnedType();
        Type type = csType != null ? (Type)PivotUtil.getPivot(Type.class, (Pivotable)csType) : initExpression.getType();
        variable.setInitExpression(initExpression);
        ((CS2PivotConversion)this.context).setType((TypedElement)variable, type);
        return variable;
    }
}

