/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.cs2pivot;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.ocl.examples.pivot.AssociativityKind;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.pivot.OpaqueExpression;
import org.eclipse.ocl.examples.pivot.Precedence;
import org.eclipse.ocl.examples.pivot.util.Pivotable;
import org.eclipse.ocl.examples.pivot.utilities.PivotUtil;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.SpecificationCS;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasePostOrderVisitor;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.BasicContinuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.CS2PivotConversion;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Continuation;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.Dependency;
import org.eclipse.ocl.examples.xtext.base.cs2pivot.SingleContinuation;
import org.eclipse.ocl.examples.xtext.base.util.VisitableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.BinaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.CollectionTypeCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ContextCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.ExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.InfixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingArgCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigatingExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.NavigationRole;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.OperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.PrefixExpCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.UnaryOperatorCS;
import org.eclipse.ocl.examples.xtext.essentialocl.essentialOCLCST.VariableCS;
import org.eclipse.ocl.examples.xtext.essentialocl.util.AbstractExtendingDelegatingEssentialOCLCSVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLPostOrderVisitor
extends AbstractExtendingDelegatingEssentialOCLCSVisitor<Continuation<?>, CS2PivotConversion, BasePostOrderVisitor> {
    static final Logger logger = Logger.getLogger(EssentialOCLPostOrderVisitor.class);
    protected final TypeManager typeManager;

    public EssentialOCLPostOrderVisitor(CS2PivotConversion context) {
        super(new BasePostOrderVisitor(context), context);
        this.typeManager = context.getTypeManager();
    }

    protected void createInfixOperatorTree(InfixExpCS csInfix) {
        Map<Precedence, List<Integer>> precedenceToOperatorIndexes = this.createInfixPrecedenceToOperatorIndexesMap(csInfix);
        ArrayList<Precedence> sortedPrecedences = new ArrayList<Precedence>(precedenceToOperatorIndexes.keySet());
        Collections.sort(sortedPrecedences, PivotUtil.PrecedenceComparator.INSTANCE);
        EList<ExpCS> csExpressions = csInfix.getOwnedExpression();
        EList<BinaryOperatorCS> csOperators = csInfix.getOwnedOperator();
        for (Precedence precedence : sortedPrecedences) {
            boolean isLeft = precedence == null || precedence.getAssociativity() == AssociativityKind.LEFT;
            List<Integer> operatorIndexes = precedenceToOperatorIndexes.get(precedence);
            int operatorCount = operatorIndexes.size();
            int iFirst = isLeft ? 0 : operatorCount - 1;
            int iIndex = isLeft ? 1 : -1;
            int iLast = isLeft ? operatorCount : -1;
            int i = iFirst;
            while (i != iLast) {
                int operatorIndex = operatorIndexes.get(i);
                BinaryOperatorCS csOperator = (BinaryOperatorCS)csOperators.get(operatorIndex);
                ExpCS csSource = (ExpCS)csExpressions.get(operatorIndex);
                while (csSource.getParent() != null && csSource.getParent() != csOperator) {
                    csSource = csSource.getParent();
                }
                this.setSource(csOperator, csSource);
                ExpCS csArgument = (ExpCS)csExpressions.get(operatorIndex + 1);
                while (csArgument.getParent() != null && csArgument.getParent() != csOperator) {
                    csArgument = csArgument.getParent();
                }
                this.setArgument(csOperator, csArgument);
                i += iIndex;
            }
        }
    }

    protected Map<Precedence, List<Integer>> createInfixPrecedenceToOperatorIndexesMap(InfixExpCS csInfix) {
        EList<BinaryOperatorCS> csOperators = csInfix.getOwnedOperator();
        int operatorCount = csOperators.size();
        HashMap<Precedence, List<Integer>> precedenceToOperatorIndex = new HashMap<Precedence, List<Integer>>();
        int operatorIndex = 0;
        while (operatorIndex < operatorCount) {
            BinaryOperatorCS csOperator = (BinaryOperatorCS)csOperators.get(operatorIndex);
            Precedence precedence = this.typeManager.getInfixPrecedence(csOperator.getName());
            ArrayList<Integer> indexesList = (ArrayList<Integer>)precedenceToOperatorIndex.get(precedence);
            if (indexesList == null) {
                indexesList = new ArrayList<Integer>();
                precedenceToOperatorIndex.put(precedence, indexesList);
            }
            indexesList.add(operatorIndex);
            ++operatorIndex;
        }
        return precedenceToOperatorIndex;
    }

    protected void initializePrefixOperators(PrefixExpCS prefixExpCS, OperatorCS csParent) {
        prefixExpCS.setParent(null);
        for (UnaryOperatorCS csUnaryOperator : prefixExpCS.getOwnedOperator()) {
            if (csParent instanceof UnaryOperatorCS) {
                this.setSource(csParent, csUnaryOperator);
            } else if (csParent instanceof BinaryOperatorCS) {
                if (csParent.getSource() == prefixExpCS) {
                    this.setSource(csParent, csUnaryOperator);
                } else {
                    this.setArgument((BinaryOperatorCS)csParent, csUnaryOperator);
                }
            }
            ExpCS csChild = prefixExpCS.getOwnedExpression();
            this.setSource(csUnaryOperator, csChild);
            csParent = csUnaryOperator;
        }
    }

    protected void interleavePrefixes(InfixExpCS csElement) {
        for (ExpCS csExp : csElement.getOwnedExpression()) {
            if (!(csExp instanceof PrefixExpCS)) continue;
            PrefixExpCS prefixExpCS = (PrefixExpCS)csExp;
            OperatorCS csExpressionParent = prefixExpCS.getParent();
            this.initializePrefixOperators(prefixExpCS, csExpressionParent);
            for (UnaryOperatorCS csUnaryOperator : prefixExpCS.getOwnedOperator()) {
                this.interleaveUnaryOperator(csUnaryOperator);
            }
        }
    }

    protected void interleaveUnaryOperator(UnaryOperatorCS csOperator) {
        OperatorCS csParent;
        while ((csParent = csOperator.getParent()) instanceof BinaryOperatorCS) {
            int unaryOrder;
            Precedence parentPrecedence = this.typeManager.getInfixPrecedence(csParent.getName());
            Precedence unaryPrecedence = this.typeManager.getPrefixPrecedence(csOperator.getName());
            int parentOrder = parentPrecedence != null ? parentPrecedence.getOrder().intValue() : -1;
            int n = unaryOrder = unaryPrecedence != null ? unaryPrecedence.getOrder().intValue() : -1;
            if (unaryOrder < parentOrder) break;
            OperatorCS csGrandParent = csParent.getParent();
            ExpCS csExp = csOperator.getSource();
            if (csOperator != csParent.getSource()) break;
            this.setSource(csParent, null);
            if (csGrandParent instanceof BinaryOperatorCS) {
                if (csGrandParent.getSource() == csParent) {
                    this.setSource(csGrandParent, csOperator);
                } else {
                    this.setArgument((BinaryOperatorCS)csGrandParent, csOperator);
                }
            }
            this.setSource(csOperator, csParent);
            this.setSource(csParent, csExp);
        }
    }

    private void setArgument(BinaryOperatorCS csParent, ExpCS csArgument) {
        csArgument.setParent(csParent);
        csParent.setArgument(csArgument);
        int i = 0;
        OperatorCS csOperator = csParent.getParent();
        while (csOperator != null) {
            if (csOperator == csParent) {
                logger.error((Object)"Operator loop established");
            } else if (i++ > 1000) {
                logger.error((Object)"Operator depth limit exceeded");
            }
            csOperator = csOperator.getParent();
        }
    }

    private void setSource(OperatorCS csParent, ExpCS csSource) {
        if (csSource != null) {
            csSource.setParent(csParent);
            int i = 0;
            OperatorCS csOperator = csParent.getParent();
            while (csOperator != null) {
                if (csOperator == csParent) {
                    logger.error((Object)"Operator loop established");
                } else if (i++ > 1000) {
                    logger.error((Object)"Operator depth limit exceeded");
                }
                csOperator = csOperator.getParent();
            }
            csParent.setSource(csSource);
        } else {
            csParent.getSource().setParent(null);
            csParent.setSource(csSource);
        }
    }

    @Override
    public Continuation<?> visitCollectionTypeCS(CollectionTypeCS csCollectionType) {
        return null;
    }

    @Override
    public Continuation<?> visitContextCS(ContextCS csContext) {
        ExpCS ownedExpression = csContext.getOwnedExpression();
        if (ownedExpression != null) {
            return new ContextCSCompletion((CS2PivotConversion)this.context, csContext);
        }
        return null;
    }

    @Override
    public Continuation<?> visitExpCS(ExpCS csExp) {
        return null;
    }

    @Override
    public Continuation<?> visitInfixExpCS(InfixExpCS csInfixExp) {
        this.createInfixOperatorTree(csInfixExp);
        this.interleavePrefixes(csInfixExp);
        return null;
    }

    @Override
    public Continuation<?> visitNavigatingExpCS(NavigatingExpCS csNavigatingExp) {
        EList<NavigatingArgCS> csArguments = csNavigatingExp.getArgument();
        if (csArguments.size() > 0) {
            NavigationRole role = NavigationRole.EXPRESSION;
            int i = csArguments.size() - 1;
            while (i >= 0) {
                NavigatingArgCS csArgument = (NavigatingArgCS)csArguments.get(i);
                switch (role) {
                    case EXPRESSION: {
                        csArgument.setRole(NavigationRole.EXPRESSION);
                        if (!"|".equals(csArgument.getPrefix())) break;
                        role = NavigationRole.ACCUMULATOR;
                        break;
                    }
                    case ACCUMULATOR: {
                        if (csArgument.getInit() != null) {
                            csArgument.setRole(NavigationRole.ACCUMULATOR);
                            if (!";".equals(csArgument.getPrefix())) break;
                            role = NavigationRole.ITERATOR;
                            break;
                        }
                        role = NavigationRole.ITERATOR;
                        csArgument.setRole(NavigationRole.ITERATOR);
                        break;
                    }
                    case ITERATOR: {
                        csArgument.setRole(NavigationRole.ITERATOR);
                    }
                }
                --i;
            }
        }
        return null;
    }

    @Override
    public Continuation<?> visitOperatorCS(OperatorCS csOperator) {
        return null;
    }

    @Override
    public Continuation<?> visitPrefixExpCS(PrefixExpCS csPrefixExp) {
        if (!(csPrefixExp.eContainer() instanceof InfixExpCS)) {
            this.initializePrefixOperators(csPrefixExp, null);
        }
        return null;
    }

    public Continuation<?> visitSpecificationCS(SpecificationCS csSpecification) {
        OpaqueExpression pivotSpecification = (OpaqueExpression)PivotUtil.getPivot(OpaqueExpression.class, (Pivotable)csSpecification);
        String exprString = csSpecification.getExprString();
        pivotSpecification.getBodies().add((Object)exprString);
        pivotSpecification.getLanguages().add((Object)"OCL");
        return null;
    }

    @Override
    public Continuation<?> visitVariableCS(VariableCS csVariable) {
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class ContextCSCompletion
    extends SingleContinuation<ContextCS> {
        public ContextCSCompletion(CS2PivotConversion context, ContextCS csElement) {
            super(context, null, null, (EObject)csElement, new Dependency[0]);
        }

        public BasicContinuation<?> execute() {
            this.context.visitLeft2Right(MonikeredElement.class, (VisitableCS)this.csElement);
            return null;
        }
    }
}

