/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.services;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.Package;
import org.eclipse.ocl.examples.pivot.PrimitiveType;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.xtext.base.baseCST.BaseCSTPackage;
import org.eclipse.ocl.examples.xtext.base.baseCST.ImportCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.ModelElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.NamedElementCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypeRefCS;
import org.eclipse.ocl.examples.xtext.base.baseCST.TypedTypeRefCS;
import org.eclipse.ocl.examples.xtext.base.pivot2cs.AliasAnalysis;
import org.eclipse.xtext.CrossReference;
import org.eclipse.xtext.GrammarUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.ILinkingService;
import org.eclipse.xtext.linking.impl.LinkingHelper;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.parsetree.reconstr.impl.CrossReferenceSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLCrossReferenceSerializer
extends CrossReferenceSerializer {
    @Inject
    private LinkingHelper linkingHelper;
    @Inject
    private ILinkingService linkingService;
    @Inject
    private IValueConverterService valueConverter;

    protected String getConvertedLinkText(EObject object, EReference reference, EObject context) {
        if (reference == BaseCSTPackage.Literals.TYPED_TYPE_REF_CS__TYPE && context instanceof TypedTypeRefCS) {
            if (object instanceof PrimitiveType) {
                return ((PrimitiveType)object).getName();
            }
            TypedTypeRefCS csRef = (TypedTypeRefCS)context;
            while (csRef.eContainer() instanceof TypeRefCS) {
                csRef = (TypeRefCS)csRef.eContainer();
            }
            ModelElementCS csContext = (ModelElementCS)csRef.eContainer();
            Element pivot = csContext.getPivot();
            AliasAnalysis aliasAnalysis = AliasAnalysis.getAdapter((Resource)csContext.eResource());
            List<PathElement> contextPath = this.getPath(aliasAnalysis, pivot);
            List<PathElement> objectPath = this.getPath(aliasAnalysis, (Element)object);
            return this.getDivergentPath(objectPath, contextPath);
        }
        return null;
    }

    private String getDivergentPath(List<PathElement> objectPath, List<PathElement> contextPath) {
        int i = 0;
        int iSize = objectPath.size();
        int iMax = Math.min(iSize, contextPath.size());
        while (i < iMax) {
            EObject objectElement = objectPath.get((int)i).element;
            EObject contextElement = contextPath.get((int)i).element;
            if (!objectElement.equals(contextElement)) break;
            ++i;
        }
        StringBuffer s = new StringBuffer();
        String ruleName = "UnrestrictedName";
        while (i < iSize - 1) {
            PathElement objectPathElement = objectPath.get(i);
            String objectName = objectPathElement.name;
            if (s.length() == 0) {
                EObject objectElement = objectPathElement.element;
                EObject contextElement = contextPath.get((int)i).element;
                Resource objectResource = objectElement.eResource();
                TypeManager typeManager = TypeManager.findAdapter((ResourceSet)objectResource.getResourceSet());
                Resource orphanage = typeManager != null ? typeManager.getOrphanPackage().eResource() : null;
                Resource contextResource = contextElement.eResource();
                if (objectResource == contextResource || contextResource == orphanage) {
                    objectName = ((NamedElement)objectElement).getName();
                }
            }
            s.append(this.valueConverter.toString((Object)objectName, ruleName));
            s.append("::");
            ruleName = "UnreservedName";
            ++i;
        }
        if (iSize > 0) {
            s.append(this.valueConverter.toString((Object)objectPath.get((int)(iSize - 1)).name, ruleName));
        }
        return s.toString();
    }

    private List<PathElement> getPath(AliasAnalysis aliasAnalysis, Element eObject) {
        String alias;
        if (eObject instanceof Package && (alias = aliasAnalysis.getAlias((EObject)eObject)) != null) {
            ArrayList<PathElement> result = new ArrayList<PathElement>();
            result.add(new PathElement(alias, (EObject)eObject));
            return result;
        }
        EObject eContainer = eObject.eContainer();
        if (eContainer == null) {
            return new ArrayList<PathElement>();
        }
        List<PathElement> result = this.getPath(aliasAnalysis, (Element)eContainer);
        if (eObject instanceof NamedElement) {
            result.add(new PathElement(((NamedElement)eObject).getName(), (EObject)eObject));
        } else if (eObject instanceof ENamedElement) {
            result.add(new PathElement(((ENamedElement)eObject).getName(), (EObject)eObject));
        } else if (eObject instanceof NamedElementCS) {
            result.add(new PathElement(((NamedElementCS)eObject).getName(), (EObject)eObject));
        }
        return result;
    }

    protected String getUnconvertedLinkText(EObject object, EReference reference, EObject context) {
        if (reference == BaseCSTPackage.Literals.IMPORT_CS__NAMESPACE && context instanceof ImportCS) {
            return ((ImportCS)context).getUri();
        }
        if (object instanceof NamedElement) {
            return ((NamedElement)object).getName();
        }
        return super.getUnconvertedLinkText(object, reference, context);
    }

    public String serializeCrossRef(EObject context, CrossReference grammarElement, EObject target, INode node) {
        List objects;
        EReference ref = GrammarUtil.getReference((CrossReference)grammarElement, (EClass)context.eClass());
        String text = null;
        if (node != null && (objects = this.linkingService.getLinkedObjects(context, ref, node)).contains(target)) {
            return "<KEEP_VALUE_FROM_NODE_MODEL>";
        }
        text = this.getConvertedLinkText(target, ref, context);
        if (text != null) {
            return text;
        }
        text = this.getUnconvertedLinkText(target, ref, context);
        if (text != null) {
            return this.getConvertedValue(text, grammarElement);
        }
        if (node != null) {
            return this.linkingHelper.getCrossRefNodeAsString(node, false);
        }
        return null;
    }

    private class PathElement {
        public final String name;
        public final EObject element;

        public PathElement(String name, EObject element) {
            this.name = name;
            this.element = element;
        }

        public String toString() {
            return this.name;
        }
    }
}

