/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.essentialocl.services;

import com.google.inject.Inject;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.ocl.examples.pivot.utilities.IllegalLibraryException;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.scoping.cs.BaseScopeProvider;
import org.eclipse.ocl.examples.xtext.base.utilities.CS2Moniker;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.conversion.IValueConverterService;
import org.eclipse.xtext.linking.impl.DefaultLinkingService;
import org.eclipse.xtext.linking.impl.IllegalNodeException;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.scoping.IGlobalScopeProvider;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.IScopeProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EssentialOCLLinkingService
extends DefaultLinkingService {
    private static int depth = -1;
    @Inject
    private IValueConverterService valueConverterService;
    @Inject
    private IGlobalScopeProvider globalScopeProvider;

    public List<EObject> getLinkedObjects(EObject context, EReference ref, INode node) throws IllegalNodeException {
        try {
            ++depth;
            String text = this.getText(node);
            boolean traceLookup = BaseScopeProvider.LOOKUP.isActive();
            if (text == null) {
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup null");
                }
                List<EObject> list = Collections.emptyList();
                return list;
            }
            IScope scope = null;
            String uri = "http://www.eclipse.org/xtext/common/JavaVMTypes";
            if (ref.getEReferenceType().getEPackage().getNsURI().equals(uri)) {
                scope = this.globalScopeProvider.getScope(context.eResource(), ref, null);
            } else {
                scope = this.getScope(context, ref);
                if (traceLookup) {
                    BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text);
                }
            }
            QualifiedName qualifiedName = QualifiedName.create((String[])new String[]{text});
            IEObjectDescription eObjectDescription = scope.getSingleElement(qualifiedName);
            if (eObjectDescription != null) {
                EObject eObjectOrProxy = eObjectDescription.getEObjectOrProxy();
                if (traceLookup) {
                    if (eObjectOrProxy instanceof MonikeredElementCS) {
                        BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + CS2Moniker.toString((MonikeredElementCS)((MonikeredElementCS)eObjectOrProxy)));
                    } else {
                        BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " => " + eObjectOrProxy);
                    }
                }
                List<EObject> list = Collections.singletonList(eObjectOrProxy);
                return list;
            }
            if (traceLookup) {
                BaseScopeProvider.LOOKUP.println(depth + " Lookup " + text + " failed");
            }
            eObjectDescription = scope.getSingleElement(qualifiedName);
            List<EObject> list = Collections.emptyList();
            return list;
        }
        catch (IllegalLibraryException e) {
            List<EObject> list = Collections.emptyList();
            return list;
        }
        finally {
            --depth;
        }
    }

    protected IScope getScope(EObject context, EReference reference) {
        IScopeProvider scopeProvider = this.getScopeProvider();
        if (scopeProvider == null) {
            throw new IllegalStateException("scopeProvider must not be null.");
        }
        return scopeProvider.getScope(context, reference);
    }

    public String getText(INode node) {
        ILeafNode leafNode = ElementUtil.getLeafNode((INode)node);
        if (leafNode == null) {
            return null;
        }
        EObject grammarElement = leafNode.getGrammarElement();
        String ruleName = this.getLinkingHelper().getRuleNameFrom(grammarElement);
        return (String)this.valueConverterService.toValue(leafNode.getText(), ruleName, (INode)leafNode);
    }
}

