/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.oclinecore.ui;

import com.google.inject.Inject;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.presentation.EcoreEditor;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.ocl.examples.pivot.MonikeredElement;
import org.eclipse.ocl.examples.xtext.base.baseCST.MonikeredElementCS;
import org.eclipse.ocl.examples.xtext.base.utilities.ElementUtil;
import org.eclipse.xtext.resource.ILocationInFileProvider;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.ui.editor.XtextEditor;
import org.eclipse.xtext.ui.editor.model.IXtextDocument;
import org.eclipse.xtext.ui.editor.validation.ValidatingEditorCallback;
import org.eclipse.xtext.util.ITextRegion;
import org.eclipse.xtext.util.concurrent.IUnitOfWork;

public class OCLinEcoreEditorCallback
extends ValidatingEditorCallback {
    @Inject
    private ILocationInFileProvider locationProvider;

    public void afterCreatePartControl(XtextEditor editor) {
        super.afterCreatePartControl(editor);
        XtextEditor_EcoreEditor_AdapterFactory factory = new XtextEditor_EcoreEditor_AdapterFactory(editor);
        Platform.getAdapterManager().registerAdapters((IAdapterFactory)factory, XtextEditor.class);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XtextEditor_EcoreEditor
    extends EcoreEditor {
        private XtextEditor editor;
        private EditingDomain editingDomain = new DummyEditingDomain();
        private ResourceSet resourceSet = new DummyResourceSet();

        public XtextEditor_EcoreEditor(XtextEditor editor) {
            this.editor = editor;
        }

        public EditingDomain getEditingDomain() {
            return this.editingDomain;
        }

        private EObject getEObject(final URI uri, boolean loadOnDemand) {
            IXtextDocument document = this.editor.getDocument();
            if (document == null) {
                return null;
            }
            EObject eObject = (EObject)document.readOnly((IUnitOfWork)new IUnitOfWork<EObject, XtextResource>(){

                public EObject exec(XtextResource state) throws Exception {
                    return state.getEObject(uri.fragment());
                }
            });
            return eObject;
        }

        private ResourceSet getResourceSet() {
            return this.resourceSet;
        }

        public void setSelectionToViewer(Collection<?> collection) {
            MonikeredElementCS csElement;
            Object object;
            Iterator<?> iterator;
            if (collection != null && (iterator = collection.iterator()).hasNext() && (object = iterator.next()) instanceof MonikeredElement && (csElement = ElementUtil.getCsElement((MonikeredElement)((MonikeredElement)object))) != null) {
                this.selectAndReveal(EcoreUtil.getURI((EObject)csElement), true);
            }
        }

        protected void selectAndReveal(final URI uri, final boolean select) {
            if (uri.fragment() != null) {
                this.editor.getDocument().readOnly((IUnitOfWork)new IUnitOfWork.Void<XtextResource>(){

                    public void process(XtextResource resource) throws Exception {
                        EObject object;
                        if (resource != null && (object = resource.getEObject(uri.fragment())) != null) {
                            ITextRegion location = OCLinEcoreEditorCallback.this.locationProvider.getSignificantTextRegion(object);
                            if (select) {
                                XtextEditor_EcoreEditor.this.editor.selectAndReveal(location.getOffset(), location.getLength());
                            } else {
                                XtextEditor_EcoreEditor.this.editor.reveal(location.getOffset(), location.getLength());
                            }
                        }
                    }
                });
            }
        }

        public final class DummyEditingDomain
        extends AdapterFactoryEditingDomain {
            public DummyEditingDomain() {
                super(null, null);
            }

            public ResourceSet getResourceSet() {
                return XtextEditor_EcoreEditor.this.getResourceSet();
            }
        }

        public final class DummyResourceSet
        extends ResourceSetImpl {
            public EObject getEObject(URI uri, boolean loadOnDemand) {
                return XtextEditor_EcoreEditor.this.getEObject(uri, loadOnDemand);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public final class XtextEditor_EcoreEditor_AdapterFactory
    implements IAdapterFactory {
        private XtextEditor editor;

        public XtextEditor_EcoreEditor_AdapterFactory(XtextEditor editor) {
            this.editor = editor;
        }

        public Object getAdapter(Object adaptableObject, Class adapterType) {
            if (adapterType == EcoreEditor.class && adaptableObject instanceof XtextEditor) {
                return new XtextEditor_EcoreEditor(this.editor);
            }
            return null;
        }

        public Class<?>[] getAdapterList() {
            return new Class[]{EcoreEditor.class};
        }
    }
}

