/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import com.mongodb.BasicDBObject;
import com.mongodb.CommandResult;
import com.mongodb.DBObject;
import com.mongodb.DBPort;
import com.mongodb.Mongo;
import com.mongodb.MongoInternalException;
import com.mongodb.MongoOptions;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReplicaSetStatus {
    static final Logger _rootLogger = Logger.getLogger("com.mongodb.ReplicaSetStatus");
    static final int UNAUTHENTICATED_ERROR_CODE = 10057;
    final List<Node> _all;
    Updater _updater;
    Mongo _mongo;
    String _setName = null;
    int maxBsonObjectSize = 0;
    Logger _logger = _rootLogger;
    String _lastPrimarySignal;
    boolean _closed = false;
    final Random _random = new Random();
    long _nextResolveTime;
    static int updaterIntervalMS;
    static int slaveAcceptableLatencyMS;
    static int inetAddrCacheMS;
    static final MongoOptions _mongoOptions;
    static final DBObject _isMasterCmd;

    ReplicaSetStatus(Mongo mongo, List<ServerAddress> initial) {
        this._mongo = mongo;
        this._all = Collections.synchronizedList(new ArrayList());
        for (ServerAddress addr : initial) {
            this._all.add(new Node(addr));
        }
        this._nextResolveTime = System.currentTimeMillis() + (long)inetAddrCacheMS;
        this._updater = new Updater();
    }

    void start() {
        this._updater.start();
    }

    boolean ready() {
        return this._setName != null;
    }

    public String getName() {
        return this._setName;
    }

    void _checkClosed() {
        if (this._closed) {
            throw new IllegalStateException("ReplicaSetStatus closed");
        }
    }

    ServerAddress getMaster() {
        Node n = this.getMasterNode();
        if (n == null) {
            return null;
        }
        return n._addr;
    }

    Node getMasterNode() {
        this._checkClosed();
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get(i);
            if (!n.master()) continue;
            return n;
        }
        return null;
    }

    ServerAddress getASecondary() {
        this._checkClosed();
        Node best = null;
        double badBeforeBest = 0.0;
        int start = this._random.nextInt(this._all.size());
        double mybad = 0.0;
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get((start + i) % this._all.size());
            if (!n.secondary()) {
                mybad += 1.0;
                continue;
            }
            if (best == null) {
                best = n;
                badBeforeBest = mybad;
                mybad = 0.0;
                continue;
            }
            long diff = best._pingTime - n._pingTime;
            if (diff <= (long)slaveAcceptableLatencyMS && !((badBeforeBest - mybad) / (double)(this._all.size() - 1) > this._random.nextDouble())) continue;
            best = n;
            badBeforeBest = mybad;
            mybad = 0.0;
        }
        if (best == null) {
            return null;
        }
        return best._addr;
    }

    boolean hasServerUp() {
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get(i);
            if (!n._ok) continue;
            return true;
        }
        return false;
    }

    Node ensureMaster() {
        Node n = this.getMasterNode();
        if (n != null) {
            n.update();
            if (n._isMaster) {
                return n;
            }
        }
        if (this._lastPrimarySignal != null) {
            n = this.findNode(this._lastPrimarySignal);
            n.update();
            if (n._isMaster) {
                return n;
            }
        }
        this.updateAll();
        return this.getMasterNode();
    }

    synchronized void updateAll() {
        HashSet<Node> seenNodes = new HashSet<Node>();
        for (int i = 0; i < this._all.size(); ++i) {
            Node n = this._all.get(i);
            n.update(seenNodes);
        }
        if (!seenNodes.isEmpty()) {
            Iterator<Node> it = this._all.iterator();
            while (it.hasNext()) {
                if (seenNodes.contains(it.next())) continue;
                it.remove();
            }
        }
    }

    List<ServerAddress> getServerAddressList() {
        ArrayList<ServerAddress> addrs = new ArrayList<ServerAddress>();
        for (Node node : this._all) {
            addrs.add(node._addr);
        }
        return addrs;
    }

    Node _addIfNotHere(String host) {
        Node n = this.findNode(host);
        if (n == null) {
            try {
                n = new Node(new ServerAddress(host));
                this._all.add(n);
            }
            catch (UnknownHostException un) {
                this._logger.log(Level.WARNING, "couldn't resolve host [" + host + "]");
            }
        }
        return n;
    }

    Node findNode(String host) {
        for (int i = 0; i < this._all.size(); ++i) {
            if (!this._all.get((int)i)._names.contains(host)) continue;
            return this._all.get(i);
        }
        ServerAddress addr = null;
        try {
            addr = new ServerAddress(host);
        }
        catch (UnknownHostException un) {
            this._logger.log(Level.WARNING, "couldn't resolve host [" + host + "]");
            return null;
        }
        for (int i = 0; i < this._all.size(); ++i) {
            if (!this._all.get((int)i)._addr.equals(addr)) continue;
            this._all.get((int)i)._names.add(host);
            return this._all.get(i);
        }
        return null;
    }

    void printStatus() {
        for (int i = 0; i < this._all.size(); ++i) {
            System.out.println(this._all.get(i));
        }
    }

    void close() {
        if (!this._closed) {
            this._closed = true;
            for (int i = 0; i < this._all.size(); ++i) {
                this._all.get(i).close();
            }
        }
    }

    public int getMaxBsonObjectSize() {
        return this.maxBsonObjectSize;
    }

    public static void main(String[] args) throws Exception {
        LinkedList<ServerAddress> addrs = new LinkedList<ServerAddress>();
        addrs.add(new ServerAddress("127.0.0.1", 27017));
        addrs.add(new ServerAddress("127.0.0.1", 27018));
        Mongo m = new Mongo(addrs);
        ReplicaSetStatus status = new ReplicaSetStatus(m, addrs);
        status.start();
        System.out.println(status.ensureMaster()._addr);
        while (true) {
            System.out.println(status.ready());
            if (status.ready()) {
                status.printStatus();
                System.out.println("master: " + status.getMaster() + "\t secondary: " + status.getASecondary());
            }
            System.out.println("-----------------------");
            Thread.sleep(5000L);
        }
    }

    static {
        _mongoOptions = new MongoOptions();
        updaterIntervalMS = Integer.parseInt(System.getProperty("com.mongodb.updaterIntervalMS", "5000"));
        slaveAcceptableLatencyMS = Integer.parseInt(System.getProperty("com.mongodb.slaveAcceptableLatencyMS", "15"));
        inetAddrCacheMS = Integer.parseInt(System.getProperty("com.mongodb.inetAddrCacheMS", "300000"));
        ReplicaSetStatus._mongoOptions.connectTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterConnectTimeoutMS", "20000"));
        ReplicaSetStatus._mongoOptions.socketTimeout = Integer.parseInt(System.getProperty("com.mongodb.updaterSocketTimeoutMS", "20000"));
        _isMasterCmd = new BasicDBObject("ismaster", (Object)1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Node {
        final ServerAddress _addr;
        final Set<String> _names = Collections.synchronizedSet(new HashSet());
        DBPort _port;
        boolean _ok = false;
        long _lastCheck = 0L;
        long _pingTime = 0L;
        boolean _isMaster = false;
        boolean _isSecondary = false;
        double _priority = 0.0;

        Node(ServerAddress addr) {
            this._addr = addr;
            this._port = new DBPort(addr, null, _mongoOptions);
            this._names.add(addr.toString());
        }

        private void updateAddr() {
            try {
                if (this._addr.updateInetAddr()) {
                    this._port = new DBPort(this._addr, null, _mongoOptions);
                    ReplicaSetStatus.this._mongo.getConnector().updatePortPool(this._addr);
                    ReplicaSetStatus.this._logger.log(Level.INFO, "Address of host " + this._addr.toString() + " changed to " + this._addr.getSocketAddress().toString());
                }
            }
            catch (UnknownHostException ex) {
                ReplicaSetStatus.this._logger.log(Level.WARNING, null, ex);
            }
        }

        synchronized void update() {
            this.update(null);
        }

        synchronized void update(Set<Node> seenNodes) {
            try {
                Node node;
                String host;
                long start = System.currentTimeMillis();
                CommandResult res = this._port.runCommand(ReplicaSetStatus.this._mongo.getDB("admin"), _isMasterCmd);
                this._lastCheck = System.currentTimeMillis();
                this._pingTime = this._lastCheck - start;
                if (res == null) {
                    throw new MongoInternalException("Invalid null value returned from isMaster");
                }
                if (!this._ok) {
                    ReplicaSetStatus.this._logger.log(Level.WARNING, "Server seen up: " + this._addr);
                }
                this._ok = true;
                this._isMaster = res.getBoolean("ismaster", false);
                this._isSecondary = res.getBoolean("secondary", false);
                ReplicaSetStatus.this._lastPrimarySignal = res.getString("primary");
                if (res.containsField("hosts")) {
                    for (Object x : (List)res.get("hosts")) {
                        host = x.toString();
                        node = ReplicaSetStatus.this._addIfNotHere(host);
                        if (node == null || seenNodes == null) continue;
                        seenNodes.add(node);
                    }
                }
                if (res.containsField("passives")) {
                    for (Object x : (List)res.get("passives")) {
                        host = x.toString();
                        node = ReplicaSetStatus.this._addIfNotHere(host);
                        if (node == null || seenNodes == null) continue;
                        seenNodes.add(node);
                    }
                }
                if (this._isMaster) {
                    ReplicaSetStatus.this.maxBsonObjectSize = res.containsField("maxBsonObjectSize") ? (Integer)res.get("maxBsonObjectSize") : 0x400000;
                }
                if (res.containsField("setName")) {
                    String setName = res.get("setName").toString();
                    if (ReplicaSetStatus.this._setName == null) {
                        ReplicaSetStatus.this._setName = setName;
                        ReplicaSetStatus.this._logger = Logger.getLogger(_rootLogger.getName() + "." + setName);
                    } else if (!ReplicaSetStatus.this._setName.equals(setName)) {
                        ReplicaSetStatus.this._logger.log(Level.SEVERE, "mis match set name old: " + ReplicaSetStatus.this._setName + " new: " + setName);
                        return;
                    }
                }
            }
            catch (Exception e) {
                if (this._ok) {
                    ReplicaSetStatus.this._logger.log(Level.WARNING, "Server seen down: " + this._addr, e);
                } else if (Math.random() < 0.1) {
                    ReplicaSetStatus.this._logger.log(Level.WARNING, "Server seen down: " + this._addr);
                }
                this._ok = false;
            }
            if (!this._isMaster) {
                return;
            }
        }

        public boolean master() {
            return this._ok && this._isMaster;
        }

        public boolean secondary() {
            return this._ok && this._isSecondary;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("Replica Set Node: ").append(this._addr).append("\n");
            buf.append("\t ok \t").append(this._ok).append("\n");
            buf.append("\t ping \t").append(this._pingTime).append("\n");
            buf.append("\t master \t").append(this._isMaster).append("\n");
            buf.append("\t secondary \t").append(this._isSecondary).append("\n");
            buf.append("\t priority \t").append(this._priority).append("\n");
            return buf.toString();
        }

        public void close() {
            this._port.close();
            this._port = null;
        }
    }

    class Updater
    extends Thread {
        Updater() {
            super("ReplicaSetStatus:Updater");
            this.setDaemon(true);
        }

        public void run() {
            while (!ReplicaSetStatus.this._closed) {
                try {
                    ReplicaSetStatus.this.updateAll();
                    long now = System.currentTimeMillis();
                    if (inetAddrCacheMS > 0 && ReplicaSetStatus.this._nextResolveTime < now) {
                        ReplicaSetStatus.this._nextResolveTime = now + (long)inetAddrCacheMS;
                        for (Node node : ReplicaSetStatus.this._all) {
                            node.updateAddr();
                        }
                    }
                    ReplicaSetStatus.this._mongo.getConnector().checkMaster(true, false);
                }
                catch (Exception e) {
                    ReplicaSetStatus.this._logger.log(Level.WARNING, "couldn't do update pass", e);
                }
                try {
                    Thread.sleep(updaterIntervalMS);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

