/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.common.editor.xtext.scoping;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.common.editor.xtext.umlCommon.QualifiedName;
import org.eclipse.papyrus.common.editor.xtext.umlCommon.TypeRule;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.ElementImport;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.PackageImport;
import org.eclipse.uml2.uml.Type;
import org.eclipse.xtext.gmf.glue.edit.part.PopupXtextEditorHelper;
import org.eclipse.xtext.scoping.IScope;
import org.eclipse.xtext.scoping.Scopes;
import org.eclipse.xtext.scoping.impl.AbstractDeclarativeScopeProvider;
import org.eclipse.xtext.scoping.impl.SimpleScope;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UmlCommonScopeProvider
extends AbstractDeclarativeScopeProvider {
    private Namespace model = null;
    private Element contextElement = null;

    public UmlCommonScopeProvider() {
        this.initModel();
    }

    protected void initModel() {
        Object first;
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        ISelection mySelection = activePage.getSelection();
        if (mySelection instanceof IStructuredSelection && (first = ((IStructuredSelection)mySelection).getFirstElement()) != null && first instanceof IAdaptable) {
            Element el;
            this.contextElement = el = (Element)((IAdaptable)first).getAdapter(Element.class);
            if (el != null) {
                EList namespaces = el.getNearestPackage().allNamespaces();
                this.model = namespaces.size() == 0 ? el.getNearestPackage() : (Namespace)namespaces.get(namespaces.size() - 1);
            }
        }
        Assert.isNotNull((Object)this.contextElement, (String)"I can't find the edited element");
        Assert.isNotNull((Object)this.model, (String)"I can't find the model owning the edited element");
    }

    protected Namespace getModel() {
        return this.model;
    }

    protected Element getContextElement() {
        return this.contextElement;
    }

    public IScope scope_TypeRule_type(TypeRule ctx, EReference ref) {
        return this.create___TypeRule_type___Scope(ctx);
    }

    protected IScope create___TypeRule_type___Scope(TypeRule ctx) {
        if (ctx.getPath() == null) {
            TreeIterator i = PopupXtextEditorHelper.context.eResource().getAllContents();
            ArrayList<EObject> allContent = new ArrayList<EObject>();
            while (i.hasNext()) {
                EObject object = (EObject)i.next();
                if (!(object instanceof Element) || !this.isWantedType((Element)object)) continue;
                allContent.add(object);
            }
            Iterable visibleParameterBoxes = Scopes.scopedElementsFor(allContent);
            return new SimpleScope(visibleParameterBoxes);
        }
        ArrayList<Element> tmpVisibleElementsFromPath = new ArrayList<Element>();
        if (ctx.getPath() != null) {
            QualifiedName qualifiedName = ctx.getPath();
            while (qualifiedName.getRemaining() != null) {
                qualifiedName = qualifiedName.getRemaining();
            }
            Namespace nearestNamespace = qualifiedName.getPath();
            if (nearestNamespace != null) {
                ArrayList<Element> tmpVisiblePropertiesFromPath = new ArrayList<Element>();
                tmpVisiblePropertiesFromPath.addAll(this.getOwnedAndImportedType(nearestNamespace));
                for (Element e : tmpVisiblePropertiesFromPath) {
                    tmpVisibleElementsFromPath.add(e);
                }
            }
        }
        SimpleScope resultScope = null;
        if (!tmpVisibleElementsFromPath.isEmpty()) {
            Iterable iterableIEobjectDescriptions = Scopes.scopedElementsFor(tmpVisibleElementsFromPath);
            resultScope = resultScope != null ? new SimpleScope((IScope)resultScope, iterableIEobjectDescriptions) : new SimpleScope(iterableIEobjectDescriptions);
        }
        return resultScope != null ? resultScope : new SimpleScope(Scopes.scopedElementsFor(new ArrayList()));
    }

    protected List<Element> getOwnedAndImportedType(Namespace visited) {
        ArrayList<Element> visibleElements = new ArrayList<Element>();
        for (ElementImport eImport : visited.getElementImports()) {
            if (!this.isWantedType((Element)eImport.getImportedElement())) continue;
            visibleElements.add((Element)eImport.getImportedElement());
        }
        for (NamedElement n : visited.getOwnedMembers()) {
            if (this.isWantedType((Element)n)) {
                visibleElements.add((Element)n);
            }
            if (!(n instanceof Namespace)) continue;
            visibleElements.addAll(this.getOwnedAndImportedType((Namespace)n));
        }
        return visibleElements;
    }

    protected List<Namespace> getImportedNamespaces(Namespace visited) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        for (PackageImport pImport : visited.getPackageImports()) {
            namespaces.add((Namespace)pImport.getImportedPackage());
        }
        for (ElementImport eImport : visited.getElementImports()) {
            if (!(eImport.getImportedElement() instanceof Namespace)) continue;
            namespaces.add((Namespace)eImport.getImportedElement());
        }
        return namespaces;
    }

    protected List<Namespace> getOwnedAndImportedNamespaces(Namespace visited) {
        ArrayList<Namespace> namespaces = new ArrayList<Namespace>();
        namespaces.addAll(this.getImportedNamespaces(visited));
        for (NamedElement n : visited.getOwnedMembers()) {
            if (!(n instanceof Namespace)) continue;
            namespaces.add((Namespace)n);
        }
        return namespaces;
    }

    public IScope scope_QualifiedName_path(QualifiedName ctx, EReference ref) {
        ArrayList<Namespace> visibleNamespaces = new ArrayList<Namespace>();
        if (ctx != null && ctx.eContainer() != null && ctx.eContainer() instanceof QualifiedName) {
            Namespace parentNameSpace = ((QualifiedName)ctx.eContainer()).getPath();
            visibleNamespaces.addAll(this.getOwnedAndImportedNamespaces(parentNameSpace));
        } else {
            visibleNamespaces.add(this.getModel());
            visibleNamespaces.addAll(this.getImportedNamespaces(this.getModel()));
        }
        Iterable iterableIEobjectDescription = Scopes.scopedElementsFor(visibleNamespaces);
        return new SimpleScope(iterableIEobjectDescription);
    }

    protected boolean isWantedType(Element e) {
        return e instanceof Type;
    }
}

