/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.common.editor.xtext.umlCommon;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum Direction implements Enumerator
{
    IN(0, "IN", "in"),
    OUT(1, "OUT", "out"),
    INOUT(2, "INOUT", "inout"),
    RETURN(3, "RETURN", "return");

    public static final int IN_VALUE = 0;
    public static final int OUT_VALUE = 1;
    public static final int INOUT_VALUE = 2;
    public static final int RETURN_VALUE = 3;
    private static final Direction[] VALUES_ARRAY;
    public static final List<Direction> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new Direction[]{IN, OUT, INOUT, RETURN};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static Direction get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            Direction result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static Direction get(int value) {
        switch (value) {
            case 0: {
                return IN;
            }
            case 1: {
                return OUT;
            }
            case 2: {
                return INOUT;
            }
            case 3: {
                return RETURN;
            }
        }
        return null;
    }

    private Direction(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

