/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ocl.examples.xtext.papyrus;

import com.google.inject.Injector;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.ocl.examples.pivot.Element;
import org.eclipse.ocl.examples.pivot.NamedElement;
import org.eclipse.ocl.examples.pivot.evaluation.EvaluationContext;
import org.eclipse.ocl.examples.pivot.uml.UML2Ecore2Pivot;
import org.eclipse.ocl.examples.pivot.utilities.TypeManager;
import org.eclipse.ocl.examples.pivot.utilities.TypeManagerResourceAdapter;
import org.eclipse.ocl.examples.xtext.papyrus.EssentialOCLPartialModelEditor;
import org.eclipse.ocl.examples.xtext.papyrus.EssentialOCLPopupPlugin;
import org.eclipse.ocl.examples.xtext.papyrus.IXtextEMFReconciler2;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.LiteralString;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.gmf.glue.PopupEditorConfiguration;
import org.eclipse.xtext.gmf.glue.edit.part.DefaultXtextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXtextEMFReconciler;
import org.eclipse.xtext.gmf.glue.edit.part.PopupXtextEditorHelper;
import org.eclipse.xtext.gmf.glue.partialEditing.SourceViewerHandle;
import org.eclipse.xtext.resource.XtextResource;

public class EssentialOCLPopupEditorConfiguration
extends PopupEditorConfiguration {
    protected PopupXtextEditorHelper editorHelper = null;
    private TypeManager typeManager = null;

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        IGraphicalEditPart graphicalEditPart = (IGraphicalEditPart)editPart;
        Object model = graphicalEditPart.getModel();
        if (model == null) {
            return null;
        }
        if (!(model instanceof View)) {
            return null;
        }
        View view = (View)model;
        EObject element = view.getElement();
        if (element == null) {
            return null;
        }
        if (!(element instanceof Constraint)) {
            return null;
        }
        Constraint constraint = (Constraint)element;
        ValueSpecification specification = constraint.getSpecification();
        if (specification == null) {
            return null;
        }
        if (!(specification instanceof LiteralString) && !(specification instanceof OpaqueExpression)) {
            return null;
        }
        this.getPivotModel((EObject)constraint);
        Injector xtextInjector = EssentialOCLPopupPlugin.getInstance().getInjector("org.eclipse.ocl.examples.xtext.essentialocl.EssentialOCL");
        Reconciler modelReconciler = new Reconciler();
        String textToEdit = this.getTextToEdit(element);
        String fileExtension = "essentialocl";
        DefaultXtextSemanticValidator semanticValidator = new DefaultXtextSemanticValidator();
        SourceViewerHandle.bindPartialModelEditorClass(EssentialOCLPartialModelEditor.class);
        this.editorHelper = (PopupXtextEditorHelper)super.createPopupEditorHelper(graphicalEditPart, xtextInjector, (IXtextEMFReconciler)modelReconciler, textToEdit, fileExtension, (IXTextSemanticValidator)semanticValidator);
        return this.editorHelper;
    }

    protected Element getPivotModel(EObject umlObject) {
        if (!(umlObject instanceof Constraint)) {
            return null;
        }
        Resource umlResource = umlObject.eResource();
        if (umlResource == null) {
            return null;
        }
        if (this.typeManager == null) {
            this.typeManager = new TypeManager();
        }
        UML2Ecore2Pivot adapter = UML2Ecore2Pivot.getAdapter((Resource)umlResource, (TypeManager)this.typeManager);
        adapter.getPivotRoot();
        Namespace umlContainer = ((Constraint)umlObject).getContext();
        if (umlContainer instanceof Operation) {
            umlContainer = ((Operation)umlObject).getNamespace();
        }
        return adapter.getCreated(Element.class, (EObject)umlContainer);
    }

    public String getTextToEdit(Object editedObject) {
        Constraint umlConstraint = (Constraint)editedObject;
        String value = "";
        if (umlConstraint.getSpecification() != null) {
            if (umlConstraint.getSpecification() instanceof LiteralString) {
                if (((LiteralString)umlConstraint.getSpecification()).getValue() != null) {
                    value = String.valueOf(value) + ((LiteralString)umlConstraint.getSpecification()).getValue();
                }
            } else if (umlConstraint.getSpecification() instanceof OpaqueExpression) {
                int indexOfOCLBody = -1;
                OpaqueExpression opaqueExpression = (OpaqueExpression)umlConstraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        value = String.valueOf(value) + (String)opaqueExpression.getBodies().get(i);
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
        }
        return value;
    }

    public class Reconciler
    implements IXtextEMFReconciler2 {
        public void configureResource(XtextResource resource, EObject umlObject) {
            if (resource instanceof EvaluationContext) {
                TypeManagerResourceAdapter.getAdapter((Resource)resource, (TypeManager)EssentialOCLPopupEditorConfiguration.this.typeManager);
                Element pivotElement = EssentialOCLPopupEditorConfiguration.this.getPivotModel(umlObject);
                if (pivotElement instanceof NamedElement) {
                    ((EvaluationContext)resource).setContext((NamedElement)pivotElement, null);
                }
            }
        }

        public void reconcile(EObject modelObject, EObject xtextObject) {
            if (!(modelObject instanceof Constraint)) {
                return;
            }
            String newTextualRepresentation = EssentialOCLPopupEditorConfiguration.this.editorHelper.getSourceViewerHandle().getDocument().get();
            UpdateConstraintCommand updateCommand = new UpdateConstraintCommand((Constraint)modelObject, newTextualRepresentation);
            TransactionalEditingDomain dom = EditorUtils.getTransactionalEditingDomain();
            dom.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
        }
    }

    protected class UpdateConstraintCommand
    extends AbstractTransactionalCommand {
        protected final Constraint constraint;
        protected final String newTextualRepresentation;

        public UpdateConstraintCommand(Constraint constraint, String newTextualRepresentation) {
            super(EditorUtils.getTransactionalEditingDomain(), "Constraint Update", UpdateConstraintCommand.getWorkspaceFiles((EObject)constraint));
            this.constraint = constraint;
            this.newTextualRepresentation = newTextualRepresentation;
        }

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            OpaqueExpression opaqueExpression = null;
            int indexOfOCLBody = -1;
            if (this.constraint.getSpecification() == null || !(this.constraint.getSpecification() instanceof OpaqueExpression)) {
                opaqueExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            } else {
                opaqueExpression = (OpaqueExpression)this.constraint.getSpecification();
                int i = 0;
                while (i < opaqueExpression.getLanguages().size() && indexOfOCLBody == -1) {
                    if (((String)opaqueExpression.getLanguages().get(i)).equals("OCL")) {
                        indexOfOCLBody = i;
                    }
                    ++i;
                }
            }
            if (indexOfOCLBody == -1) {
                opaqueExpression.getLanguages().add((Object)"OCL");
                opaqueExpression.getBodies().add((Object)this.newTextualRepresentation);
            } else {
                opaqueExpression.getBodies().remove(indexOfOCLBody);
                opaqueExpression.getBodies().add(indexOfOCLBody, (Object)this.newTextualRepresentation);
            }
            this.constraint.setSpecification((ValueSpecification)opaqueExpression);
            return CommandResult.newOKCommandResult((Object)this.constraint);
        }
    }
}

