/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.controlmode.history.utils;

import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.controlmode.history.HistoryModel;
import org.eclipse.papyrus.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HistoryUtils {
    public static HistoryModel getHistoryModel() {
        try {
            return (HistoryModel)ModelUtils.getModelSetChecked().getModel("org.eclipse.papyrus.controlmode.history.HistoryModel");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static HistoryModel getHistoryModelChecked() throws ServiceException {
        return (HistoryModel)ModelUtils.getModelSetChecked().getModel("org.eclipse.papyrus.controlmode.history.HistoryModel");
    }

    public static HistoryModel getHistoryModel(ModelSet modelsManager) {
        return (HistoryModel)modelsManager.getModel("org.eclipse.papyrus.controlmode.history.HistoryModel");
    }

    public static HistoryModel getHistoryModel(ServicesRegistry servicesRegistry) {
        try {
            return (HistoryModel)ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry).getModel("org.eclipse.papyrus.controlmode.history.HistoryModel");
        }
        catch (ServiceException e) {
            return null;
        }
    }

    public static HistoryModel getHistoryModelChecked(ServicesRegistry servicesRegistry) throws ServiceException {
        return (HistoryModel)ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry).getModel("org.eclipse.papyrus.controlmode.history.HistoryModel");
    }

    public static URI getURIFullPath(String uri) {
        return URI.createURI((String)uri.substring(0, uri.lastIndexOf("/") + 1));
    }

    public static URI getURIFullPath(URI createURI) {
        return HistoryUtils.getURIFullPath(createURI.toString());
    }

    public static String resolve(URI uriPath, String currentURL) {
        URI currentURI = URI.createURI((String)currentURL);
        return currentURI.deresolve(uriPath).toString();
    }

    public static String resolve(URI uriPath, URI currentURI) {
        return currentURI == null ? "" : currentURI.deresolve(uriPath).toString();
    }

    public static List<ControledResource> getControledResourcesForURL(ModelSet set, String url) {
        if (url == null || set == null) {
            return Collections.emptyList();
        }
        LinkedList<ControledResource> result = new LinkedList<ControledResource>();
        for (Resource r : set.getResources()) {
            if (!"di".equals(r.getURI().fileExtension())) continue;
            for (EObject e : r.getContents()) {
                if (!(e instanceof ControledResource)) continue;
                HistoryUtils.addControled(url, (ControledResource)e, result);
            }
        }
        return result;
    }

    private static void addControled(String url, ControledResource controled, List<ControledResource> result) {
        if (url != null && url.equals(controled.getResourceURL())) {
            result.add(controled);
        }
        for (ControledResource c : controled.getChildren()) {
            HistoryUtils.addControled(url, c, result);
        }
    }
}

