/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.controlmode.umlprofiles.commands;

import java.util.ArrayList;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.papyrus.controlmode.commands.IUncontrolCommand;
import org.eclipse.papyrus.controlmode.umlprofiles.helpers.ProfileApplicationHelper;
import org.eclipse.uml2.common.edit.command.ChangeCommand;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

public class UMLProfileUncontrolCommand
implements IUncontrolCommand {
    public boolean provides(EObject selection, IUncontrolCommand.STATE_CONTROL state, Resource source, Resource target) {
        return true;
    }

    public void uncontrol(EditingDomain domain, final EObject selection, IUncontrolCommand.STATE_CONTROL state, Resource source, final Resource target, CompoundCommand commandToModify) {
        switch (state) {
            case PRE_MODEL: {
                commandToModify.append((Command)new ChangeCommand(domain, new Runnable(){

                    public void run() {
                        UMLProfileUncontrolCommand.this.unapplyDuplicateProfiles(selection, target);
                    }
                }));
                break;
            }
            case POST_MODEL: {
                commandToModify.append((Command)new ChangeCommand(domain, new Runnable(){

                    public void run() {
                        ProfileApplicationHelper.relocateStereotypeApplications((Package)selection, target);
                    }
                }));
            }
        }
    }

    private void unapplyDuplicateProfiles(EObject selection, Resource target) {
        Package _package = (Package)selection;
        EList allAppliedProfiles = _package.getAllAppliedProfiles();
        if (!allAppliedProfiles.isEmpty()) {
            for (Profile profile : new ArrayList(_package.getAppliedProfiles())) {
                if (!allAppliedProfiles.contains((Object)profile)) continue;
                ProfileApplicationHelper.removeProfileApplicationDuplication(_package, profile, true);
            }
        }
    }
}

