/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.controlmode.action;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.papyrus.controlmode.action.PapyrusControlAction;
import org.eclipse.papyrus.controlmode.action.PapyrusUncontrolAction;
import org.eclipse.papyrus.modelexplorer.NavigatorUtils;
import org.eclipse.papyrus.modelexplorer.factory.IActionHandlerFactory;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.CommonViewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CollaborativeActionsFactory
implements IActionHandlerFactory {
    protected List<Action> actions = new LinkedList<Action>();
    protected PapyrusControlAction controlAction;
    protected PapyrusUncontrolAction uncontrolAction;

    public List<Action> createActions(EditingDomain editingDomain) {
        this.controlAction = new PapyrusControlAction(editingDomain);
        this.actions.add((Action)this.controlAction);
        this.uncontrolAction = new PapyrusUncontrolAction(editingDomain);
        this.actions.add((Action)this.uncontrolAction);
        return this.actions;
    }

    public List<Action> getActions() {
        return this.actions;
    }

    public void activate(CommonNavigator activeViewPart) {
        this.controlAction.setActiveWorkbenchPart((IWorkbenchPart)activeViewPart);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            selectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.uncontrolAction);
        }
    }

    public void deactivate(CommonNavigator activeViewPart) {
        this.controlAction.setActiveWorkbenchPart(null);
        CommonViewer selectionProvider = null;
        if (activeViewPart.getCommonViewer() instanceof ISelectionProvider) {
            selectionProvider = activeViewPart.getCommonViewer();
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.controlAction);
            selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.uncontrolAction);
        }
    }

    public void fillActionBars(IActionBars actionBars) {
    }

    public void update(IStructuredSelection structuredSelection) {
        ArrayList<EObject> array = new ArrayList<EObject>();
        for (Object object : structuredSelection) {
            if (NavigatorUtils.resolveSemanticObject(object) == null) continue;
            array.add(NavigatorUtils.resolveSemanticObject(object));
        }
        StructuredSelection st = new StructuredSelection(array);
        this.controlAction.updateSelection((IStructuredSelection)st);
        this.controlAction.setEnabled(this.controlAction.isEnabled());
        this.uncontrolAction.updateSelection((IStructuredSelection)st);
        this.uncontrolAction.setEnabled(this.uncontrolAction.isEnabled());
    }
}

