/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.queries.converter;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.conversion.IConverter;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.core.queries.Activator;
import org.eclipse.papyrus.core.queries.configuration.ConstantParameterValue;
import org.eclipse.papyrus.core.queries.configuration.ListParameterValue;
import org.eclipse.papyrus.core.queries.configuration.ModiscoQueryConfiguration;
import org.eclipse.papyrus.core.queries.configuration.ParameterValue;
import org.eclipse.papyrus.core.queries.configuration.QueryConfiguration;
import org.eclipse.papyrus.core.queries.configuration.QueryExecutionValue;
import org.eclipse.papyrus.core.queries.configuration.util.ConfigurationSwitch;
import org.eclipse.papyrus.core.queries.converter.ConverterNotfoundException;
import org.eclipse.papyrus.core.queries.converter.ValueSpecificationToBooleanConverter;
import org.eclipse.papyrus.core.queries.converter.ValueSpecificationToIntegerConverter;
import org.eclipse.papyrus.core.queries.converter.ValueSpecificationToStringConverter;
import org.eclipse.papyrus.core.queries.modisco.QueryUtil;
import org.eclipse.uml2.uml.ValueSpecification;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConverterRegistry {
    private static ConverterRegistry instance;
    private Map<Class<?>, IConverter> converterMaps = new HashMap();

    private ConverterRegistry() {
    }

    public static synchronized ConverterRegistry getSingleton() {
        if (instance == null) {
            instance = new ConverterRegistry();
            instance.initializeRegistry();
        }
        return instance;
    }

    protected void initializeRegistry() {
        this.converterMaps.put(String.class, new ValueSpecificationToStringConverter());
        this.converterMaps.put(Integer.TYPE, new ValueSpecificationToIntegerConverter());
        this.converterMaps.put(Boolean.TYPE, new ValueSpecificationToBooleanConverter());
    }

    public IConverter getConverter(Class<?> toType) {
        return this.converterMaps.get(toType);
    }

    public Object convert(Class<?> parameterType, ValueSpecification valueInstance) throws ConverterNotfoundException {
        IConverter converter = this.getConverter(parameterType);
        if (converter != null) {
            return converter.convert((Object)valueInstance);
        }
        throw new ConverterNotfoundException(parameterType, valueInstance);
    }

    public List<?> convertToList(final EObject context, final Class<?> parameterType, ParameterValue parameterValue) {
        return (List)new ConfigurationSwitch<List<?>>(){

            public List<?> caseConstantParameterValue(ConstantParameterValue constantParameterValue) {
                IConverter converter = ConverterRegistry.this.getConverter(parameterType);
                if (converter != null) {
                    return Arrays.asList(converter.convert((Object)constantParameterValue.getValueInstance()));
                }
                Activator.log.error("Impossible to find a converter for type: " + parameterType, null);
                return Collections.emptyList();
            }

            public List<?> caseQueryExecutionValue(QueryExecutionValue queryExecutionValue) {
                QueryConfiguration queryConfiguration = queryExecutionValue.getConfiguration();
                if (!(queryConfiguration instanceof ModiscoQueryConfiguration)) {
                    throw new RuntimeException("List conversion not implemented for this type of configuration. " + queryConfiguration.eClass().getName());
                }
                Boolean executionResult = null;
                try {
                    executionResult = QueryUtil.evaluateBooleanQuery(context, queryConfiguration);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                }
                int upperBound = ((ModiscoQueryConfiguration)queryConfiguration).getQuery().getUpperBound();
                if (upperBound == 1) {
                    return Arrays.asList(executionResult);
                }
                return (List)((Object)executionResult);
            }

            public List<?> caseListParameterValue(ListParameterValue listParameterValue) {
                ArrayList values = new ArrayList();
                for (ParameterValue parameterValue : listParameterValue.getValues()) {
                    values.addAll(ConverterRegistry.this.convertToList(context, parameterType, parameterValue));
                }
                return values;
            }
        }.doSwitch((EObject)parameterValue);
    }
}

