/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.resourceloading;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.controlmode.history.HistoryModel;
import org.eclipse.papyrus.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.controlmode.mm.history.ControledResource;
import org.eclipse.papyrus.core.resourceloading.ControledResourceAdapter;
import org.eclipse.papyrus.core.resourceloading.HistoryRoutingUtils;
import org.eclipse.papyrus.core.resourceloading.IProxyManager;
import org.eclipse.papyrus.resource.ModelSet;

public class HistoryRoutingManager {
    private ControledResourceAdapter adapter;
    private final IProxyManager proxyManager;

    public HistoryRoutingManager(IProxyManager proxyManager) {
        this.proxyManager = proxyManager;
    }

    public EObject getEObject(ModelSet modelSet, String resourceURI, String fragment) {
        List<ControledResource> res;
        this.adapter = HistoryRoutingUtils.getControledResourceAdapter(modelSet);
        EObject result = null;
        HistoryModel historyModel = HistoryUtils.getHistoryModel((ModelSet)modelSet);
        if (historyModel != null && (res = this.adapter.getControledResource(resourceURI)) != null) {
            block0: for (ControledResource controled : res) {
                for (ControledResource child : controled.getChildren()) {
                    URI locationURI = URI.createURI((String)child.getResourceURL());
                    URI toGet = locationURI.resolve(HistoryUtils.getURIFullPath((URI)child.eResource().getURI()));
                    Resource resource = modelSet.getResource(toGet, this.proxyManager.loadResource(locationURI));
                    if (resource != null && ((result = resource.getEObject(fragment)) != null || (result = this.getEObject(modelSet, child.getResourceURL(), fragment)) != null)) continue block0;
                }
            }
        }
        return result;
    }

    public void unload() {
        if (this.adapter != null) {
            Notifier resSet = this.adapter.getTarget();
            resSet.eAdapters().remove((Object)this.adapter);
            this.adapter = null;
        }
    }
}

