/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.resourceloading.editor;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.sasheditor.contentprovider.IEditorModel;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.part.EditorPart;

public class UnloadResourcesEditorModel
implements IEditorModel {
    private String name;
    private final URI uri;

    public UnloadResourcesEditorModel(URI uri) {
        this.uri = uri;
        this.name = "unresolved tab";
    }

    public String getTabTitle() {
        return this.name;
    }

    public Image getTabIcon() {
        return null;
    }

    public Object getRawModel() {
        return this;
    }

    public IEditorPart createIEditorPart() throws PartInitException {
        return new UnloadResourcesEditorPart(this.uri);
    }

    public EditorActionBarContributor getActionBarContributor() {
        return null;
    }

    public static class UnloadResourcesEditorPart
    extends EditorPart {
        private final URI unloadedUri;

        public UnloadResourcesEditorPart(URI uri) {
            this.unloadedUri = uri;
        }

        public void doSave(IProgressMonitor monitor) {
        }

        public void doSaveAs() {
        }

        public void init(IEditorSite site, IEditorInput input) throws PartInitException {
            this.setSite((IWorkbenchPartSite)site);
            this.setInput(input);
            this.setPartName(input.getName());
        }

        public boolean isDirty() {
            return false;
        }

        public boolean isSaveAsAllowed() {
            return false;
        }

        public void createPartControl(Composite parent) {
            Composite compo = new Composite(parent, 0);
            compo.setLayout((Layout)new GridLayout(2, false));
            Image image = NotificationBuilder.getSWTImage((int)2, (Shell)parent.getShell());
            Label label = new Label(compo, 0);
            label.setImage(image);
            label.setLayoutData((Object)new GridData(0x1000000, 128, false, false));
            Text t = new Text(compo, 0);
            t.setText("This diagram is contained in an unresolved resource : " + this.unloadedUri.trimFragment().toString());
            t.setLayoutData((Object)new GridData(1808));
            t.setEditable(false);
            label.setBackground(t.getBackground());
            compo.setBackground(t.getBackground());
        }

        public void setFocus() {
        }
    }
}

