/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.resourceloading.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.resourceloading.HistoryRoutingManager;
import org.eclipse.papyrus.core.resourceloading.ILoadingStrategy;
import org.eclipse.papyrus.core.resourceloading.ILoadingStrategyExtension;
import org.eclipse.papyrus.core.resourceloading.IProxyManager;
import org.eclipse.papyrus.core.resourceloading.IStrategyChooser;
import org.eclipse.papyrus.resource.ModelSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProxyManager
implements IProxyManager {
    private static final String LOADING_STRATEGY_EXTENSION_POINT_ID = "org.eclipse.papyrus.core.resourceloading.loadingStrategy";
    private static final String LOADING_STRATEGY_ELEMENT_ID = "loadingStrategy";
    private static final String LOADING_STRATEGY_ID = "id";
    private static final String LOADING_STRATEGY_DESCRIPTION_ID = "description";
    private static final String STRATEGY_ID = "strategy";
    private static final String STRATEGY_EXTENDER_EXTENSION_POINT_ID = "org.eclipse.papyrus.core.resourceloading.loadingStrategyExtender";
    private static final String STRATEGY_EXTENDER_ELEMENT_ID = "strategyExtender";
    private static final String STRATEGY_EXTENSION_ID = "strategyExtension";
    private static final String STRATEGY_CHOOSER_EXTENSION_POINT_ID = "org.eclipse.papyrus.core.resourceloading.currentStrategyChooser";
    private static final String STRATEGY_CHOOSER_CHOOSER_ATTRIBUTE = "chooser";
    private static IStrategyChooser strategyChooser = ProxyManager.getStrategyChooser();
    private static Map<Integer, String> strategiesAndDescriptions = new HashMap<Integer, String>();
    private static Map<Integer, ILoadingStrategy> availableStrategies = ProxyManager.getLoadingStrategies();
    private static Set<ILoadingStrategyExtension> strategyExtensions = ProxyManager.getLoadingStrategyExtensions();
    private ModelSet modelSet;
    private HistoryRoutingManager routeManager = new HistoryRoutingManager(this);

    public ProxyManager(ModelSet modelSet) {
        this.modelSet = modelSet;
    }

    @Override
    public boolean loadResource(URI uri) {
        boolean result = availableStrategies.get(ProxyManager.getCurrentStrategy()).loadResource(this.modelSet, uri);
        Iterator<ILoadingStrategyExtension> iterator = strategyExtensions.iterator();
        while (!result && iterator.hasNext()) {
            ILoadingStrategyExtension extension = iterator.next();
            result = extension.loadResource(this.modelSet, uri.trimFragment());
        }
        return result;
    }

    @Override
    public EObject getEObjectFromStrategy(URI uri) throws MissingResourceException {
        boolean loadOnDemand;
        URI trimFragment = uri.trimFragment();
        Resource resource = this.modelSet.getResource(trimFragment, loadOnDemand = this.loadResource(trimFragment));
        if (resource != null) {
            String fragment = uri.fragment();
            EObject object = resource.getEObject(fragment);
            if (object != null) {
                return object;
            }
            String fileExtension = uri.fileExtension();
            Resource diResource = null;
            String resourceName = "";
            if ("di".equals(fileExtension)) {
                diResource = this.modelSet.getResource(trimFragment, loadOnDemand);
                resourceName = trimFragment.toString();
            } else {
                URI newURI = trimFragment.trimFileExtension().appendFileExtension("di");
                diResource = this.modelSet.getResource(newURI.trimFragment(), loadOnDemand);
                resourceName = newURI.trimFragment().toString();
            }
            if (diResource != null) {
                EObject eobject = this.routeManager.getEObject(this.modelSet, uri.lastSegment().toString(), fragment);
                if (eobject == null) {
                    throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{resourceName}), this.getClass().getName(), resourceName);
                }
                return eobject;
            }
            throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{resourceName}), this.getClass().getName(), resourceName);
        }
        if (loadOnDemand) {
            throw new MissingResourceException(CommonPlugin.INSTANCE.getString("_UI_StringResourceNotFound_exception", new Object[]{trimFragment.toString()}), this.getClass().getName(), trimFragment.toString());
        }
        return null;
    }

    private static int getCurrentStrategy() {
        if (strategyChooser == null) {
            return 0;
        }
        return strategyChooser.getCurrentStrategy();
    }

    public static Map<Integer, String> getAllStrategies() {
        return strategiesAndDescriptions;
    }

    private static Map<Integer, ILoadingStrategy> getLoadingStrategies() {
        IConfigurationElement[] extensions;
        HashMap<Integer, ILoadingStrategy> strategies = new HashMap<Integer, ILoadingStrategy>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(LOADING_STRATEGY_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (LOADING_STRATEGY_ELEMENT_ID.equals(element.getName())) {
                try {
                    int id = Integer.valueOf(element.getAttribute(LOADING_STRATEGY_ID));
                    String description = element.getAttribute(LOADING_STRATEGY_DESCRIPTION_ID);
                    ILoadingStrategy strategy = (ILoadingStrategy)element.createExecutableExtension(STRATEGY_ID);
                    strategies.put(id, strategy);
                    strategiesAndDescriptions.put(id, description);
                }
                catch (CoreException e1) {
                    Activator.log.error(e1.getMessage(), (Throwable)e1);
                    e1.printStackTrace();
                }
                catch (NumberFormatException e2) {
                    Activator.log.error(e2.getMessage(), (Throwable)e2);
                    e2.printStackTrace();
                }
            }
            ++n2;
        }
        return strategies;
    }

    private static Set<ILoadingStrategyExtension> getLoadingStrategyExtensions() {
        IConfigurationElement[] extensions;
        HashSet<ILoadingStrategyExtension> strategies = new HashSet<ILoadingStrategyExtension>();
        IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(STRATEGY_EXTENDER_EXTENSION_POINT_ID);
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            if (STRATEGY_EXTENDER_ELEMENT_ID.equals(element.getName())) {
                try {
                    ILoadingStrategyExtension strategyExtension = (ILoadingStrategyExtension)element.createExecutableExtension(STRATEGY_EXTENSION_ID);
                    strategies.add(strategyExtension);
                }
                catch (CoreException e) {
                    Activator.log.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
            }
            ++n2;
        }
        return strategies;
    }

    public static IStrategyChooser getStrategyChooser() {
        IStrategyChooser result = null;
        IConfigurationElement[] element = Platform.getExtensionRegistry().getConfigurationElementsFor(STRATEGY_CHOOSER_EXTENSION_POINT_ID);
        if (element.length > 0) {
            IConfigurationElement e = element[0];
            try {
                result = (IStrategyChooser)e.createExecutableExtension(STRATEGY_CHOOSER_CHOOSER_ATTRIBUTE);
            }
            catch (CoreException e1) {
                Activator.log.error(e1.getMessage(), (Throwable)e1);
                e1.printStackTrace();
            }
        }
        return result;
    }

    @Override
    public void dispose() {
        this.routeManager.unload();
    }
}

