/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.resourceloading.strategies;

import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.papyrus.controlmode.history.HistoryModel;
import org.eclipse.papyrus.controlmode.history.utils.HistoryUtils;
import org.eclipse.papyrus.core.resourceloading.HistoryRoutingUtils;
import org.eclipse.papyrus.core.resourceloading.ILoadingStrategy;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.sasheditor.SashModelUtils;

public class LoadControlledResources
implements ILoadingStrategy {
    public boolean loadResource(ModelSet modelSet, URI uri) {
        boolean result;
        boolean bl = result = !uri.isPlatform() && !uri.isFile();
        if (!result) {
            URI initialURI = SashModelUtils.getInitialURI((ModelSet)modelSet).trimFileExtension().appendFileExtension(uri.fileExtension());
            URI uriInitialTrimFragment = initialURI.trimFragment();
            URI uritrimFragment = uri.trimFragment();
            result = uritrimFragment.equals((Object)uriInitialTrimFragment);
            if (!result) {
                HistoryModel model = HistoryUtils.getHistoryModel((ModelSet)modelSet);
                URI path = HistoryUtils.getURIFullPath((URI)uriInitialTrimFragment);
                URI resolve = URI.createURI((String)HistoryUtils.resolve((URI)path, (URI)uriInitialTrimFragment));
                Set<String> allControled = HistoryRoutingUtils.getAllControledURIs(modelSet, model, resolve, true);
                result = allControled.contains(HistoryUtils.resolve((URI)path, (URI)uritrimFragment).toString());
            }
        }
        return result;
    }
}

