/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.resourceloading.util;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.notation.NotationUtils;

public class LoadingTester
extends PropertyTester {
    public static final String IS_ALL_LOADED = "isAllLoaded";
    public static final String IS_ALL_NOTLOADED = "isAllNotLoaded";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (IS_ALL_LOADED.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isInLoadedResource((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        if (IS_ALL_NOTLOADED.equals(property) && receiver instanceof IStructuredSelection) {
            boolean answer = this.isInNotLoadedResource((IStructuredSelection)receiver);
            return new Boolean(answer).equals(expectedValue);
        }
        return false;
    }

    private boolean isInLoadedResource(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            boolean atLeastOneInSubmodel = false;
            URI mainURI = null;
            for (Object obj : selection) {
                View view;
                EObject eObject;
                if (obj instanceof IAdaptable && (eObject = (view = (View)((IAdaptable)obj).getAdapter(View.class)) != null ? view.getElement() : (EObject)((IAdaptable)obj).getAdapter(EObject.class)) != null && !eObject.eIsProxy()) {
                    if (atLeastOneInSubmodel) continue;
                    Resource containingResource = eObject.eResource();
                    if (mainURI == null && containingResource != null && containingResource.getResourceSet() instanceof ModelSet) {
                        mainURI = NotationUtils.getNotationModel((ModelSet)((ModelSet)containingResource.getResourceSet())).getResourceURI().trimFileExtension();
                    }
                    if (mainURI == null) continue;
                    URI uriTrim = containingResource.getURI().trimFileExtension();
                    atLeastOneInSubmodel = !uriTrim.equals(mainURI);
                    continue;
                }
                return false;
            }
            return atLeastOneInSubmodel;
        }
        return false;
    }

    private boolean isInNotLoadedResource(IStructuredSelection selection) {
        if (!selection.isEmpty()) {
            for (Object obj : selection) {
                View target;
                View view;
                EObject eObject;
                if (obj instanceof IAdaptable && ((eObject = (view = (View)((IAdaptable)obj).getAdapter(View.class)) != null ? view.getElement() : (EObject)((IAdaptable)obj).getAdapter(EObject.class)) != null && eObject.eIsProxy() || view instanceof Edge && (target = ((Edge)view).getTarget()) != null && ViewUtil.resolveSemanticElement((View)target) == null)) continue;
                return false;
            }
            return true;
        }
        return false;
    }
}

