/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.contentoutline;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.papyrus.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.extension.BadClassNameException;
import org.eclipse.papyrus.core.extension.NotFoundException;
import org.eclipse.papyrus.core.extension.diagrameditor.EditorDescriptorExtensionFactory;
import org.osgi.framework.Bundle;

public class ContentOutlineRegistry {
    public static final String EDITOR_EXTENSION_ID = "papyrusContentOutline";
    private static String classAttributeName = "class";
    private static String actionBarContributorIdPropertyName = "actionBarContributorId";
    protected String extensionPointNamespace;
    protected IPapyrusContentOutlinePage contentOutline;
    private IMultiDiagramEditor multiEditor;

    public ContentOutlineRegistry(IMultiDiagramEditor multiEditor, String extensionPointNamespace) {
        this.multiEditor = multiEditor;
        this.extensionPointNamespace = extensionPointNamespace;
    }

    public IPapyrusContentOutlinePage getContentOutline() throws BackboneException {
        if (this.contentOutline == null) {
            this.createContentOutline();
        }
        return this.contentOutline;
    }

    private ContentOutlineDescriptor getContentOutlineDescriptor() throws BackboneException {
        IConfigurationElement[] configElements = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPointNamespace, EDITOR_EXTENSION_ID);
        ContentOutlineDescriptor found = null;
        IConfigurationElement[] iConfigurationElementArray = configElements;
        int n = configElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ele = iConfigurationElementArray[n2];
            ContentOutlineDescriptor desc = new ContentOutlineDescriptor(ele);
            if (desc.isHigher(found)) {
                found = desc;
            }
            ++n2;
        }
        if (found == null) {
            throw new NotFoundException("No ContentOutline registered.");
        }
        return found;
    }

    private void createContentOutline() throws BackboneException {
        ContentOutlineDescriptor found = this.getContentOutlineDescriptor();
        if (found != null) {
            this.contentOutline = found.createContentOutlinePage();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ContentOutlineDescriptor
    extends EditorDescriptorExtensionFactory {
        private int priority;
        private String className;
        private String actionBarContributorID;
        private IConfigurationElement element;
        protected IPapyrusContentOutlinePage instance = null;

        protected ContentOutlineDescriptor(IConfigurationElement element) throws BackboneException {
            String tagName = "contentoutline";
            this.checkTagName(element, tagName);
            this.className = element.getAttribute(classAttributeName);
            this.actionBarContributorID = element.getAttribute(actionBarContributorIdPropertyName);
            try {
                this.priority = Integer.parseInt(element.getAttribute("priority"));
            }
            catch (NumberFormatException e) {
                this.priority = 0;
            }
            this.element = element;
            if (this.className == null) {
                throw new BadClassNameException("Class name must be set", "contentoutline", classAttributeName);
            }
        }

        public boolean isHigher(ContentOutlineDescriptor found) {
            if (found == null) {
                return true;
            }
            return this.getPriority() > found.getPriority();
        }

        private int getPriority() {
            return this.priority;
        }

        public String getActionBarContributorID() {
            return this.actionBarContributorID;
        }

        protected IPapyrusContentOutlinePage getContentOutline() throws BackboneException {
            if (this.instance == null) {
                this.instance = this.createContentOutlinePage();
            }
            return this.instance;
        }

        private Class<IPapyrusContentOutlinePage> loadClass() throws BadClassNameException {
            Class factoryClass;
            if (this.className == null || this.className.length() == 0) {
                throw new BadClassNameException("Classname should be set.", "contentoutline", classAttributeName);
            }
            try {
                factoryClass = Class.forName(this.className);
            }
            catch (ClassNotFoundException e) {
                try {
                    String declaringID = this.element.getContributor().getName();
                    Bundle bundle = Platform.getBundle((String)declaringID);
                    factoryClass = bundle.loadClass(this.className);
                }
                catch (ClassNotFoundException e1) {
                    throw new BadClassNameException("", "contentoutline", classAttributeName, e1);
                }
            }
            return factoryClass;
        }

        protected IPapyrusContentOutlinePage createContentOutlinePage() throws BackboneException {
            try {
                IPapyrusContentOutlinePage outline = this.loadClass().newInstance();
                outline.init(ContentOutlineRegistry.this.multiEditor);
                return outline;
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (InstantiationException e) {
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
            return null;
        }
    }
}

