/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.editor;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gmf.runtime.diagram.ui.editparts.DiagramEditPart;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditDomain;
import org.eclipse.gmf.runtime.diagram.ui.parts.DiagramEditor;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramGraphicalViewer;
import org.eclipse.gmf.runtime.diagram.ui.parts.IDiagramWorkbenchPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.EditingDomainUndoContext;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.core.Activator;
import org.eclipse.papyrus.core.contentoutline.ContentOutlineRegistry;
import org.eclipse.papyrus.core.contentoutline.IPapyrusContentOutlinePage;
import org.eclipse.papyrus.core.editor.BackboneException;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.lifecycleevents.DoSaveEvent;
import org.eclipse.papyrus.core.lifecycleevents.IEditorInputChangedListener;
import org.eclipse.papyrus.core.lifecycleevents.ISaveAndDirtyService;
import org.eclipse.papyrus.core.multidiagram.actionbarcontributor.ActionBarContributorRegistry;
import org.eclipse.papyrus.core.multidiagram.actionbarcontributor.CoreComposedActionBarContributor;
import org.eclipse.papyrus.core.services.ExtensionServicesRegistry;
import org.eclipse.papyrus.core.services.IService;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServiceMultiException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.resource.ModelMultiException;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.sasheditor.contentprovider.IContentChangedListener;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.ISashWindowsContentProvider;
import org.eclipse.papyrus.sasheditor.contentprovider.di.DiSashModelMngr;
import org.eclipse.papyrus.sasheditor.contentprovider.di.IPageModelFactory;
import org.eclipse.papyrus.sasheditor.contentprovider.di.TransactionalDiSashModelMngr;
import org.eclipse.papyrus.sasheditor.editor.AbstractMultiPageSashEditor;
import org.eclipse.papyrus.sasheditor.editor.IPageChangedListener;
import org.eclipse.papyrus.sasheditor.editor.ISashWindowsContainer;
import org.eclipse.papyrus.sasheditor.editor.SashContainerEventsListener;
import org.eclipse.papyrus.sasheditor.editor.gef.MultiDiagramEditorGefDelegate;
import org.eclipse.ui.IEditorActionBarContributor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CoreMultiDiagramEditor
extends AbstractMultiPageSashEditor
implements IMultiDiagramEditor,
ITabbedPropertySheetPageContributor,
IDiagramWorkbenchPart,
IGotoMarker {
    private MultiDiagramEditorGefDelegate gefAdaptorDelegate;
    private ContentOutlineRegistry contentOutlineRegistry;
    private ServicesRegistry servicesRegistry;
    private ActionBarContributorRegistry actionBarContributorRegistry;
    protected DiSashModelMngr sashModelMngr;
    protected ISaveAndDirtyService saveAndDirtyService;
    protected IEditorInputChangedListener editorInputChangedListener = new IEditorInputChangedListener(){

        public void editorInputChanged(FileEditorInput fileEditorInput) {
            CoreMultiDiagramEditor.this.setInputWithNotify((IEditorInput)fileEditorInput);
            CoreMultiDiagramEditor.this.setPartName(fileEditorInput.getName());
        }

        public void isDirtyChanged() {
            CoreMultiDiagramEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    CoreMultiDiagramEditor.this.firePropertyChange(257);
                }
            });
        }
    };
    private TransactionalEditingDomain transactionalEditingDomain;
    protected ModelSet resourceSet;
    protected DoSaveEvent lifeCycleEvent;
    private TabbedPropertySheetPage tabbedPropertySheetPage = null;
    private IEditingDomainProvider domainProvider = new IEditingDomainProvider(){

        public EditingDomain getEditingDomain() {
            return CoreMultiDiagramEditor.this.transactionalEditingDomain;
        }
    };
    private IContentChangedListener contentChangedListener = new IContentChangedListener(){

        public void contentChanged(IContentChangedListener.ContentEvent event) {
            CoreMultiDiagramEditor.this.refreshTabs();
        }
    };
    private EditingDomainUndoContext undoContext;

    protected ContentOutlineRegistry getContentOutlineRegistry() {
        if (this.contentOutlineRegistry == null) {
            this.createContentOutlineRegistry();
        }
        return this.contentOutlineRegistry;
    }

    private void createContentOutlineRegistry() {
        this.contentOutlineRegistry = new ContentOutlineRegistry(this, "org.eclipse.papyrus.core");
    }

    public ServicesRegistry getServicesRegistry() {
        if (this.servicesRegistry == null) {
            this.servicesRegistry = this.createServicesRegistry();
        }
        return this.servicesRegistry;
    }

    private ServicesRegistry createServicesRegistry() {
        try {
            ExtensionServicesRegistry servicesRegistry = new ExtensionServicesRegistry("org.eclipse.papyrus.core");
            return servicesRegistry;
        }
        catch (ServiceException e) {
            Activator.log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    protected ISashWindowsContentProvider createPageProvider() {
        throw new UnsupportedOperationException("Not implemented. Should not be called as the ContentProvider is already initialized.");
    }

    protected ISashWindowsContentProvider createPageProvider(IPageModelFactory pageFactory, Resource diResource, TransactionalEditingDomain editingDomain) {
        this.sashModelMngr = new TransactionalDiSashModelMngr(pageFactory, diResource, editingDomain);
        ISashWindowsContentProvider pageProvider = this.sashModelMngr.getISashWindowsContentProvider();
        return pageProvider;
    }

    protected IPageMngr getIPageMngr() throws IllegalStateException {
        try {
            return this.sashModelMngr.getIPageMngr();
        }
        catch (Exception e) {
            throw new IllegalStateException("Method should be called after CoreMultiDiagramEditor#init(IEditorSite, IEditorInput) is called");
        }
    }

    protected ActionBarContributorRegistry getActionBarContributorRegistry() {
        if (this.actionBarContributorRegistry != null) {
            return this.actionBarContributorRegistry;
        }
        IEditorActionBarContributor contributor = this.getEditorSite().getActionBarContributor();
        if (contributor instanceof CoreComposedActionBarContributor) {
            Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " - ActionBarContributorRegistry loaded from CoreComposedActionBarContributor.");
            return ((CoreComposedActionBarContributor)contributor).getActionBarContributorRegistry();
        }
        Activator.log.debug(String.valueOf(this.getClass().getSimpleName()) + " - create an ActionBarContributorRegistry.");
        return this.createActionBarContributorRegistry();
    }

    private ActionBarContributorRegistry createActionBarContributorRegistry() {
        return new ActionBarContributorRegistry("org.eclipse.papyrus.core");
    }

    public Object getAdapter(Class adapter) {
        if (ServicesRegistry.class == adapter) {
            return this.getServicesRegistry();
        }
        if (IPageMngr.class == adapter) {
            return this.getIPageMngr();
        }
        if (IPropertySheetPage.class == adapter) {
            return this.getPropertySheetPage();
        }
        if (IContentOutlinePage.class == adapter) {
            try {
                IPapyrusContentOutlinePage contentOutline = this.getContentOutlineRegistry().getContentOutline();
                if (contentOutline != null) {
                    return contentOutline;
                }
            }
            catch (BackboneException e) {
                throw new RuntimeException(e);
            }
        }
        if (EditingDomain.class == adapter) {
            return this.transactionalEditingDomain;
        }
        if (IUndoContext.class == adapter) {
            if (this.undoContext != null) {
                return this.undoContext;
            }
            this.undoContext = new EditingDomainUndoContext((EditingDomain)this.transactionalEditingDomain);
            return this.undoContext;
        }
        if (IEditingDomainProvider.class == adapter) {
            return this.domainProvider;
        }
        if (adapter == ActionRegistry.class) {
            return this.gefAdaptorDelegate.getActionRegistry();
        }
        if (adapter == IDiagramGraphicalViewer.class) {
            IEditorPart activeEditor = this.getActiveEditor();
            if (activeEditor instanceof DiagramEditor) {
                return ((DiagramEditor)activeEditor).getDiagramGraphicalViewer();
            }
            return null;
        }
        return super.getAdapter(adapter);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        BusinessModelResolver.getInstance();
        this.gefAdaptorDelegate = new MultiDiagramEditorGefDelegate();
        this.servicesRegistry = this.createServicesRegistry();
        this.servicesRegistry.add(IMultiDiagramEditor.class, 1, this);
        this.servicesRegistry.add(ActionBarContributorRegistry.class, 1, (IService)this.getActionBarContributorRegistry());
        ComposedAdapterFactory factory = new ComposedAdapterFactory(ComposedAdapterFactory.Descriptor.Registry.INSTANCE);
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)factory){

            public String getText(Object object) {
                IItemLabelProvider itemLabelProvider = (IItemLabelProvider)this.adapterFactory.adapt(object, IItemLabelProvider.class);
                if (object instanceof EObject && ((EObject)object).eIsProxy()) {
                    return "Proxy - " + object;
                }
                return itemLabelProvider != null ? itemLabelProvider.getText(object) : (object == null ? "" : object.toString());
            }
        };
        this.servicesRegistry.add(ILabelProvider.class, 1, labelProvider);
        IFile file = ((IFileEditorInput)input).getFile();
        try {
            ArrayList servicesToStart = new ArrayList(1);
            servicesToStart.add(ModelSet.class);
            this.servicesRegistry.startServicesByClassKeys(servicesToStart);
            this.resourceSet = this.servicesRegistry.getService(ModelSet.class);
            this.resourceSet.loadModels(file);
            this.servicesRegistry.startRegistry();
        }
        catch (ModelMultiException e) {
            Activator.log.error((Throwable)e);
            throw new PartInitException("errors in model", (Throwable)e);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
            throw new PartInitException("could not initialize services", (Throwable)e);
        }
        ISashWindowsContentProvider contentProvider = null;
        try {
            this.transactionalEditingDomain = this.servicesRegistry.getService(TransactionalEditingDomain.class);
            this.sashModelMngr = this.servicesRegistry.getService(DiSashModelMngr.class);
            contentProvider = this.servicesRegistry.getService(ISashWindowsContentProvider.class);
            this.saveAndDirtyService = this.servicesRegistry.getService(ISaveAndDirtyService.class);
        }
        catch (ServiceException e) {
            Activator.log.error("A required service is missing.", (Throwable)e);
            throw new PartInitException("could not initialize services", (Throwable)e);
        }
        this.setContentProvider(contentProvider);
        this.setPartName(file.getName());
        this.sashModelMngr.getSashModelContentChangedProvider().addListener(this.contentChangedListener);
        this.saveAndDirtyService.addInputChangedListener(this.editorInputChangedListener);
    }

    protected void activate() {
        super.activate();
        this.initFolderTabMenus();
        this.getISashWindowsContainer().addPageChangedListener((IPageChangedListener)this.getIPageMngr());
        this.getISashWindowsContainer().addLifeCycleListener((SashContainerEventsListener)this.getIPageMngr());
        try {
            this.getServicesRegistry().add(ISashWindowsContainer.class, 1, this.getISashWindowsContainer());
            this.getServicesRegistry().startServicesByClassKeys(ISashWindowsContainer.class);
        }
        catch (ServiceException e) {
            Activator.log.error((Throwable)e);
        }
    }

    protected void deactivate() {
        super.deactivate();
        this.getISashWindowsContainer().removePageChangedListener((IPageChangedListener)this.getIPageMngr());
    }

    protected void initFolderTabMenus() {
        ISashWindowsContainer container = this.getISashWindowsContainer();
        MenuManager menuManager = new MenuManager("tabmenu");
        menuManager.add((IContributionItem)new Separator("tabcommands"));
        menuManager.add((IContributionItem)new Separator("additions"));
        container.setFolderTabMenuManager(menuManager);
        this.getSite().registerContextMenu("org.eclipse.papyrus.core.editor.ui.tabmenu", menuManager, this.getSite().getSelectionProvider());
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.tabbedPropertySheetPage == null) {
            this.tabbedPropertySheetPage = new TabbedPropertySheetPage((ITabbedPropertySheetPageContributor)this);
        }
        return this.tabbedPropertySheetPage;
    }

    public void dispose() {
        if (this.sashModelMngr != null) {
            this.sashModelMngr.getSashModelContentChangedProvider().removeListener(this.contentChangedListener);
        }
        if (this.resourceSet != null) {
            this.resourceSet.unload();
        }
        if (this.servicesRegistry != null) {
            try {
                this.servicesRegistry.disposeRegistry();
            }
            catch (ServiceMultiException e) {
                Activator.log.error((Throwable)e);
            }
        }
        super.dispose();
    }

    public void doSave(IProgressMonitor monitor) {
        this.saveAndDirtyService.doSave(monitor);
    }

    public boolean isDirty() {
        return this.saveAndDirtyService.isDirty();
    }

    public void doSaveAs() {
        this.saveAndDirtyService.doSaveAs();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public String getContributorId() {
        return "TreeOutlinePage";
    }

    public Diagram getDiagram() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof DiagramEditor) {
            return ((DiagramEditor)activeEditor).getDiagram();
        }
        return null;
    }

    public DiagramEditPart getDiagramEditPart() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor == null) {
            return null;
        }
        if (activeEditor instanceof DiagramEditor) {
            return ((DiagramEditor)activeEditor).getDiagramEditPart();
        }
        return null;
    }

    public IDiagramGraphicalViewer getDiagramGraphicalViewer() {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor instanceof DiagramEditor) {
            return ((DiagramEditor)activeEditor).getDiagramGraphicalViewer();
        }
        return null;
    }

    public EditingDomain getEditingDomain() {
        return this.transactionalEditingDomain;
    }

    public DiagramEditDomain getDiagramEditDomain() {
        throw new UnsupportedOperationException("Not implemented. Should not be called.");
    }

    public void setEditorInput(IEditorInput newInput) {
        this.setInputWithNotify(newInput);
        this.setPartName(newInput.getName());
    }

    public void gotoMarker(IMarker marker) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchPage page = wb.getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = page.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference view = iViewReferenceArray[n2];
            if (view.getId().equals("org.eclipse.papyrus.modelexplorer.modelexplorer")) {
                page.activate(view.getPart(false));
                IWorkbenchPart part = view.getPart(false);
                if (part instanceof IGotoMarker) {
                    ((IGotoMarker)part).gotoMarker(marker);
                }
            }
            ++n2;
        }
    }
}

