/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.editor;

import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.core.editorsfactory.PageModelFactoryRegistry;
import org.eclipse.papyrus.core.extension.diagrameditor.PluggableEditorFactoryReader;
import org.eclipse.papyrus.core.services.IServiceFactory;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.resource.sasheditor.SashModel;
import org.eclipse.papyrus.resource.sasheditor.SashModelUtils;
import org.eclipse.papyrus.sasheditor.contentprovider.di.IPageModelFactory;
import org.eclipse.papyrus.sasheditor.contentprovider.di.TransactionalDiSashModelMngr;

public class DiSashModelMngrServiceFactory
implements IServiceFactory {
    private TransactionalEditingDomain transactionalEditingDomain;
    private SashModel sashModel;
    private TransactionalDiSashModelMngr sashModelMngr;
    private ServicesRegistry servicesRegistry;

    public void init(ServicesRegistry servicesRegistry) throws ServiceException {
        this.servicesRegistry = servicesRegistry;
        this.transactionalEditingDomain = servicesRegistry.getService(TransactionalEditingDomain.class);
        this.sashModel = SashModelUtils.getSashModelChecked(servicesRegistry);
    }

    public void startService() throws ServiceException {
        PageModelFactoryRegistry pageModelRegistry = new PageModelFactoryRegistry();
        PluggableEditorFactoryReader editorReader = new PluggableEditorFactoryReader("org.eclipse.papyrus.core");
        editorReader.populate(pageModelRegistry, this.servicesRegistry);
        if (this.sashModel.getResource() == null) {
            throw new ServiceException("Can't start " + this.getClass().getSimpleName() + "'. Required model (SashModel) should be loaded prior starting the service.");
        }
        this.sashModelMngr = new TransactionalDiSashModelMngr((IPageModelFactory)pageModelRegistry, this.sashModel.getResource(), this.transactionalEditingDomain);
    }

    public void disposeService() throws ServiceException {
    }

    public Object createServiceInstance() throws ServiceException {
        if (this.sashModelMngr == null) {
            this.startService();
        }
        return this.sashModelMngr;
    }
}

