/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.core.editorsfactory;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.papyrus.core.editorsfactory.IEditorFactory;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageModel;
import org.eclipse.papyrus.sasheditor.contentprovider.di.IPageModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PageModelFactoryRegistry
implements IPageModelFactory {
    protected List<IEditorFactory> editorFactories = new ArrayList<IEditorFactory>();

    public IPageModel createIPageModel(Object pageIdentifier) {
        for (IEditorFactory factory : this.getEditorFactories()) {
            if (!factory.isPageModelFactoryFor(pageIdentifier)) continue;
            return factory.createIPageModel(pageIdentifier);
        }
        return null;
    }

    protected List<IEditorFactory> getEditorFactories() {
        return this.editorFactories;
    }

    public void add(IEditorFactory editorFactory) {
        if (editorFactory == null) {
            throw new RuntimeException("Parameter should not be null.");
        }
        this.editorFactories.add(editorFactory);
    }

    public void remove(IEditorFactory editorFactory) {
        this.editorFactories.remove(editorFactory);
    }
}

